/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotroborunner.model.IotRoboRunnerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkersRequest
extends IotRoboRunnerRequest
implements ToCopyableBuilder<Builder, ListWorkersRequest> {
    private static final SdkField<String> SITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("site").getter(ListWorkersRequest.getter(ListWorkersRequest::site)).setter(ListWorkersRequest.setter(Builder::site)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("site").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListWorkersRequest.getter(ListWorkersRequest::maxResults)).setter(ListWorkersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkersRequest.getter(ListWorkersRequest::nextToken)).setter(ListWorkersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> FLEET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleet").getter(ListWorkersRequest.getter(ListWorkersRequest::fleet)).setter(ListWorkersRequest.setter(Builder::fleet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fleet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FLEET_FIELD));
    private final String site;
    private final Integer maxResults;
    private final String nextToken;
    private final String fleet;

    private ListWorkersRequest(BuilderImpl builder) {
        super(builder);
        this.site = builder.site;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.fleet = builder.fleet;
    }

    public final String site() {
        return this.site;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String fleet() {
        return this.fleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.site());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleet());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkersRequest)) {
            return false;
        }
        ListWorkersRequest other = (ListWorkersRequest)((Object)obj);
        return Objects.equals(this.site(), other.site()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.fleet(), other.fleet());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkersRequest").add("Site", (Object)this.site()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Fleet", (Object)this.fleet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "site": {
                return Optional.ofNullable(clazz.cast(this.site()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "fleet": {
                return Optional.ofNullable(clazz.cast(this.fleet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkersRequest, T> g) {
        return obj -> g.apply((ListWorkersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRoboRunnerRequest.BuilderImpl
    implements Builder {
        private String site;
        private Integer maxResults;
        private String nextToken;
        private String fleet;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkersRequest model) {
            super(model);
            this.site(model.site);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.fleet(model.fleet);
        }

        public final String getSite() {
            return this.site;
        }

        public final void setSite(String site) {
            this.site = site;
        }

        @Override
        public final Builder site(String site) {
            this.site = site;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getFleet() {
            return this.fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkersRequest build() {
            return new ListWorkersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRoboRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkersRequest> {
        public Builder site(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder fleet(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

