/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ClientVpcConnection;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.___listOfClientVpcConnectionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClientVpcConnectionsResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, ListClientVpcConnectionsResponse> {
    private static final SdkField<List<ClientVpcConnection>> CLIENT_VPC_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientVpcConnections").getter(ListClientVpcConnectionsResponse.getter(ListClientVpcConnectionsResponse::clientVpcConnections)).setter(ListClientVpcConnectionsResponse.setter(Builder::clientVpcConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcConnections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientVpcConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClientVpcConnectionsResponse.getter(ListClientVpcConnectionsResponse::nextToken)).setter(ListClientVpcConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPC_CONNECTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ClientVpcConnection> clientVpcConnections;
    private final String nextToken;

    private ListClientVpcConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpcConnections = builder.clientVpcConnections;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClientVpcConnections() {
        return this.clientVpcConnections != null && !(this.clientVpcConnections instanceof SdkAutoConstructList);
    }

    public final List<ClientVpcConnection> clientVpcConnections() {
        return this.clientVpcConnections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientVpcConnections() ? this.clientVpcConnections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClientVpcConnectionsResponse)) {
            return false;
        }
        ListClientVpcConnectionsResponse other = (ListClientVpcConnectionsResponse)((Object)obj);
        return this.hasClientVpcConnections() == other.hasClientVpcConnections() && Objects.equals(this.clientVpcConnections(), other.clientVpcConnections()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClientVpcConnectionsResponse").add("ClientVpcConnections", this.hasClientVpcConnections() ? this.clientVpcConnections() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpcConnections": {
                return Optional.ofNullable(clazz.cast(this.clientVpcConnections()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListClientVpcConnectionsResponse, T> g) {
        return obj -> g.apply((ListClientVpcConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private List<ClientVpcConnection> clientVpcConnections = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClientVpcConnectionsResponse model) {
            super(model);
            this.clientVpcConnections(model.clientVpcConnections);
            this.nextToken(model.nextToken);
        }

        public final List<ClientVpcConnection.Builder> getClientVpcConnections() {
            List<ClientVpcConnection.Builder> result = ___listOfClientVpcConnectionCopier.copyToBuilder(this.clientVpcConnections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientVpcConnections(Collection<ClientVpcConnection.BuilderImpl> clientVpcConnections) {
            this.clientVpcConnections = ___listOfClientVpcConnectionCopier.copyFromBuilder(clientVpcConnections);
        }

        @Override
        public final Builder clientVpcConnections(Collection<ClientVpcConnection> clientVpcConnections) {
            this.clientVpcConnections = ___listOfClientVpcConnectionCopier.copy(clientVpcConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpcConnections(ClientVpcConnection ... clientVpcConnections) {
            this.clientVpcConnections(Arrays.asList(clientVpcConnections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpcConnections(Consumer<ClientVpcConnection.Builder> ... clientVpcConnections) {
            this.clientVpcConnections(Stream.of(clientVpcConnections).map(c -> (ClientVpcConnection)((ClientVpcConnection.Builder)ClientVpcConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClientVpcConnectionsResponse build() {
            return new ListClientVpcConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClientVpcConnectionsResponse> {
        public Builder clientVpcConnections(Collection<ClientVpcConnection> var1);

        public Builder clientVpcConnections(ClientVpcConnection ... var1);

        public Builder clientVpcConnections(Consumer<ClientVpcConnection.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

