/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.services.kendraranking.KendraRankingBaseClientBuilder;
import software.amazon.awssdk.services.kendraranking.auth.scheme.KendraRankingAuthSchemeProvider;
import software.amazon.awssdk.services.kendraranking.auth.scheme.internal.KendraRankingAuthSchemeInterceptor;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.KendraRankingRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.kendraranking.endpoints.internal.KendraRankingResolveEndpointInterceptor;
import software.amazon.awssdk.services.kendraranking.internal.KendraRankingServiceClientConfigurationBuilder;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultKendraRankingBaseClientBuilder<B extends KendraRankingBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    private final Map<String, AuthScheme<?>> additionalAuthSchemes = new HashMap();

    DefaultKendraRankingBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "kendra-ranking";
    }

    protected final String serviceName() {
        return "KendraRanking";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)this.defaultAuthSchemeProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEMES, this.authSchemes()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new KendraRankingAuthSchemeInterceptor());
        endpointInterceptors.add(new KendraRankingResolveEndpointInterceptor());
        endpointInterceptors.add(new KendraRankingRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/kendraranking/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.lazyOption((ClientOption)SdkClientOption.IDENTITY_PROVIDERS, c -> {
            IdentityProviders.Builder result = IdentityProviders.builder();
            IdentityProvider credentialsIdentityProvider = (IdentityProvider)c.get((AttributeMap.Key)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            if (credentialsIdentityProvider != null) {
                result.putIdentityProvider(credentialsIdentityProvider);
            }
            return (IdentityProviders)result.build();
        });
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        return builder.build();
    }

    protected final String signingName() {
        return "kendra-ranking";
    }

    private KendraRankingEndpointProvider defaultEndpointProvider() {
        return KendraRankingEndpointProvider.defaultProvider();
    }

    public B authSchemeProvider(KendraRankingAuthSchemeProvider authSchemeProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return (B)((KendraRankingBaseClientBuilder)this.thisBuilder());
    }

    private KendraRankingAuthSchemeProvider defaultAuthSchemeProvider() {
        return KendraRankingAuthSchemeProvider.defaultProvider();
    }

    public B putAuthScheme(AuthScheme<?> authScheme) {
        this.additionalAuthSchemes.put(authScheme.schemeId(), authScheme);
        return (B)((KendraRankingBaseClientBuilder)this.thisBuilder());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap schemes = new HashMap(2 + this.additionalAuthSchemes.size());
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        schemes.put(awsV4AuthScheme.schemeId(), (AuthScheme<?>)awsV4AuthScheme);
        NoAuthAuthScheme noAuthAuthScheme = NoAuthAuthScheme.create();
        schemes.put(noAuthAuthScheme.schemeId(), (AuthScheme<?>)noAuthAuthScheme);
        schemes.putAll(this.additionalAuthSchemes);
        return schemes;
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List<SdkPlugin> internalPlugins = this.internalPlugins(config);
        List externalPlugins = this.plugins();
        if (internalPlugins.isEmpty() && externalPlugins.isEmpty()) {
            return config;
        }
        List plugins = CollectionUtils.mergeLists(internalPlugins, (List)externalPlugins);
        SdkClientConfiguration.Builder configuration = config.toBuilder();
        KendraRankingServiceClientConfigurationBuilder serviceConfigBuilder = new KendraRankingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private List<SdkPlugin> internalPlugins(SdkClientConfiguration config) {
        return Collections.emptyList();
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
    }
}

