/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.keyspaces.KeyspacesClient;
import software.amazon.awssdk.services.keyspaces.model.KeyspaceSummary;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesRequest;
import software.amazon.awssdk.services.keyspaces.model.ListKeyspacesResponse;

public class ListKeyspacesIterable
implements SdkIterable<ListKeyspacesResponse> {
    private final KeyspacesClient client;
    private final ListKeyspacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeyspacesIterable(KeyspacesClient client, ListKeyspacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListKeyspacesResponseFetcher();
    }

    public Iterator<ListKeyspacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KeyspaceSummary> keyspaces() {
        Function<ListKeyspacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.keyspaces() != null) {
                return response.keyspaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKeyspacesResponseFetcher
    implements SyncPageFetcher<ListKeyspacesResponse> {
        private ListKeyspacesResponseFetcher() {
        }

        public boolean hasNextPage(ListKeyspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKeyspacesResponse nextPage(ListKeyspacesResponse previousPage) {
            if (previousPage == null) {
                return ListKeyspacesIterable.this.client.listKeyspaces(ListKeyspacesIterable.this.firstRequest);
            }
            return ListKeyspacesIterable.this.client.listKeyspaces((ListKeyspacesRequest)((Object)ListKeyspacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

