/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacitySpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacitySpecification> {
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("throughputMode").getter(CapacitySpecification.getter(CapacitySpecification::throughputModeAsString)).setter(CapacitySpecification.setter(Builder::throughputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughputMode").build()}).build();
    private static final SdkField<Long> READ_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("readCapacityUnits").getter(CapacitySpecification.getter(CapacitySpecification::readCapacityUnits)).setter(CapacitySpecification.setter(Builder::readCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readCapacityUnits").build()}).build();
    private static final SdkField<Long> WRITE_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("writeCapacityUnits").getter(CapacitySpecification.getter(CapacitySpecification::writeCapacityUnits)).setter(CapacitySpecification.setter(Builder::writeCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeCapacityUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THROUGHPUT_MODE_FIELD, READ_CAPACITY_UNITS_FIELD, WRITE_CAPACITY_UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String throughputMode;
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;

    private CapacitySpecification(BuilderImpl builder) {
        this.throughputMode = builder.throughputMode;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    public final ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public final String throughputModeAsString() {
        return this.throughputMode;
    }

    public final Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public final Long writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeCapacityUnits());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacitySpecification)) {
            return false;
        }
        CapacitySpecification other = (CapacitySpecification)obj;
        return Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.readCapacityUnits(), other.readCapacityUnits()) && Objects.equals(this.writeCapacityUnits(), other.writeCapacityUnits());
    }

    public final String toString() {
        return ToString.builder((String)"CapacitySpecification").add("ThroughputMode", (Object)this.throughputModeAsString()).add("ReadCapacityUnits", (Object)this.readCapacityUnits()).add("WriteCapacityUnits", (Object)this.writeCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "throughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "readCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.readCapacityUnits()));
            }
            case "writeCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.writeCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacitySpecification, T> g) {
        return obj -> g.apply((CapacitySpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String throughputMode;
        private Long readCapacityUnits;
        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacitySpecification model) {
            this.throughputMode(model.throughputMode);
            this.readCapacityUnits(model.readCapacityUnits);
            this.writeCapacityUnits(model.writeCapacityUnits);
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final Long getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public CapacitySpecification build() {
            return new CapacitySpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacitySpecification> {
        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder readCapacityUnits(Long var1);

        public Builder writeCapacityUnits(Long var1);
    }
}

