/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRuntimeManagementConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<PutRuntimeManagementConfigRequest.Builder, PutRuntimeManagementConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(PutRuntimeManagementConfigRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(PutRuntimeManagementConfigRequest::qualifier))
            .setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<String> UPDATE_RUNTIME_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateRuntimeOn").getter(getter(PutRuntimeManagementConfigRequest::updateRuntimeOnAsString))
            .setter(setter(Builder::updateRuntimeOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRuntimeOn").build()).build();

    private static final SdkField<String> RUNTIME_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuntimeVersionArn").getter(getter(PutRuntimeManagementConfigRequest::runtimeVersionArn))
            .setter(setter(Builder::runtimeVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            QUALIFIER_FIELD, UPDATE_RUNTIME_ON_FIELD, RUNTIME_VERSION_ARN_FIELD));

    private final String functionName;

    private final String qualifier;

    private final String updateRuntimeOn;

    private final String runtimeVersionArn;

    private PutRuntimeManagementConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.updateRuntimeOn = builder.updateRuntimeOn;
        this.runtimeVersionArn = builder.runtimeVersionArn;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> – <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name or ARN of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> – <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Specify a version of the function. This can be <code>$LATEST</code> or a published version number. If no value is
     * specified, the configuration for the <code>$LATEST</code> version is returned.
     * </p>
     * 
     * @return Specify a version of the function. This can be <code>$LATEST</code> or a published version number. If no
     *         value is specified, the configuration for the <code>$LATEST</code> version is returned.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * Specify the runtime update mode.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two-phase
     * runtime version rollout</a>. This is the best choice for most customers to ensure they always benefit from
     * runtime updates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure runtime
     * version when you update your function. This approach synchronizes runtime updates with function deployments,
     * giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime
     * update incompatibilities early. When using this setting, you need to regularly update your functions to keep
     * their runtime up-to-date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this runtime
     * version indefinitely. In the rare case where a new runtime version is incompatible with an existing function,
     * this allows you to roll back your function to an earlier runtime version. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll back a
     * runtime version</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateRuntimeOn}
     * will return {@link UpdateRuntimeOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateRuntimeOnAsString}.
     * </p>
     * 
     * @return Specify the runtime update mode.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
     *         href
     *         ="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two-
     *         phase runtime version rollout</a>. This is the best choice for most customers to ensure they always
     *         benefit from runtime updates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure
     *         runtime version when you update your function. This approach synchronizes runtime updates with function
     *         deployments, giving you control over when runtime updates are applied and allowing you to detect and
     *         mitigate rare runtime update incompatibilities early. When using this setting, you need to regularly
     *         update your functions to keep their runtime up-to-date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this
     *         runtime version indefinitely. In the rare case where a new runtime version is incompatible with an
     *         existing function, this allows you to roll back your function to an earlier runtime version. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll
     *         back a runtime version</a>.
     *         </p>
     *         </li>
     * @see UpdateRuntimeOn
     */
    public final UpdateRuntimeOn updateRuntimeOn() {
        return UpdateRuntimeOn.fromValue(updateRuntimeOn);
    }

    /**
     * <p>
     * Specify the runtime update mode.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two-phase
     * runtime version rollout</a>. This is the best choice for most customers to ensure they always benefit from
     * runtime updates.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure runtime
     * version when you update your function. This approach synchronizes runtime updates with function deployments,
     * giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime
     * update incompatibilities early. When using this setting, you need to regularly update your functions to keep
     * their runtime up-to-date.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this runtime
     * version indefinitely. In the rare case where a new runtime version is incompatible with an existing function,
     * this allows you to roll back your function to an earlier runtime version. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll back a
     * runtime version</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateRuntimeOn}
     * will return {@link UpdateRuntimeOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateRuntimeOnAsString}.
     * </p>
     * 
     * @return Specify the runtime update mode.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
     *         href
     *         ="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two-
     *         phase runtime version rollout</a>. This is the best choice for most customers to ensure they always
     *         benefit from runtime updates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure
     *         runtime version when you update your function. This approach synchronizes runtime updates with function
     *         deployments, giving you control over when runtime updates are applied and allowing you to detect and
     *         mitigate rare runtime update incompatibilities early. When using this setting, you need to regularly
     *         update your functions to keep their runtime up-to-date.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this
     *         runtime version indefinitely. In the rare case where a new runtime version is incompatible with an
     *         existing function, this allows you to roll back your function to an earlier runtime version. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll
     *         back a runtime version</a>.
     *         </p>
     *         </li>
     * @see UpdateRuntimeOn
     */
    public final String updateRuntimeOnAsString() {
        return updateRuntimeOn;
    }

    /**
     * <p>
     * The ARN of the runtime version you want the function to use.
     * </p>
     * <note>
     * <p>
     * This is only required if you're using the <b>Manual</b> runtime update mode.
     * </p>
     * </note>
     * 
     * @return The ARN of the runtime version you want the function to use.</p> <note>
     *         <p>
     *         This is only required if you're using the <b>Manual</b> runtime update mode.
     *         </p>
     */
    public final String runtimeVersionArn() {
        return runtimeVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(updateRuntimeOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRuntimeManagementConfigRequest)) {
            return false;
        }
        PutRuntimeManagementConfigRequest other = (PutRuntimeManagementConfigRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(updateRuntimeOnAsString(), other.updateRuntimeOnAsString())
                && Objects.equals(runtimeVersionArn(), other.runtimeVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRuntimeManagementConfigRequest").add("FunctionName", functionName())
                .add("Qualifier", qualifier()).add("UpdateRuntimeOn", updateRuntimeOnAsString())
                .add("RuntimeVersionArn", runtimeVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "UpdateRuntimeOn":
            return Optional.ofNullable(clazz.cast(updateRuntimeOnAsString()));
        case "RuntimeVersionArn":
            return Optional.ofNullable(clazz.cast(runtimeVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRuntimeManagementConfigRequest, T> g) {
        return obj -> g.apply((PutRuntimeManagementConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRuntimeManagementConfigRequest> {
        /**
         * <p>
         * The name or ARN of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> – <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> – <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Specify a version of the function. This can be <code>$LATEST</code> or a published version number. If no
         * value is specified, the configuration for the <code>$LATEST</code> version is returned.
         * </p>
         * 
         * @param qualifier
         *        Specify a version of the function. This can be <code>$LATEST</code> or a published version number. If
         *        no value is specified, the configuration for the <code>$LATEST</code> version is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * Specify the runtime update mode.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase"
         * >Two-phase runtime version rollout</a>. This is the best choice for most customers to ensure they always
         * benefit from runtime updates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure runtime
         * version when you update your function. This approach synchronizes runtime updates with function deployments,
         * giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime
         * update incompatibilities early. When using this setting, you need to regularly update your functions to keep
         * their runtime up-to-date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this
         * runtime version indefinitely. In the rare case where a new runtime version is incompatible with an existing
         * function, this allows you to roll back your function to an earlier runtime version. For more information, see
         * <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll
         * back a runtime version</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateRuntimeOn
         *        Specify the runtime update mode.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
         *        href
         *        ="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two
         *        -phase runtime version rollout</a>. This is the best choice for most customers to ensure they always
         *        benefit from runtime updates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure
         *        runtime version when you update your function. This approach synchronizes runtime updates with
         *        function deployments, giving you control over when runtime updates are applied and allowing you to
         *        detect and mitigate rare runtime update incompatibilities early. When using this setting, you need to
         *        regularly update your functions to keep their runtime up-to-date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Manual</b> - You specify a runtime version in your function configuration. The function will use
         *        this runtime version indefinitely. In the rare case where a new runtime version is incompatible with
         *        an existing function, this allows you to roll back your function to an earlier runtime version. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback"
         *        >Roll back a runtime version</a>.
         *        </p>
         *        </li>
         * @see UpdateRuntimeOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRuntimeOn
         */
        Builder updateRuntimeOn(String updateRuntimeOn);

        /**
         * <p>
         * Specify the runtime update mode.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase"
         * >Two-phase runtime version rollout</a>. This is the best choice for most customers to ensure they always
         * benefit from runtime updates.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure runtime
         * version when you update your function. This approach synchronizes runtime updates with function deployments,
         * giving you control over when runtime updates are applied and allowing you to detect and mitigate rare runtime
         * update incompatibilities early. When using this setting, you need to regularly update your functions to keep
         * their runtime up-to-date.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Manual</b> - You specify a runtime version in your function configuration. The function will use this
         * runtime version indefinitely. In the rare case where a new runtime version is incompatible with an existing
         * function, this allows you to roll back your function to an earlier runtime version. For more information, see
         * <a href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback">Roll
         * back a runtime version</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param updateRuntimeOn
         *        Specify the runtime update mode.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Auto (default)</b> - Automatically update to the most recent and secure runtime version using a <a
         *        href
         *        ="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-two-phase">Two
         *        -phase runtime version rollout</a>. This is the best choice for most customers to ensure they always
         *        benefit from runtime updates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function update</b> - Lambda updates the runtime of your function to the most recent and secure
         *        runtime version when you update your function. This approach synchronizes runtime updates with
         *        function deployments, giving you control over when runtime updates are applied and allowing you to
         *        detect and mitigate rare runtime update incompatibilities early. When using this setting, you need to
         *        regularly update your functions to keep their runtime up-to-date.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Manual</b> - You specify a runtime version in your function configuration. The function will use
         *        this runtime version indefinitely. In the rare case where a new runtime version is incompatible with
         *        an existing function, this allows you to roll back your function to an earlier runtime version. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-update.html#runtime-management-rollback"
         *        >Roll back a runtime version</a>.
         *        </p>
         *        </li>
         * @see UpdateRuntimeOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRuntimeOn
         */
        Builder updateRuntimeOn(UpdateRuntimeOn updateRuntimeOn);

        /**
         * <p>
         * The ARN of the runtime version you want the function to use.
         * </p>
         * <note>
         * <p>
         * This is only required if you're using the <b>Manual</b> runtime update mode.
         * </p>
         * </note>
         * 
         * @param runtimeVersionArn
         *        The ARN of the runtime version you want the function to use.</p> <note>
         *        <p>
         *        This is only required if you're using the <b>Manual</b> runtime update mode.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersionArn(String runtimeVersionArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String qualifier;

        private String updateRuntimeOn;

        private String runtimeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRuntimeManagementConfigRequest model) {
            super(model);
            functionName(model.functionName);
            qualifier(model.qualifier);
            updateRuntimeOn(model.updateRuntimeOn);
            runtimeVersionArn(model.runtimeVersionArn);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getUpdateRuntimeOn() {
            return updateRuntimeOn;
        }

        public final void setUpdateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
        }

        @Override
        public final Builder updateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
            return this;
        }

        @Override
        public final Builder updateRuntimeOn(UpdateRuntimeOn updateRuntimeOn) {
            this.updateRuntimeOn(updateRuntimeOn == null ? null : updateRuntimeOn.toString());
            return this;
        }

        public final String getRuntimeVersionArn() {
            return runtimeVersionArn;
        }

        public final void setRuntimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
        }

        @Override
        public final Builder runtimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRuntimeManagementConfigRequest build() {
            return new PutRuntimeManagementConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
