/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListRecommendedIntentsResponse;

public class ListRecommendedIntentsIterable
implements SdkIterable<ListRecommendedIntentsResponse> {
    private final LexModelsV2Client client;
    private final ListRecommendedIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendedIntentsIterable(LexModelsV2Client client, ListRecommendedIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRecommendedIntentsResponseFetcher();
    }

    public Iterator<ListRecommendedIntentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListRecommendedIntentsResponseFetcher
    implements SyncPageFetcher<ListRecommendedIntentsResponse> {
        private ListRecommendedIntentsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendedIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendedIntentsResponse nextPage(ListRecommendedIntentsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendedIntentsIterable.this.client.listRecommendedIntents(ListRecommendedIntentsIterable.this.firstRequest);
            }
            return ListRecommendedIntentsIterable.this.client.listRecommendedIntents((ListRecommendedIntentsRequest)((Object)ListRecommendedIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

