/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse;

public class ListAggregatedUtterancesPublisher
implements SdkPublisher<ListAggregatedUtterancesResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListAggregatedUtterancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAggregatedUtterancesPublisher(LexModelsV2AsyncClient client, ListAggregatedUtterancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAggregatedUtterancesPublisher(LexModelsV2AsyncClient client, ListAggregatedUtterancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAggregatedUtterancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAggregatedUtterancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAggregatedUtterancesResponseFetcher
    implements AsyncPageFetcher<ListAggregatedUtterancesResponse> {
        private ListAggregatedUtterancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregatedUtterancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAggregatedUtterancesResponse> nextPage(ListAggregatedUtterancesResponse previousPage) {
            if (previousPage == null) {
                return ListAggregatedUtterancesPublisher.this.client.listAggregatedUtterances(ListAggregatedUtterancesPublisher.this.firstRequest);
            }
            return ListAggregatedUtterancesPublisher.this.client.listAggregatedUtterances((ListAggregatedUtterancesRequest)((Object)ListAggregatedUtterancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

