/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTestSetGenerationResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeTestSetGenerationResponse> {
    private static final SdkField<String> TEST_SET_GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetGenerationId").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::testSetGenerationId)).setter(DescribeTestSetGenerationResponse.setter(Builder::testSetGenerationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetGenerationId").build()}).build();
    private static final SdkField<String> TEST_SET_GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetGenerationStatus").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::testSetGenerationStatusAsString)).setter(DescribeTestSetGenerationResponse.setter(Builder::testSetGenerationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetGenerationStatus").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::failureReasons)).setter(DescribeTestSetGenerationResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEST_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetId").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::testSetId)).setter(DescribeTestSetGenerationResponse.setter(Builder::testSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetId").build()}).build();
    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetName").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::testSetName)).setter(DescribeTestSetGenerationResponse.setter(Builder::testSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::description)).setter(DescribeTestSetGenerationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageLocation").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::storageLocation)).setter(DescribeTestSetGenerationResponse.setter(Builder::storageLocation)).constructor(TestSetStorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()}).build();
    private static final SdkField<TestSetGenerationDataSource> GENERATION_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generationDataSource").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::generationDataSource)).setter(DescribeTestSetGenerationResponse.setter(Builder::generationDataSource)).constructor(TestSetGenerationDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationDataSource").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::roleArn)).setter(DescribeTestSetGenerationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::creationDateTime)).setter(DescribeTestSetGenerationResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DescribeTestSetGenerationResponse.getter(DescribeTestSetGenerationResponse::lastUpdatedDateTime)).setter(DescribeTestSetGenerationResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_GENERATION_ID_FIELD, TEST_SET_GENERATION_STATUS_FIELD, FAILURE_REASONS_FIELD, TEST_SET_ID_FIELD, TEST_SET_NAME_FIELD, DESCRIPTION_FIELD, STORAGE_LOCATION_FIELD, GENERATION_DATA_SOURCE_FIELD, ROLE_ARN_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private final String testSetGenerationId;
    private final String testSetGenerationStatus;
    private final List<String> failureReasons;
    private final String testSetId;
    private final String testSetName;
    private final String description;
    private final TestSetStorageLocation storageLocation;
    private final TestSetGenerationDataSource generationDataSource;
    private final String roleArn;
    private final Instant creationDateTime;
    private final Instant lastUpdatedDateTime;

    private DescribeTestSetGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.testSetGenerationId = builder.testSetGenerationId;
        this.testSetGenerationStatus = builder.testSetGenerationStatus;
        this.failureReasons = builder.failureReasons;
        this.testSetId = builder.testSetId;
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.storageLocation = builder.storageLocation;
        this.generationDataSource = builder.generationDataSource;
        this.roleArn = builder.roleArn;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String testSetGenerationId() {
        return this.testSetGenerationId;
    }

    public final TestSetGenerationStatus testSetGenerationStatus() {
        return TestSetGenerationStatus.fromValue(this.testSetGenerationStatus);
    }

    public final String testSetGenerationStatusAsString() {
        return this.testSetGenerationStatus;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final String testSetId() {
        return this.testSetId;
    }

    public final String testSetName() {
        return this.testSetName;
    }

    public final String description() {
        return this.description;
    }

    public final TestSetStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public final TestSetGenerationDataSource generationDataSource() {
        return this.generationDataSource;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetGenerationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetGenerationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestSetGenerationResponse)) {
            return false;
        }
        DescribeTestSetGenerationResponse other = (DescribeTestSetGenerationResponse)((Object)obj);
        return Objects.equals(this.testSetGenerationId(), other.testSetGenerationId()) && Objects.equals(this.testSetGenerationStatusAsString(), other.testSetGenerationStatusAsString()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.testSetId(), other.testSetId()) && Objects.equals(this.testSetName(), other.testSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.storageLocation(), other.storageLocation()) && Objects.equals(this.generationDataSource(), other.generationDataSource()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTestSetGenerationResponse").add("TestSetGenerationId", (Object)this.testSetGenerationId()).add("TestSetGenerationStatus", (Object)this.testSetGenerationStatusAsString()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("TestSetId", (Object)this.testSetId()).add("TestSetName", (Object)this.testSetName()).add("Description", (Object)this.description()).add("StorageLocation", (Object)this.storageLocation()).add("GenerationDataSource", (Object)this.generationDataSource()).add("RoleArn", (Object)this.roleArn()).add("CreationDateTime", (Object)this.creationDateTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSetGenerationId": {
                return Optional.ofNullable(clazz.cast(this.testSetGenerationId()));
            }
            case "testSetGenerationStatus": {
                return Optional.ofNullable(clazz.cast(this.testSetGenerationStatusAsString()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "testSetId": {
                return Optional.ofNullable(clazz.cast(this.testSetId()));
            }
            case "testSetName": {
                return Optional.ofNullable(clazz.cast(this.testSetName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "storageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "generationDataSource": {
                return Optional.ofNullable(clazz.cast(this.generationDataSource()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestSetGenerationResponse, T> g) {
        return obj -> g.apply((DescribeTestSetGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String testSetGenerationId;
        private String testSetGenerationStatus;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private String testSetId;
        private String testSetName;
        private String description;
        private TestSetStorageLocation storageLocation;
        private TestSetGenerationDataSource generationDataSource;
        private String roleArn;
        private Instant creationDateTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestSetGenerationResponse model) {
            super(model);
            this.testSetGenerationId(model.testSetGenerationId);
            this.testSetGenerationStatus(model.testSetGenerationStatus);
            this.failureReasons(model.failureReasons);
            this.testSetId(model.testSetId);
            this.testSetName(model.testSetName);
            this.description(model.description);
            this.storageLocation(model.storageLocation);
            this.generationDataSource(model.generationDataSource);
            this.roleArn(model.roleArn);
            this.creationDateTime(model.creationDateTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getTestSetGenerationId() {
            return this.testSetGenerationId;
        }

        public final void setTestSetGenerationId(String testSetGenerationId) {
            this.testSetGenerationId = testSetGenerationId;
        }

        @Override
        public final Builder testSetGenerationId(String testSetGenerationId) {
            this.testSetGenerationId = testSetGenerationId;
            return this;
        }

        public final String getTestSetGenerationStatus() {
            return this.testSetGenerationStatus;
        }

        public final void setTestSetGenerationStatus(String testSetGenerationStatus) {
            this.testSetGenerationStatus = testSetGenerationStatus;
        }

        @Override
        public final Builder testSetGenerationStatus(String testSetGenerationStatus) {
            this.testSetGenerationStatus = testSetGenerationStatus;
            return this;
        }

        @Override
        public final Builder testSetGenerationStatus(TestSetGenerationStatus testSetGenerationStatus) {
            this.testSetGenerationStatus(testSetGenerationStatus == null ? null : testSetGenerationStatus.toString());
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getTestSetId() {
            return this.testSetId;
        }

        public final void setTestSetId(String testSetId) {
            this.testSetId = testSetId;
        }

        @Override
        public final Builder testSetId(String testSetId) {
            this.testSetId = testSetId;
            return this;
        }

        public final String getTestSetName() {
            return this.testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final TestSetGenerationDataSource.Builder getGenerationDataSource() {
            return this.generationDataSource != null ? this.generationDataSource.toBuilder() : null;
        }

        public final void setGenerationDataSource(TestSetGenerationDataSource.BuilderImpl generationDataSource) {
            this.generationDataSource = generationDataSource != null ? generationDataSource.build() : null;
        }

        @Override
        public final Builder generationDataSource(TestSetGenerationDataSource generationDataSource) {
            this.generationDataSource = generationDataSource;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeTestSetGenerationResponse build() {
            return new DescribeTestSetGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTestSetGenerationResponse> {
        public Builder testSetGenerationId(String var1);

        public Builder testSetGenerationStatus(String var1);

        public Builder testSetGenerationStatus(TestSetGenerationStatus var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder testSetId(String var1);

        public Builder testSetName(String var1);

        public Builder description(String var1);

        public Builder storageLocation(TestSetStorageLocation var1);

        default public Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return this.storageLocation((TestSetStorageLocation)((TestSetStorageLocation.Builder)TestSetStorageLocation.builder().applyMutation(storageLocation)).build());
        }

        public Builder generationDataSource(TestSetGenerationDataSource var1);

        default public Builder generationDataSource(Consumer<TestSetGenerationDataSource.Builder> generationDataSource) {
            return this.generationDataSource((TestSetGenerationDataSource)((TestSetGenerationDataSource.Builder)TestSetGenerationDataSource.builder().applyMutation(generationDataSource)).build());
        }

        public Builder roleArn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

