/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Effect {
    ALLOW("Allow"),
    DENY("Deny"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Effect> VALUE_MAP;
    private final String value;

    private Effect(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Effect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Effect> knownValues() {
        EnumSet<Effect> knownValues = EnumSet.allOf(Effect.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Effect.class, Effect::toString);
    }
}

