/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupByListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentGroupBySpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetric;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentMetricsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntentMetricsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListIntentMetricsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::botId)).setter(ListIntentMetricsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDateTime").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::startDateTime)).setter(ListIntentMetricsRequest.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDateTime").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::endDateTime)).setter(ListIntentMetricsRequest.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<List<AnalyticsIntentMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metrics").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::metrics)).setter(ListIntentMetricsRequest.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsBinBySpecification>> BIN_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binBy").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::binBy)).setter(ListIntentMetricsRequest.setter(Builder::binBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinBySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentGroupBySpecification>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupBy").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::groupBy)).setter(ListIntentMetricsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentGroupBySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsIntentFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::filters)).setter(ListIntentMetricsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsIntentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::maxResults)).setter(ListIntentMetricsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIntentMetricsRequest.getter(ListIntentMetricsRequest::nextToken)).setter(ListIntentMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, METRICS_FIELD, BIN_BY_FIELD, GROUP_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String botId;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final List<AnalyticsIntentMetric> metrics;
    private final List<AnalyticsBinBySpecification> binBy;
    private final List<AnalyticsIntentGroupBySpecification> groupBy;
    private final List<AnalyticsIntentFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListIntentMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.metrics = builder.metrics;
        this.binBy = builder.binBy;
        this.groupBy = builder.groupBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentMetric> metrics() {
        return this.metrics;
    }

    public final boolean hasBinBy() {
        return this.binBy != null && !(this.binBy instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinBySpecification> binBy() {
        return this.binBy;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentGroupBySpecification> groupBy() {
        return this.groupBy;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsIntentFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinBy() ? this.binBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntentMetricsRequest)) {
            return false;
        }
        ListIntentMetricsRequest other = (ListIntentMetricsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasBinBy() == other.hasBinBy() && Objects.equals(this.binBy(), other.binBy()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntentMetricsRequest").add("BotId", (Object)this.botId()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("BinBy", this.hasBinBy() ? this.binBy() : null).add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "startDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "binBy": {
                return Optional.ofNullable(clazz.cast(this.binBy()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntentMetricsRequest, T> g) {
        return obj -> g.apply((ListIntentMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private Instant startDateTime;
        private Instant endDateTime;
        private List<AnalyticsIntentMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsBinBySpecification> binBy = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentGroupBySpecification> groupBy = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsIntentFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntentMetricsRequest model) {
            super(model);
            this.botId(model.botId);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.metrics(model.metrics);
            this.binBy(model.binBy);
            this.groupBy(model.groupBy);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final List<AnalyticsIntentMetric.Builder> getMetrics() {
            List<AnalyticsIntentMetric.Builder> result = AnalyticsIntentMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<AnalyticsIntentMetric.BuilderImpl> metrics) {
            this.metrics = AnalyticsIntentMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<AnalyticsIntentMetric> metrics) {
            this.metrics = AnalyticsIntentMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(AnalyticsIntentMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<AnalyticsIntentMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (AnalyticsIntentMetric)((AnalyticsIntentMetric.Builder)AnalyticsIntentMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsBinBySpecification.Builder> getBinBy() {
            List<AnalyticsBinBySpecification.Builder> result = AnalyticsBinByListCopier.copyToBuilder(this.binBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinBy(Collection<AnalyticsBinBySpecification.BuilderImpl> binBy) {
            this.binBy = AnalyticsBinByListCopier.copyFromBuilder(binBy);
        }

        @Override
        public final Builder binBy(Collection<AnalyticsBinBySpecification> binBy) {
            this.binBy = AnalyticsBinByListCopier.copy(binBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(AnalyticsBinBySpecification ... binBy) {
            this.binBy(Arrays.asList(binBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(Consumer<AnalyticsBinBySpecification.Builder> ... binBy) {
            this.binBy(Stream.of(binBy).map(c -> (AnalyticsBinBySpecification)((AnalyticsBinBySpecification.Builder)AnalyticsBinBySpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentGroupBySpecification.Builder> getGroupBy() {
            List<AnalyticsIntentGroupBySpecification.Builder> result = AnalyticsIntentGroupByListCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<AnalyticsIntentGroupBySpecification.BuilderImpl> groupBy) {
            this.groupBy = AnalyticsIntentGroupByListCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<AnalyticsIntentGroupBySpecification> groupBy) {
            this.groupBy = AnalyticsIntentGroupByListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(AnalyticsIntentGroupBySpecification ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<AnalyticsIntentGroupBySpecification.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (AnalyticsIntentGroupBySpecification)((AnalyticsIntentGroupBySpecification.Builder)AnalyticsIntentGroupBySpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentFilter.Builder> getFilters() {
            List<AnalyticsIntentFilter.Builder> result = AnalyticsIntentFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsIntentFilter.BuilderImpl> filters) {
            this.filters = AnalyticsIntentFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsIntentFilter> filters) {
            this.filters = AnalyticsIntentFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsIntentFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsIntentFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AnalyticsIntentFilter)((AnalyticsIntentFilter.Builder)AnalyticsIntentFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIntentMetricsRequest build() {
            return new ListIntentMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntentMetricsRequest> {
        public Builder botId(String var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder metrics(Collection<AnalyticsIntentMetric> var1);

        public Builder metrics(AnalyticsIntentMetric ... var1);

        public Builder metrics(Consumer<AnalyticsIntentMetric.Builder> ... var1);

        public Builder binBy(Collection<AnalyticsBinBySpecification> var1);

        public Builder binBy(AnalyticsBinBySpecification ... var1);

        public Builder binBy(Consumer<AnalyticsBinBySpecification.Builder> ... var1);

        public Builder groupBy(Collection<AnalyticsIntentGroupBySpecification> var1);

        public Builder groupBy(AnalyticsIntentGroupBySpecification ... var1);

        public Builder groupBy(Consumer<AnalyticsIntentGroupBySpecification.Builder> ... var1);

        public Builder filters(Collection<AnalyticsIntentFilter> var1);

        public Builder filters(AnalyticsIntentFilter ... var1);

        public Builder filters(Consumer<AnalyticsIntentFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

