/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentsResponse;

public class ListIntentsPublisher
implements SdkPublisher<ListIntentsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListIntentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIntentsPublisher(LexModelsV2AsyncClient client, ListIntentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIntentsPublisher(LexModelsV2AsyncClient client, ListIntentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIntentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIntentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListIntentsResponseFetcher
    implements AsyncPageFetcher<ListIntentsResponse> {
        private ListIntentsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIntentsResponse> nextPage(ListIntentsResponse previousPage) {
            if (previousPage == null) {
                return ListIntentsPublisher.this.client.listIntents(ListIntentsPublisher.this.firstRequest);
            }
            return ListIntentsPublisher.this.client.listIntents((ListIntentsRequest)((Object)ListIntentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

