/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotResourceGenerationsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotResourceGenerationsResponse;

public class ListBotResourceGenerationsPublisher
implements SdkPublisher<ListBotResourceGenerationsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBotResourceGenerationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotResourceGenerationsPublisher(LexModelsV2AsyncClient client, ListBotResourceGenerationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotResourceGenerationsPublisher(LexModelsV2AsyncClient client, ListBotResourceGenerationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotResourceGenerationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotResourceGenerationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotResourceGenerationsResponseFetcher
    implements AsyncPageFetcher<ListBotResourceGenerationsResponse> {
        private ListBotResourceGenerationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotResourceGenerationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotResourceGenerationsResponse> nextPage(ListBotResourceGenerationsResponse previousPage) {
            if (previousPage == null) {
                return ListBotResourceGenerationsPublisher.this.client.listBotResourceGenerations(ListBotResourceGenerationsPublisher.this.firstRequest);
            }
            return ListBotResourceGenerationsPublisher.this.client.listBotResourceGenerations((ListBotResourceGenerationsRequest)((Object)ListBotResourceGenerationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

