/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.waiters.LexModelsV2AsyncWaiter;
import software.amazon.awssdk.services.lexmodelsv2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultLexModelsV2AsyncWaiter
implements LexModelsV2AsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final LexModelsV2AsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeBotResponse> botAvailableWaiter;
    private final AsyncWaiter<DescribeBotAliasResponse> botAliasAvailableWaiter;
    private final AsyncWaiter<DescribeExportResponse> botExportCompletedWaiter;
    private final AsyncWaiter<DescribeImportResponse> botImportCompletedWaiter;
    private final AsyncWaiter<DescribeBotLocaleResponse> botLocaleBuiltWaiter;
    private final AsyncWaiter<DescribeBotLocaleResponse> botLocaleExpressTestingAvailableWaiter;
    private final AsyncWaiter<DescribeBotVersionResponse> botVersionAvailableWaiter;
    private final AsyncWaiter<DescribeBotLocaleResponse> botLocaleCreatedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultLexModelsV2AsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (LexModelsV2AsyncClient)LexModelsV2AsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.botAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBotResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botAliasAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBotAliasResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botAliasAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botAliasAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botExportCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeExportResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botExportCompletedWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botExportCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botImportCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeImportResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botImportCompletedWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botImportCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botLocaleBuiltWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBotLocaleResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botLocaleBuiltWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botLocaleBuiltWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botLocaleExpressTestingAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBotLocaleResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botLocaleExpressTestingAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botLocaleExpressTestingAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botVersionAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBotVersionResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botVersionAvailableWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botVersionAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.botLocaleCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeBotLocaleResponse.class).acceptors(DefaultLexModelsV2AsyncWaiter.botLocaleCreatedWaiterAcceptors())).overrideConfiguration(DefaultLexModelsV2AsyncWaiter.botLocaleCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotAliasResponse>> waitUntilBotAliasAvailable(DescribeBotAliasRequest describeBotAliasRequest) {
        return this.botAliasAvailableWaiter.runAsync(() -> this.client.describeBotAlias(this.applyWaitersUserAgent(describeBotAliasRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotAliasResponse>> waitUntilBotAliasAvailable(DescribeBotAliasRequest describeBotAliasRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botAliasAvailableWaiter.runAsync(() -> this.client.describeBotAlias(this.applyWaitersUserAgent(describeBotAliasRequest)), DefaultLexModelsV2AsyncWaiter.botAliasAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotResponse>> waitUntilBotAvailable(DescribeBotRequest describeBotRequest) {
        return this.botAvailableWaiter.runAsync(() -> this.client.describeBot(this.applyWaitersUserAgent(describeBotRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotResponse>> waitUntilBotAvailable(DescribeBotRequest describeBotRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botAvailableWaiter.runAsync(() -> this.client.describeBot(this.applyWaitersUserAgent(describeBotRequest)), DefaultLexModelsV2AsyncWaiter.botAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeExportResponse>> waitUntilBotExportCompleted(DescribeExportRequest describeExportRequest) {
        return this.botExportCompletedWaiter.runAsync(() -> this.client.describeExport(this.applyWaitersUserAgent(describeExportRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeExportResponse>> waitUntilBotExportCompleted(DescribeExportRequest describeExportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botExportCompletedWaiter.runAsync(() -> this.client.describeExport(this.applyWaitersUserAgent(describeExportRequest)), DefaultLexModelsV2AsyncWaiter.botExportCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImportResponse>> waitUntilBotImportCompleted(DescribeImportRequest describeImportRequest) {
        return this.botImportCompletedWaiter.runAsync(() -> this.client.describeImport(this.applyWaitersUserAgent(describeImportRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeImportResponse>> waitUntilBotImportCompleted(DescribeImportRequest describeImportRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botImportCompletedWaiter.runAsync(() -> this.client.describeImport(this.applyWaitersUserAgent(describeImportRequest)), DefaultLexModelsV2AsyncWaiter.botImportCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleBuilt(DescribeBotLocaleRequest describeBotLocaleRequest) {
        return this.botLocaleBuiltWaiter.runAsync(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleBuilt(DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botLocaleBuiltWaiter.runAsync(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)), DefaultLexModelsV2AsyncWaiter.botLocaleBuiltWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleCreated(DescribeBotLocaleRequest describeBotLocaleRequest) {
        return this.botLocaleCreatedWaiter.runAsync(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleCreated(DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botLocaleCreatedWaiter.runAsync(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)), DefaultLexModelsV2AsyncWaiter.botLocaleCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleExpressTestingAvailable(DescribeBotLocaleRequest describeBotLocaleRequest) {
        return this.botLocaleExpressTestingAvailableWaiter.runAsync(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleExpressTestingAvailable(DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botLocaleExpressTestingAvailableWaiter.runAsync(() -> this.client.describeBotLocale(this.applyWaitersUserAgent(describeBotLocaleRequest)), DefaultLexModelsV2AsyncWaiter.botLocaleExpressTestingAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotVersionResponse>> waitUntilBotVersionAvailable(DescribeBotVersionRequest describeBotVersionRequest) {
        return this.botVersionAvailableWaiter.runAsync(() -> this.client.describeBotVersion(this.applyWaitersUserAgent(describeBotVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeBotVersionResponse>> waitUntilBotVersionAvailable(DescribeBotVersionRequest describeBotVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.botVersionAvailableWaiter.runAsync(() -> this.client.describeBotVersion(this.applyWaitersUserAgent(describeBotVersionRequest)), DefaultLexModelsV2AsyncWaiter.botVersionAvailableWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeBotResponse>> botAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Available");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Inactive");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Inactive) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotAliasResponse>> botAliasAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotAliasResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotAliasResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botAliasStatus").value(), "Available");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botAliasStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botAliasStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botAliasStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botAliasStatus=Deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportResponse>> botExportCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("exportStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("exportStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (exportStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("exportStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (exportStatus=Failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImportResponse>> botImportCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImportResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImportResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("importStatus").value(), "Completed");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("importStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (importStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("importStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (importStatus=Failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotLocaleResponse>> botLocaleBuiltWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Built");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "NotBuilt");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=NotBuilt) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotLocaleResponse>> botLocaleExpressTestingAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Built");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "ReadyExpressTesting");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "NotBuilt");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=NotBuilt) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotVersionResponse>> botVersionAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotVersionResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Available");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botStatus=Failed) and transitioned the waiter to failure state"));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBotLocaleResponse>> botLocaleCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBotLocaleResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Built");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "ReadyExpressTesting");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "NotBuilt");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Deleting");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("botLocaleStatus").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (botLocaleStatus=Failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration botAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botAliasAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botExportCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botImportCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botLocaleBuiltWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botLocaleExpressTestingAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botVersionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration botLocaleCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(35);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(10L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static LexModelsV2AsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends LexModelsV2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((LexModelsV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements LexModelsV2AsyncWaiter.Builder {
        private LexModelsV2AsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public LexModelsV2AsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public LexModelsV2AsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public LexModelsV2AsyncWaiter.Builder client(LexModelsV2AsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public LexModelsV2AsyncWaiter build() {
            return new DefaultLexModelsV2AsyncWaiter(this);
        }
    }
}

