/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse;

public class ListBotAliasesPublisher
implements SdkPublisher<ListBotAliasesResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBotAliasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotAliasesPublisher(LexModelsV2AsyncClient client, ListBotAliasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotAliasesPublisher(LexModelsV2AsyncClient client, ListBotAliasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotAliasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotAliasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotAliasesResponseFetcher
    implements AsyncPageFetcher<ListBotAliasesResponse> {
        private ListBotAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListBotAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotAliasesResponse> nextPage(ListBotAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListBotAliasesPublisher.this.client.listBotAliases(ListBotAliasesPublisher.this.firstRequest);
            }
            return ListBotAliasesPublisher.this.client.listBotAliases((ListBotAliasesRequest)((Object)ListBotAliasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

