/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlueprintType {
    OS("os"),
    APP("app"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlueprintType> VALUE_MAP;
    private final String value;

    private BlueprintType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlueprintType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlueprintType> knownValues() {
        EnumSet<BlueprintType> knownValues = EnumSet.allOf(BlueprintType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlueprintType.class, BlueprintType::toString);
    }
}

