/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CertificateSummary;
import software.amazon.awssdk.services.lightsail.model.CertificateSummaryListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCertificatesResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetCertificatesResponse> {
    private static final SdkField<List<CertificateSummary>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificates").getter(GetCertificatesResponse.getter(GetCertificatesResponse::certificates)).setter(GetCertificatesResponse.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetCertificatesResponse.getter(GetCertificatesResponse::nextPageToken)).setter(GetCertificatesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<CertificateSummary> certificates;
    private final String nextPageToken;

    private GetCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public final List<CertificateSummary> certificates() {
        return this.certificates;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificates() ? this.certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificatesResponse)) {
            return false;
        }
        GetCertificatesResponse other = (GetCertificatesResponse)((Object)obj);
        return this.hasCertificates() == other.hasCertificates() && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCertificatesResponse").add("Certificates", this.hasCertificates() ? this.certificates() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificatesResponse, T> g) {
        return obj -> g.apply((GetCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<CertificateSummary> certificates = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificatesResponse model) {
            super(model);
            this.certificates(model.certificates);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<CertificateSummary.Builder> getCertificates() {
            List<CertificateSummary.Builder> result = CertificateSummaryListCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<CertificateSummary.BuilderImpl> certificates) {
            this.certificates = CertificateSummaryListCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<CertificateSummary> certificates) {
            this.certificates = CertificateSummaryListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(CertificateSummary ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<CertificateSummary.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (CertificateSummary)((CertificateSummary.Builder)CertificateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetCertificatesResponse build() {
            return new GetCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCertificatesResponse> {
        public Builder certificates(Collection<CertificateSummary> var1);

        public Builder certificates(CertificateSummary ... var1);

        public Builder certificates(Consumer<CertificateSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

