/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.CertificateDomainValidationStatus;
import software.amazon.awssdk.services.lightsail.model.DnsRecordCreationState;
import software.amazon.awssdk.services.lightsail.model.ResourceRecord;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainValidationRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainValidationRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DomainValidationRecord.getter(DomainValidationRecord::domainName)).setter(DomainValidationRecord.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<ResourceRecord> RESOURCE_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceRecord").getter(DomainValidationRecord.getter(DomainValidationRecord::resourceRecord)).setter(DomainValidationRecord.setter(Builder::resourceRecord)).constructor(ResourceRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRecord").build()}).build();
    private static final SdkField<DnsRecordCreationState> DNS_RECORD_CREATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dnsRecordCreationState").getter(DomainValidationRecord.getter(DomainValidationRecord::dnsRecordCreationState)).setter(DomainValidationRecord.setter(Builder::dnsRecordCreationState)).constructor(DnsRecordCreationState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsRecordCreationState").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationStatus").getter(DomainValidationRecord.getter(DomainValidationRecord::validationStatusAsString)).setter(DomainValidationRecord.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RESOURCE_RECORD_FIELD, DNS_RECORD_CREATION_STATE_FIELD, VALIDATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainName", DOMAIN_NAME_FIELD);
            this.put("resourceRecord", RESOURCE_RECORD_FIELD);
            this.put("dnsRecordCreationState", DNS_RECORD_CREATION_STATE_FIELD);
            this.put("validationStatus", VALIDATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final ResourceRecord resourceRecord;
    private final DnsRecordCreationState dnsRecordCreationState;
    private final String validationStatus;

    private DomainValidationRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.resourceRecord = builder.resourceRecord;
        this.dnsRecordCreationState = builder.dnsRecordCreationState;
        this.validationStatus = builder.validationStatus;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ResourceRecord resourceRecord() {
        return this.resourceRecord;
    }

    public final DnsRecordCreationState dnsRecordCreationState() {
        return this.dnsRecordCreationState;
    }

    public final CertificateDomainValidationStatus validationStatus() {
        return CertificateDomainValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecord());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRecordCreationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationRecord)) {
            return false;
        }
        DomainValidationRecord other = (DomainValidationRecord)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.resourceRecord(), other.resourceRecord()) && Objects.equals(this.dnsRecordCreationState(), other.dnsRecordCreationState()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DomainValidationRecord").add("DomainName", (Object)this.domainName()).add("ResourceRecord", (Object)this.resourceRecord()).add("DnsRecordCreationState", (Object)this.dnsRecordCreationState()).add("ValidationStatus", (Object)this.validationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "resourceRecord": {
                return Optional.ofNullable(clazz.cast(this.resourceRecord()));
            }
            case "dnsRecordCreationState": {
                return Optional.ofNullable(clazz.cast(this.dnsRecordCreationState()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DomainValidationRecord, T> g) {
        return obj -> g.apply((DomainValidationRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private ResourceRecord resourceRecord;
        private DnsRecordCreationState dnsRecordCreationState;
        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationRecord model) {
            this.domainName(model.domainName);
            this.resourceRecord(model.resourceRecord);
            this.dnsRecordCreationState(model.dnsRecordCreationState);
            this.validationStatus(model.validationStatus);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ResourceRecord.Builder getResourceRecord() {
            return this.resourceRecord != null ? this.resourceRecord.toBuilder() : null;
        }

        public final void setResourceRecord(ResourceRecord.BuilderImpl resourceRecord) {
            this.resourceRecord = resourceRecord != null ? resourceRecord.build() : null;
        }

        @Override
        public final Builder resourceRecord(ResourceRecord resourceRecord) {
            this.resourceRecord = resourceRecord;
            return this;
        }

        public final DnsRecordCreationState.Builder getDnsRecordCreationState() {
            return this.dnsRecordCreationState != null ? this.dnsRecordCreationState.toBuilder() : null;
        }

        public final void setDnsRecordCreationState(DnsRecordCreationState.BuilderImpl dnsRecordCreationState) {
            this.dnsRecordCreationState = dnsRecordCreationState != null ? dnsRecordCreationState.build() : null;
        }

        @Override
        public final Builder dnsRecordCreationState(DnsRecordCreationState dnsRecordCreationState) {
            this.dnsRecordCreationState = dnsRecordCreationState;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(CertificateDomainValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public DomainValidationRecord build() {
            return new DomainValidationRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainValidationRecord> {
        public Builder domainName(String var1);

        public Builder resourceRecord(ResourceRecord var1);

        default public Builder resourceRecord(Consumer<ResourceRecord.Builder> resourceRecord) {
            return this.resourceRecord((ResourceRecord)((ResourceRecord.Builder)ResourceRecord.builder().applyMutation(resourceRecord)).build());
        }

        public Builder dnsRecordCreationState(DnsRecordCreationState var1);

        default public Builder dnsRecordCreationState(Consumer<DnsRecordCreationState.Builder> dnsRecordCreationState) {
            return this.dnsRecordCreationState((DnsRecordCreationState)((DnsRecordCreationState.Builder)DnsRecordCreationState.builder().applyMutation(dnsRecordCreationState)).build());
        }

        public Builder validationStatus(String var1);

        public Builder validationStatus(CertificateDomainValidationStatus var1);
    }
}

