/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.AddOnRequest;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableAddOnRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, EnableAddOnRequest> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(EnableAddOnRequest.getter(EnableAddOnRequest::resourceName)).setter(EnableAddOnRequest.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<AddOnRequest> ADD_ON_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("addOnRequest").getter(EnableAddOnRequest.getter(EnableAddOnRequest::addOnRequest)).setter(EnableAddOnRequest.setter(Builder::addOnRequest)).constructor(AddOnRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOnRequest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, ADD_ON_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("resourceName", RESOURCE_NAME_FIELD);
            this.put("addOnRequest", ADD_ON_REQUEST_FIELD);
        }
    });
    private final String resourceName;
    private final AddOnRequest addOnRequest;

    private EnableAddOnRequest(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.addOnRequest = builder.addOnRequest;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final AddOnRequest addOnRequest() {
        return this.addOnRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.addOnRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableAddOnRequest)) {
            return false;
        }
        EnableAddOnRequest other = (EnableAddOnRequest)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.addOnRequest(), other.addOnRequest());
    }

    public final String toString() {
        return ToString.builder((String)"EnableAddOnRequest").add("ResourceName", (Object)this.resourceName()).add("AddOnRequest", (Object)this.addOnRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "addOnRequest": {
                return Optional.ofNullable(clazz.cast(this.addOnRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnableAddOnRequest, T> g) {
        return obj -> g.apply((EnableAddOnRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String resourceName;
        private AddOnRequest addOnRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableAddOnRequest model) {
            super(model);
            this.resourceName(model.resourceName);
            this.addOnRequest(model.addOnRequest);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final AddOnRequest.Builder getAddOnRequest() {
            return this.addOnRequest != null ? this.addOnRequest.toBuilder() : null;
        }

        public final void setAddOnRequest(AddOnRequest.BuilderImpl addOnRequest) {
            this.addOnRequest = addOnRequest != null ? addOnRequest.build() : null;
        }

        @Override
        public final Builder addOnRequest(AddOnRequest addOnRequest) {
            this.addOnRequest = addOnRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableAddOnRequest build() {
            return new EnableAddOnRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableAddOnRequest> {
        public Builder resourceName(String var1);

        public Builder addOnRequest(AddOnRequest var1);

        default public Builder addOnRequest(Consumer<AddOnRequest.Builder> addOnRequest) {
            return this.addOnRequest((AddOnRequest)((AddOnRequest.Builder)AddOnRequest.builder().applyMutation(addOnRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

