/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalDatabaseBundle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalDatabaseBundle> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::bundleId)).setter(RelationalDatabaseBundle.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::name)).setter(RelationalDatabaseBundle.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Float> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("price").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::price)).setter(RelationalDatabaseBundle.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()}).build();
    private static final SdkField<Float> RAM_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("ramSizeInGb").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::ramSizeInGb)).setter(RelationalDatabaseBundle.setter(Builder::ramSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramSizeInGb").build()}).build();
    private static final SdkField<Integer> DISK_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("diskSizeInGb").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::diskSizeInGb)).setter(RelationalDatabaseBundle.setter(Builder::diskSizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskSizeInGb").build()}).build();
    private static final SdkField<Integer> TRANSFER_PER_MONTH_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("transferPerMonthInGb").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::transferPerMonthInGb)).setter(RelationalDatabaseBundle.setter(Builder::transferPerMonthInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferPerMonthInGb").build()}).build();
    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCount").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::cpuCount)).setter(RelationalDatabaseBundle.setter(Builder::cpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()}).build();
    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isEncrypted").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::isEncrypted)).setter(RelationalDatabaseBundle.setter(Builder::isEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEncrypted").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(RelationalDatabaseBundle.getter(RelationalDatabaseBundle::isActive)).setter(RelationalDatabaseBundle.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, NAME_FIELD, PRICE_FIELD, RAM_SIZE_IN_GB_FIELD, DISK_SIZE_IN_GB_FIELD, TRANSFER_PER_MONTH_IN_GB_FIELD, CPU_COUNT_FIELD, IS_ENCRYPTED_FIELD, IS_ACTIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("bundleId", BUNDLE_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("price", PRICE_FIELD);
            this.put("ramSizeInGb", RAM_SIZE_IN_GB_FIELD);
            this.put("diskSizeInGb", DISK_SIZE_IN_GB_FIELD);
            this.put("transferPerMonthInGb", TRANSFER_PER_MONTH_IN_GB_FIELD);
            this.put("cpuCount", CPU_COUNT_FIELD);
            this.put("isEncrypted", IS_ENCRYPTED_FIELD);
            this.put("isActive", IS_ACTIVE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bundleId;
    private final String name;
    private final Float price;
    private final Float ramSizeInGb;
    private final Integer diskSizeInGb;
    private final Integer transferPerMonthInGb;
    private final Integer cpuCount;
    private final Boolean isEncrypted;
    private final Boolean isActive;

    private RelationalDatabaseBundle(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.name = builder.name;
        this.price = builder.price;
        this.ramSizeInGb = builder.ramSizeInGb;
        this.diskSizeInGb = builder.diskSizeInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
        this.cpuCount = builder.cpuCount;
        this.isEncrypted = builder.isEncrypted;
        this.isActive = builder.isActive;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String name() {
        return this.name;
    }

    public final Float price() {
        return this.price;
    }

    public final Float ramSizeInGb() {
        return this.ramSizeInGb;
    }

    public final Integer diskSizeInGb() {
        return this.diskSizeInGb;
    }

    public final Integer transferPerMonthInGb() {
        return this.transferPerMonthInGb;
    }

    public final Integer cpuCount() {
        return this.cpuCount;
    }

    public final Boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferPerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalDatabaseBundle)) {
            return false;
        }
        RelationalDatabaseBundle other = (RelationalDatabaseBundle)obj;
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.price(), other.price()) && Objects.equals(this.ramSizeInGb(), other.ramSizeInGb()) && Objects.equals(this.diskSizeInGb(), other.diskSizeInGb()) && Objects.equals(this.transferPerMonthInGb(), other.transferPerMonthInGb()) && Objects.equals(this.cpuCount(), other.cpuCount()) && Objects.equals(this.isEncrypted(), other.isEncrypted()) && Objects.equals(this.isActive(), other.isActive());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalDatabaseBundle").add("BundleId", (Object)this.bundleId()).add("Name", (Object)this.name()).add("Price", (Object)this.price()).add("RamSizeInGb", (Object)this.ramSizeInGb()).add("DiskSizeInGb", (Object)this.diskSizeInGb()).add("TransferPerMonthInGb", (Object)this.transferPerMonthInGb()).add("CpuCount", (Object)this.cpuCount()).add("IsEncrypted", (Object)this.isEncrypted()).add("IsActive", (Object)this.isActive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "ramSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.ramSizeInGb()));
            }
            case "diskSizeInGb": {
                return Optional.ofNullable(clazz.cast(this.diskSizeInGb()));
            }
            case "transferPerMonthInGb": {
                return Optional.ofNullable(clazz.cast(this.transferPerMonthInGb()));
            }
            case "cpuCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCount()));
            }
            case "isEncrypted": {
                return Optional.ofNullable(clazz.cast(this.isEncrypted()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RelationalDatabaseBundle, T> g) {
        return obj -> g.apply((RelationalDatabaseBundle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private String name;
        private Float price;
        private Float ramSizeInGb;
        private Integer diskSizeInGb;
        private Integer transferPerMonthInGb;
        private Integer cpuCount;
        private Boolean isEncrypted;
        private Boolean isActive;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalDatabaseBundle model) {
            this.bundleId(model.bundleId);
            this.name(model.name);
            this.price(model.price);
            this.ramSizeInGb(model.ramSizeInGb);
            this.diskSizeInGb(model.diskSizeInGb);
            this.transferPerMonthInGb(model.transferPerMonthInGb);
            this.cpuCount(model.cpuCount);
            this.isEncrypted(model.isEncrypted);
            this.isActive(model.isActive);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getPrice() {
            return this.price;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final Float getRamSizeInGb() {
            return this.ramSizeInGb;
        }

        public final void setRamSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
        }

        @Override
        public final Builder ramSizeInGb(Float ramSizeInGb) {
            this.ramSizeInGb = ramSizeInGb;
            return this;
        }

        public final Integer getDiskSizeInGb() {
            return this.diskSizeInGb;
        }

        public final void setDiskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
        }

        @Override
        public final Builder diskSizeInGb(Integer diskSizeInGb) {
            this.diskSizeInGb = diskSizeInGb;
            return this;
        }

        public final Integer getTransferPerMonthInGb() {
            return this.transferPerMonthInGb;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final Integer getCpuCount() {
            return this.cpuCount;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final Boolean getIsEncrypted() {
            return this.isEncrypted;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public RelationalDatabaseBundle build() {
            return new RelationalDatabaseBundle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalDatabaseBundle> {
        public Builder bundleId(String var1);

        public Builder name(String var1);

        public Builder price(Float var1);

        public Builder ramSizeInGb(Float var1);

        public Builder diskSizeInGb(Integer var1);

        public Builder transferPerMonthInGb(Integer var1);

        public Builder cpuCount(Integer var1);

        public Builder isEncrypted(Boolean var1);

        public Builder isActive(Boolean var1);
    }
}

