/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsAsyncClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAlertsResponse;

public class ListAlertsPublisher
implements SdkPublisher<ListAlertsResponse> {
    private final LookoutMetricsAsyncClient client;
    private final ListAlertsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAlertsPublisher(LookoutMetricsAsyncClient client, ListAlertsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAlertsPublisher(LookoutMetricsAsyncClient client, ListAlertsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAlertsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAlertsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAlertsResponseFetcher
    implements AsyncPageFetcher<ListAlertsResponse> {
        private ListAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAlertsResponse> nextPage(ListAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListAlertsPublisher.this.client.listAlerts(ListAlertsPublisher.this.firstRequest);
            }
            return ListAlertsPublisher.this.client.listAlerts((ListAlertsRequest)((Object)ListAlertsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

