/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsAsyncClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse;

public class ListMetricSetsPublisher
implements SdkPublisher<ListMetricSetsResponse> {
    private final LookoutMetricsAsyncClient client;
    private final ListMetricSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMetricSetsPublisher(LookoutMetricsAsyncClient client, ListMetricSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMetricSetsPublisher(LookoutMetricsAsyncClient client, ListMetricSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMetricSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMetricSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMetricSetsResponseFetcher
    implements AsyncPageFetcher<ListMetricSetsResponse> {
        private ListMetricSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMetricSetsResponse> nextPage(ListMetricSetsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricSetsPublisher.this.client.listMetricSets(ListMetricSetsPublisher.this.firstRequest);
            }
            return ListMetricSetsPublisher.this.client.listMetricSets((ListMetricSetsRequest)((Object)ListMetricSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

