/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorConfigSummary;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorFailureType;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorStatus;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnomalyDetectorResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, DescribeAnomalyDetectorResponse> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::anomalyDetectorArn)).setter(DescribeAnomalyDetectorResponse.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorName").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::anomalyDetectorName)).setter(DescribeAnomalyDetectorResponse.setter(Builder::anomalyDetectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorName").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorDescription").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::anomalyDetectorDescription)).setter(DescribeAnomalyDetectorResponse.setter(Builder::anomalyDetectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build()}).build();
    private static final SdkField<AnomalyDetectorConfigSummary> ANOMALY_DETECTOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnomalyDetectorConfig").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::anomalyDetectorConfig)).setter(DescribeAnomalyDetectorResponse.setter(Builder::anomalyDetectorConfig)).constructor(AnomalyDetectorConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::creationTime)).setter(DescribeAnomalyDetectorResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::lastModificationTime)).setter(DescribeAnomalyDetectorResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::statusAsString)).setter(DescribeAnomalyDetectorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::failureReason)).setter(DescribeAnomalyDetectorResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::kmsKeyArn)).setter(DescribeAnomalyDetectorResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureType").getter(DescribeAnomalyDetectorResponse.getter(DescribeAnomalyDetectorResponse::failureTypeAsString)).setter(DescribeAnomalyDetectorResponse.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, ANOMALY_DETECTOR_NAME_FIELD, ANOMALY_DETECTOR_DESCRIPTION_FIELD, ANOMALY_DETECTOR_CONFIG_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, KMS_KEY_ARN_FIELD, FAILURE_TYPE_FIELD));
    private final String anomalyDetectorArn;
    private final String anomalyDetectorName;
    private final String anomalyDetectorDescription;
    private final AnomalyDetectorConfigSummary anomalyDetectorConfig;
    private final Instant creationTime;
    private final Instant lastModificationTime;
    private final String status;
    private final String failureReason;
    private final String kmsKeyArn;
    private final String failureType;

    private DescribeAnomalyDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyDetectorName = builder.anomalyDetectorName;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.anomalyDetectorConfig = builder.anomalyDetectorConfig;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.failureType = builder.failureType;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String anomalyDetectorName() {
        return this.anomalyDetectorName;
    }

    public final String anomalyDetectorDescription() {
        return this.anomalyDetectorDescription;
    }

    public final AnomalyDetectorConfigSummary anomalyDetectorConfig() {
        return this.anomalyDetectorConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final AnomalyDetectorStatus status() {
        return AnomalyDetectorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final AnomalyDetectorFailureType failureType() {
        return AnomalyDetectorFailureType.fromValue(this.failureType);
    }

    public final String failureTypeAsString() {
        return this.failureType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorResponse)) {
            return false;
        }
        DescribeAnomalyDetectorResponse other = (DescribeAnomalyDetectorResponse)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.anomalyDetectorName(), other.anomalyDetectorName()) && Objects.equals(this.anomalyDetectorDescription(), other.anomalyDetectorDescription()) && Objects.equals(this.anomalyDetectorConfig(), other.anomalyDetectorConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.failureTypeAsString(), other.failureTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAnomalyDetectorResponse").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AnomalyDetectorName", (Object)this.anomalyDetectorName()).add("AnomalyDetectorDescription", (Object)this.anomalyDetectorDescription()).add("AnomalyDetectorConfig", (Object)this.anomalyDetectorConfig()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("FailureType", (Object)this.failureTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AnomalyDetectorName": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorName()));
            }
            case "AnomalyDetectorDescription": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorDescription()));
            }
            case "AnomalyDetectorConfig": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorConfig()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "FailureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String anomalyDetectorName;
        private String anomalyDetectorDescription;
        private AnomalyDetectorConfigSummary anomalyDetectorConfig;
        private Instant creationTime;
        private Instant lastModificationTime;
        private String status;
        private String failureReason;
        private String kmsKeyArn;
        private String failureType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorResponse model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.anomalyDetectorName(model.anomalyDetectorName);
            this.anomalyDetectorDescription(model.anomalyDetectorDescription);
            this.anomalyDetectorConfig(model.anomalyDetectorConfig);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.kmsKeyArn(model.kmsKeyArn);
            this.failureType(model.failureType);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAnomalyDetectorName() {
            return this.anomalyDetectorName;
        }

        public final void setAnomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
        }

        @Override
        public final Builder anomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
            return this;
        }

        public final String getAnomalyDetectorDescription() {
            return this.anomalyDetectorDescription;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        @Override
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final AnomalyDetectorConfigSummary.Builder getAnomalyDetectorConfig() {
            return this.anomalyDetectorConfig != null ? this.anomalyDetectorConfig.toBuilder() : null;
        }

        public final void setAnomalyDetectorConfig(AnomalyDetectorConfigSummary.BuilderImpl anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig != null ? anomalyDetectorConfig.build() : null;
        }

        @Override
        public final Builder anomalyDetectorConfig(AnomalyDetectorConfigSummary anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyDetectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getFailureType() {
            return this.failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(AnomalyDetectorFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        @Override
        public DescribeAnomalyDetectorResponse build() {
            return new DescribeAnomalyDetectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnomalyDetectorResponse> {
        public Builder anomalyDetectorArn(String var1);

        public Builder anomalyDetectorName(String var1);

        public Builder anomalyDetectorDescription(String var1);

        public Builder anomalyDetectorConfig(AnomalyDetectorConfigSummary var1);

        default public Builder anomalyDetectorConfig(Consumer<AnomalyDetectorConfigSummary.Builder> anomalyDetectorConfig) {
            return this.anomalyDetectorConfig((AnomalyDetectorConfigSummary)((AnomalyDetectorConfigSummary.Builder)AnomalyDetectorConfigSummary.builder().applyMutation(anomalyDetectorConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AnomalyDetectorStatus var1);

        public Builder failureReason(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder failureType(String var1);

        public Builder failureType(AnomalyDetectorFailureType var1);
    }
}

