/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyGroupSummariesResponse;

public class ListAnomalyGroupSummariesIterable
implements SdkIterable<ListAnomalyGroupSummariesResponse> {
    private final LookoutMetricsClient client;
    private final ListAnomalyGroupSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomalyGroupSummariesIterable(LookoutMetricsClient client, ListAnomalyGroupSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnomalyGroupSummariesResponseFetcher();
    }

    public Iterator<ListAnomalyGroupSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAnomalyGroupSummariesResponseFetcher
    implements SyncPageFetcher<ListAnomalyGroupSummariesResponse> {
        private ListAnomalyGroupSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalyGroupSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomalyGroupSummariesResponse nextPage(ListAnomalyGroupSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalyGroupSummariesIterable.this.client.listAnomalyGroupSummaries(ListAnomalyGroupSummariesIterable.this.firstRequest);
            }
            return ListAnomalyGroupSummariesIterable.this.client.listAnomalyGroupSummaries((ListAnomalyGroupSummariesRequest)((Object)ListAnomalyGroupSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

