/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AlertType {
    SNS("SNS"),
    LAMBDA("LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlertType> VALUE_MAP;
    private final String value;

    private AlertType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AlertType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AlertType> knownValues() {
        EnumSet<AlertType> knownValues = EnumSet.allOf(AlertType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AlertType.class, AlertType::toString);
    }
}

