/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.machinelearning.model.EntityStatus;
import software.amazon.awssdk.services.machinelearning.model.MLModelType;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.services.machinelearning.model.RealtimeEndpointInfo;
import software.amazon.awssdk.services.machinelearning.model.TrainingParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlModelResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, GetMlModelResponse> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLModelId").getter(GetMlModelResponse.getter(GetMlModelResponse::mlModelId)).setter(GetMlModelResponse.setter(Builder::mlModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()}).build();
    private static final SdkField<String> TRAINING_DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingDataSourceId").getter(GetMlModelResponse.getter(GetMlModelResponse::trainingDataSourceId)).setter(GetMlModelResponse.setter(Builder::trainingDataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataSourceId").build()}).build();
    private static final SdkField<String> CREATED_BY_IAM_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedByIamUser").getter(GetMlModelResponse.getter(GetMlModelResponse::createdByIamUser)).setter(GetMlModelResponse.setter(Builder::createdByIamUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByIamUser").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetMlModelResponse.getter(GetMlModelResponse::createdAt)).setter(GetMlModelResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetMlModelResponse.getter(GetMlModelResponse::lastUpdatedAt)).setter(GetMlModelResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetMlModelResponse.getter(GetMlModelResponse::name)).setter(GetMlModelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetMlModelResponse.getter(GetMlModelResponse::statusAsString)).setter(GetMlModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeInBytes").getter(GetMlModelResponse.getter(GetMlModelResponse::sizeInBytes)).setter(GetMlModelResponse.setter(Builder::sizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()}).build();
    private static final SdkField<RealtimeEndpointInfo> ENDPOINT_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointInfo").getter(GetMlModelResponse.getter(GetMlModelResponse::endpointInfo)).setter(GetMlModelResponse.setter(Builder::endpointInfo)).constructor(RealtimeEndpointInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()}).build();
    private static final SdkField<Map<String, String>> TRAINING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TrainingParameters").getter(GetMlModelResponse.getter(GetMlModelResponse::trainingParameters)).setter(GetMlModelResponse.setter(Builder::trainingParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_DATA_LOCATION_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputDataLocationS3").getter(GetMlModelResponse.getter(GetMlModelResponse::inputDataLocationS3)).setter(GetMlModelResponse.setter(Builder::inputDataLocationS3)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataLocationS3").build()}).build();
    private static final SdkField<String> ML_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MLModelType").getter(GetMlModelResponse.getter(GetMlModelResponse::mlModelTypeAsString)).setter(GetMlModelResponse.setter(Builder::mlModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelType").build()}).build();
    private static final SdkField<Float> SCORE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("ScoreThreshold").getter(GetMlModelResponse.getter(GetMlModelResponse::scoreThreshold)).setter(GetMlModelResponse.setter(Builder::scoreThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreThreshold").build()}).build();
    private static final SdkField<Instant> SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScoreThresholdLastUpdatedAt").getter(GetMlModelResponse.getter(GetMlModelResponse::scoreThresholdLastUpdatedAt)).setter(GetMlModelResponse.setter(Builder::scoreThresholdLastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreThresholdLastUpdatedAt").build()}).build();
    private static final SdkField<String> LOG_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogUri").getter(GetMlModelResponse.getter(GetMlModelResponse::logUri)).setter(GetMlModelResponse.setter(Builder::logUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogUri").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(GetMlModelResponse.getter(GetMlModelResponse::message)).setter(GetMlModelResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Long> COMPUTE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ComputeTime").getter(GetMlModelResponse.getter(GetMlModelResponse::computeTime)).setter(GetMlModelResponse.setter(Builder::computeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTime").build()}).build();
    private static final SdkField<Instant> FINISHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FinishedAt").getter(GetMlModelResponse.getter(GetMlModelResponse::finishedAt)).setter(GetMlModelResponse.setter(Builder::finishedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinishedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(GetMlModelResponse.getter(GetMlModelResponse::startedAt)).setter(GetMlModelResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<String> RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Recipe").getter(GetMlModelResponse.getter(GetMlModelResponse::recipe)).setter(GetMlModelResponse.setter(Builder::recipe)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipe").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(GetMlModelResponse.getter(GetMlModelResponse::schema)).setter(GetMlModelResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD, TRAINING_DATA_SOURCE_ID_FIELD, CREATED_BY_IAM_USER_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, STATUS_FIELD, SIZE_IN_BYTES_FIELD, ENDPOINT_INFO_FIELD, TRAINING_PARAMETERS_FIELD, INPUT_DATA_LOCATION_S3_FIELD, ML_MODEL_TYPE_FIELD, SCORE_THRESHOLD_FIELD, SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD, LOG_URI_FIELD, MESSAGE_FIELD, COMPUTE_TIME_FIELD, FINISHED_AT_FIELD, STARTED_AT_FIELD, RECIPE_FIELD, SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMlModelResponse.memberNameToFieldInitializer();
    private final String mlModelId;
    private final String trainingDataSourceId;
    private final String createdByIamUser;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String status;
    private final Long sizeInBytes;
    private final RealtimeEndpointInfo endpointInfo;
    private final Map<String, String> trainingParameters;
    private final String inputDataLocationS3;
    private final String mlModelType;
    private final Float scoreThreshold;
    private final Instant scoreThresholdLastUpdatedAt;
    private final String logUri;
    private final String message;
    private final Long computeTime;
    private final Instant finishedAt;
    private final Instant startedAt;
    private final String recipe;
    private final String schema;

    private GetMlModelResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
        this.trainingDataSourceId = builder.trainingDataSourceId;
        this.createdByIamUser = builder.createdByIamUser;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.sizeInBytes = builder.sizeInBytes;
        this.endpointInfo = builder.endpointInfo;
        this.trainingParameters = builder.trainingParameters;
        this.inputDataLocationS3 = builder.inputDataLocationS3;
        this.mlModelType = builder.mlModelType;
        this.scoreThreshold = builder.scoreThreshold;
        this.scoreThresholdLastUpdatedAt = builder.scoreThresholdLastUpdatedAt;
        this.logUri = builder.logUri;
        this.message = builder.message;
        this.computeTime = builder.computeTime;
        this.finishedAt = builder.finishedAt;
        this.startedAt = builder.startedAt;
        this.recipe = builder.recipe;
        this.schema = builder.schema;
    }

    public final String mlModelId() {
        return this.mlModelId;
    }

    public final String trainingDataSourceId() {
        return this.trainingDataSourceId;
    }

    public final String createdByIamUser() {
        return this.createdByIamUser;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final EntityStatus status() {
        return EntityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    public final RealtimeEndpointInfo endpointInfo() {
        return this.endpointInfo;
    }

    public final boolean hasTrainingParameters() {
        return this.trainingParameters != null && !(this.trainingParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> trainingParameters() {
        return this.trainingParameters;
    }

    public final String inputDataLocationS3() {
        return this.inputDataLocationS3;
    }

    public final MLModelType mlModelType() {
        return MLModelType.fromValue(this.mlModelType);
    }

    public final String mlModelTypeAsString() {
        return this.mlModelType;
    }

    public final Float scoreThreshold() {
        return this.scoreThreshold;
    }

    public final Instant scoreThresholdLastUpdatedAt() {
        return this.scoreThresholdLastUpdatedAt;
    }

    public final String logUri() {
        return this.logUri;
    }

    public final String message() {
        return this.message;
    }

    public final Long computeTime() {
        return this.computeTime;
    }

    public final Instant finishedAt() {
        return this.finishedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final String recipe() {
        return this.recipe;
    }

    public final String schema() {
        return this.schema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdByIamUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingParameters() ? this.trainingParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataLocationS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.mlModelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreThresholdLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.finishedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelResponse)) {
            return false;
        }
        GetMlModelResponse other = (GetMlModelResponse)((Object)obj);
        return Objects.equals(this.mlModelId(), other.mlModelId()) && Objects.equals(this.trainingDataSourceId(), other.trainingDataSourceId()) && Objects.equals(this.createdByIamUser(), other.createdByIamUser()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.endpointInfo(), other.endpointInfo()) && this.hasTrainingParameters() == other.hasTrainingParameters() && Objects.equals(this.trainingParameters(), other.trainingParameters()) && Objects.equals(this.inputDataLocationS3(), other.inputDataLocationS3()) && Objects.equals(this.mlModelTypeAsString(), other.mlModelTypeAsString()) && Objects.equals(this.scoreThreshold(), other.scoreThreshold()) && Objects.equals(this.scoreThresholdLastUpdatedAt(), other.scoreThresholdLastUpdatedAt()) && Objects.equals(this.logUri(), other.logUri()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.computeTime(), other.computeTime()) && Objects.equals(this.finishedAt(), other.finishedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.recipe(), other.recipe()) && Objects.equals(this.schema(), other.schema());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlModelResponse").add("MLModelId", (Object)this.mlModelId()).add("TrainingDataSourceId", (Object)this.trainingDataSourceId()).add("CreatedByIamUser", (Object)this.createdByIamUser()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("SizeInBytes", (Object)this.sizeInBytes()).add("EndpointInfo", (Object)this.endpointInfo()).add("TrainingParameters", this.hasTrainingParameters() ? this.trainingParameters() : null).add("InputDataLocationS3", (Object)this.inputDataLocationS3()).add("MLModelType", (Object)this.mlModelTypeAsString()).add("ScoreThreshold", (Object)this.scoreThreshold()).add("ScoreThresholdLastUpdatedAt", (Object)this.scoreThresholdLastUpdatedAt()).add("LogUri", (Object)this.logUri()).add("Message", (Object)this.message()).add("ComputeTime", (Object)this.computeTime()).add("FinishedAt", (Object)this.finishedAt()).add("StartedAt", (Object)this.startedAt()).add("Recipe", (Object)this.recipe()).add("Schema", (Object)this.schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MLModelId": {
                return Optional.ofNullable(clazz.cast(this.mlModelId()));
            }
            case "TrainingDataSourceId": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSourceId()));
            }
            case "CreatedByIamUser": {
                return Optional.ofNullable(clazz.cast(this.createdByIamUser()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "EndpointInfo": {
                return Optional.ofNullable(clazz.cast(this.endpointInfo()));
            }
            case "TrainingParameters": {
                return Optional.ofNullable(clazz.cast(this.trainingParameters()));
            }
            case "InputDataLocationS3": {
                return Optional.ofNullable(clazz.cast(this.inputDataLocationS3()));
            }
            case "MLModelType": {
                return Optional.ofNullable(clazz.cast(this.mlModelTypeAsString()));
            }
            case "ScoreThreshold": {
                return Optional.ofNullable(clazz.cast(this.scoreThreshold()));
            }
            case "ScoreThresholdLastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.scoreThresholdLastUpdatedAt()));
            }
            case "LogUri": {
                return Optional.ofNullable(clazz.cast(this.logUri()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ComputeTime": {
                return Optional.ofNullable(clazz.cast(this.computeTime()));
            }
            case "FinishedAt": {
                return Optional.ofNullable(clazz.cast(this.finishedAt()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "Recipe": {
                return Optional.ofNullable(clazz.cast(this.recipe()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MLModelId", ML_MODEL_ID_FIELD);
        map.put("TrainingDataSourceId", TRAINING_DATA_SOURCE_ID_FIELD);
        map.put("CreatedByIamUser", CREATED_BY_IAM_USER_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SizeInBytes", SIZE_IN_BYTES_FIELD);
        map.put("EndpointInfo", ENDPOINT_INFO_FIELD);
        map.put("TrainingParameters", TRAINING_PARAMETERS_FIELD);
        map.put("InputDataLocationS3", INPUT_DATA_LOCATION_S3_FIELD);
        map.put("MLModelType", ML_MODEL_TYPE_FIELD);
        map.put("ScoreThreshold", SCORE_THRESHOLD_FIELD);
        map.put("ScoreThresholdLastUpdatedAt", SCORE_THRESHOLD_LAST_UPDATED_AT_FIELD);
        map.put("LogUri", LOG_URI_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ComputeTime", COMPUTE_TIME_FIELD);
        map.put("FinishedAt", FINISHED_AT_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("Recipe", RECIPE_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelResponse, T> g) {
        return obj -> g.apply((GetMlModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private String mlModelId;
        private String trainingDataSourceId;
        private String createdByIamUser;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String name;
        private String status;
        private Long sizeInBytes;
        private RealtimeEndpointInfo endpointInfo;
        private Map<String, String> trainingParameters = DefaultSdkAutoConstructMap.getInstance();
        private String inputDataLocationS3;
        private String mlModelType;
        private Float scoreThreshold;
        private Instant scoreThresholdLastUpdatedAt;
        private String logUri;
        private String message;
        private Long computeTime;
        private Instant finishedAt;
        private Instant startedAt;
        private String recipe;
        private String schema;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelResponse model) {
            super(model);
            this.mlModelId(model.mlModelId);
            this.trainingDataSourceId(model.trainingDataSourceId);
            this.createdByIamUser(model.createdByIamUser);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.status(model.status);
            this.sizeInBytes(model.sizeInBytes);
            this.endpointInfo(model.endpointInfo);
            this.trainingParameters(model.trainingParameters);
            this.inputDataLocationS3(model.inputDataLocationS3);
            this.mlModelType(model.mlModelType);
            this.scoreThreshold(model.scoreThreshold);
            this.scoreThresholdLastUpdatedAt(model.scoreThresholdLastUpdatedAt);
            this.logUri(model.logUri);
            this.message(model.message);
            this.computeTime(model.computeTime);
            this.finishedAt(model.finishedAt);
            this.startedAt(model.startedAt);
            this.recipe(model.recipe);
            this.schema(model.schema);
        }

        public final String getMlModelId() {
            return this.mlModelId;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final String getTrainingDataSourceId() {
            return this.trainingDataSourceId;
        }

        public final void setTrainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
        }

        @Override
        public final Builder trainingDataSourceId(String trainingDataSourceId) {
            this.trainingDataSourceId = trainingDataSourceId;
            return this;
        }

        public final String getCreatedByIamUser() {
            return this.createdByIamUser;
        }

        public final void setCreatedByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
        }

        @Override
        public final Builder createdByIamUser(String createdByIamUser) {
            this.createdByIamUser = createdByIamUser;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EntityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final RealtimeEndpointInfo.Builder getEndpointInfo() {
            return this.endpointInfo != null ? this.endpointInfo.toBuilder() : null;
        }

        public final void setEndpointInfo(RealtimeEndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        @Override
        public final Builder endpointInfo(RealtimeEndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        public final Map<String, String> getTrainingParameters() {
            if (this.trainingParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.trainingParameters;
        }

        public final void setTrainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
        }

        @Override
        public final Builder trainingParameters(Map<String, String> trainingParameters) {
            this.trainingParameters = TrainingParametersCopier.copy(trainingParameters);
            return this;
        }

        public final String getInputDataLocationS3() {
            return this.inputDataLocationS3;
        }

        public final void setInputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
        }

        @Override
        public final Builder inputDataLocationS3(String inputDataLocationS3) {
            this.inputDataLocationS3 = inputDataLocationS3;
            return this;
        }

        public final String getMlModelType() {
            return this.mlModelType;
        }

        public final void setMlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
        }

        @Override
        public final Builder mlModelType(String mlModelType) {
            this.mlModelType = mlModelType;
            return this;
        }

        @Override
        public final Builder mlModelType(MLModelType mlModelType) {
            this.mlModelType(mlModelType == null ? null : mlModelType.toString());
            return this;
        }

        public final Float getScoreThreshold() {
            return this.scoreThreshold;
        }

        public final void setScoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        @Override
        public final Builder scoreThreshold(Float scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
            return this;
        }

        public final Instant getScoreThresholdLastUpdatedAt() {
            return this.scoreThresholdLastUpdatedAt;
        }

        public final void setScoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
        }

        @Override
        public final Builder scoreThresholdLastUpdatedAt(Instant scoreThresholdLastUpdatedAt) {
            this.scoreThresholdLastUpdatedAt = scoreThresholdLastUpdatedAt;
            return this;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getComputeTime() {
            return this.computeTime;
        }

        public final void setComputeTime(Long computeTime) {
            this.computeTime = computeTime;
        }

        @Override
        public final Builder computeTime(Long computeTime) {
            this.computeTime = computeTime;
            return this;
        }

        public final Instant getFinishedAt() {
            return this.finishedAt;
        }

        public final void setFinishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
        }

        @Override
        public final Builder finishedAt(Instant finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getRecipe() {
            return this.recipe;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public GetMlModelResponse build() {
            return new GetMlModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlModelResponse> {
        public Builder mlModelId(String var1);

        public Builder trainingDataSourceId(String var1);

        public Builder createdByIamUser(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EntityStatus var1);

        public Builder sizeInBytes(Long var1);

        public Builder endpointInfo(RealtimeEndpointInfo var1);

        default public Builder endpointInfo(Consumer<RealtimeEndpointInfo.Builder> endpointInfo) {
            return this.endpointInfo((RealtimeEndpointInfo)((RealtimeEndpointInfo.Builder)RealtimeEndpointInfo.builder().applyMutation(endpointInfo)).build());
        }

        public Builder trainingParameters(Map<String, String> var1);

        public Builder inputDataLocationS3(String var1);

        public Builder mlModelType(String var1);

        public Builder mlModelType(MLModelType var1);

        public Builder scoreThreshold(Float var1);

        public Builder scoreThresholdLastUpdatedAt(Instant var1);

        public Builder logUri(String var1);

        public Builder message(String var1);

        public Builder computeTime(Long var1);

        public Builder finishedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder recipe(String var1);

        public Builder schema(String var1);
    }
}

