/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.ListedGateway;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.services.mediaconnect.model.___listOfListedGatewayCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGatewaysResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListGatewaysResponse> {
    private static final SdkField<List<ListedGateway>> GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Gateways").getter(ListGatewaysResponse.getter(ListGatewaysResponse::gateways)).setter(ListGatewaysResponse.setter(Builder::gateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGatewaysResponse.getter(ListGatewaysResponse::nextToken)).setter(ListGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGatewaysResponse.memberNameToFieldInitializer();
    private final List<ListedGateway> gateways;
    private final String nextToken;

    private ListGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.gateways = builder.gateways;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGateways() {
        return this.gateways != null && !(this.gateways instanceof SdkAutoConstructList);
    }

    public final List<ListedGateway> gateways() {
        return this.gateways;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGateways() ? this.gateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGatewaysResponse)) {
            return false;
        }
        ListGatewaysResponse other = (ListGatewaysResponse)((Object)obj);
        return this.hasGateways() == other.hasGateways() && Objects.equals(this.gateways(), other.gateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGatewaysResponse").add("Gateways", this.hasGateways() ? this.gateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gateways": {
                return Optional.ofNullable(clazz.cast(this.gateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gateways", GATEWAYS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGatewaysResponse, T> g) {
        return obj -> g.apply((ListGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<ListedGateway> gateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGatewaysResponse model) {
            super(model);
            this.gateways(model.gateways);
            this.nextToken(model.nextToken);
        }

        public final List<ListedGateway.Builder> getGateways() {
            List<ListedGateway.Builder> result = ___listOfListedGatewayCopier.copyToBuilder(this.gateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGateways(Collection<ListedGateway.BuilderImpl> gateways) {
            this.gateways = ___listOfListedGatewayCopier.copyFromBuilder(gateways);
        }

        @Override
        public final Builder gateways(Collection<ListedGateway> gateways) {
            this.gateways = ___listOfListedGatewayCopier.copy(gateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(ListedGateway ... gateways) {
            this.gateways(Arrays.asList(gateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(Consumer<ListedGateway.Builder> ... gateways) {
            this.gateways(Stream.of(gateways).map(c -> (ListedGateway)((ListedGateway.Builder)ListedGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGatewaysResponse build() {
            return new ListGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGatewaysResponse> {
        public Builder gateways(Collection<ListedGateway> var1);

        public Builder gateways(ListedGateway ... var1);

        public Builder gateways(Consumer<ListedGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

