/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediastore.model.AllowedHeadersCopier;
import software.amazon.awssdk.services.mediastore.model.AllowedMethodsCopier;
import software.amazon.awssdk.services.mediastore.model.AllowedOriginsCopier;
import software.amazon.awssdk.services.mediastore.model.ExposeHeadersCopier;
import software.amazon.awssdk.services.mediastore.model.MethodName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CorsRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CorsRule> {
    private static final SdkField<List<String>> ALLOWED_ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CorsRule.getter(CorsRule::allowedOrigins)).setter(CorsRule.setter(Builder::allowedOrigins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedOrigins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CorsRule.getter(CorsRule::allowedMethodsAsStrings)).setter(CorsRule.setter(Builder::allowedMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CorsRule.getter(CorsRule::allowedHeaders)).setter(CorsRule.setter(Builder::allowedHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_AGE_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CorsRule.getter(CorsRule::maxAgeSeconds)).setter(CorsRule.setter(Builder::maxAgeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAgeSeconds").build()}).build();
    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CorsRule.getter(CorsRule::exposeHeaders)).setter(CorsRule.setter(Builder::exposeHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExposeHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ORIGINS_FIELD, ALLOWED_METHODS_FIELD, ALLOWED_HEADERS_FIELD, MAX_AGE_SECONDS_FIELD, EXPOSE_HEADERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> allowedOrigins;
    private final List<String> allowedMethods;
    private final List<String> allowedHeaders;
    private final Integer maxAgeSeconds;
    private final List<String> exposeHeaders;

    private CorsRule(BuilderImpl builder) {
        this.allowedOrigins = builder.allowedOrigins;
        this.allowedMethods = builder.allowedMethods;
        this.allowedHeaders = builder.allowedHeaders;
        this.maxAgeSeconds = builder.maxAgeSeconds;
        this.exposeHeaders = builder.exposeHeaders;
    }

    public List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public List<MethodName> allowedMethods() {
        return TypeConverter.convert(this.allowedMethods, MethodName::fromValue);
    }

    public List<String> allowedMethodsAsStrings() {
        return this.allowedMethods;
    }

    public List<String> allowedHeaders() {
        return this.allowedHeaders;
    }

    public Integer maxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedOrigins());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedMethodsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAgeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.exposeHeaders());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CorsRule)) {
            return false;
        }
        CorsRule other = (CorsRule)obj;
        return Objects.equals(this.allowedOrigins(), other.allowedOrigins()) && Objects.equals(this.allowedMethodsAsStrings(), other.allowedMethodsAsStrings()) && Objects.equals(this.allowedHeaders(), other.allowedHeaders()) && Objects.equals(this.maxAgeSeconds(), other.maxAgeSeconds()) && Objects.equals(this.exposeHeaders(), other.exposeHeaders());
    }

    public String toString() {
        return ToString.builder((String)"CorsRule").add("AllowedOrigins", this.allowedOrigins()).add("AllowedMethods", this.allowedMethodsAsStrings()).add("AllowedHeaders", this.allowedHeaders()).add("MaxAgeSeconds", (Object)this.maxAgeSeconds()).add("ExposeHeaders", this.exposeHeaders()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedOrigins": {
                return Optional.ofNullable(clazz.cast(this.allowedOrigins()));
            }
            case "AllowedMethods": {
                return Optional.ofNullable(clazz.cast(this.allowedMethodsAsStrings()));
            }
            case "AllowedHeaders": {
                return Optional.ofNullable(clazz.cast(this.allowedHeaders()));
            }
            case "MaxAgeSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxAgeSeconds()));
            }
            case "ExposeHeaders": {
                return Optional.ofNullable(clazz.cast(this.exposeHeaders()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CorsRule, T> g) {
        return obj -> g.apply((CorsRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedOrigins = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedMethods = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedHeaders = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAgeSeconds;
        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CorsRule model) {
            this.allowedOrigins(model.allowedOrigins);
            this.allowedMethodsWithStrings(model.allowedMethods);
            this.allowedHeaders(model.allowedHeaders);
            this.maxAgeSeconds(model.maxAgeSeconds);
            this.exposeHeaders(model.exposeHeaders);
        }

        public final Collection<String> getAllowedOrigins() {
            return this.allowedOrigins;
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String ... allowedOrigins) {
            this.allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = AllowedOriginsCopier.copy(allowedOrigins);
        }

        public final Collection<String> getAllowedMethodsAsStrings() {
            return this.allowedMethods;
        }

        @Override
        public final Builder allowedMethodsWithStrings(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethodsWithStrings(String ... allowedMethods) {
            this.allowedMethodsWithStrings(Arrays.asList(allowedMethods));
            return this;
        }

        @Override
        public final Builder allowedMethods(Collection<MethodName> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copyEnumToString(allowedMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMethods(MethodName ... allowedMethods) {
            this.allowedMethods(Arrays.asList(allowedMethods));
            return this;
        }

        public final void setAllowedMethodsWithStrings(Collection<String> allowedMethods) {
            this.allowedMethods = AllowedMethodsCopier.copy(allowedMethods);
        }

        public final Collection<String> getAllowedHeaders() {
            return this.allowedHeaders;
        }

        @Override
        public final Builder allowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedHeaders(String ... allowedHeaders) {
            this.allowedHeaders(Arrays.asList(allowedHeaders));
            return this;
        }

        public final void setAllowedHeaders(Collection<String> allowedHeaders) {
            this.allowedHeaders = AllowedHeadersCopier.copy(allowedHeaders);
        }

        public final Integer getMaxAgeSeconds() {
            return this.maxAgeSeconds;
        }

        @Override
        public final Builder maxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
            return this;
        }

        public final void setMaxAgeSeconds(Integer maxAgeSeconds) {
            this.maxAgeSeconds = maxAgeSeconds;
        }

        public final Collection<String> getExposeHeaders() {
            return this.exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String ... exposeHeaders) {
            this.exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = ExposeHeadersCopier.copy(exposeHeaders);
        }

        public CorsRule build() {
            return new CorsRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CorsRule> {
        public Builder allowedOrigins(Collection<String> var1);

        public Builder allowedOrigins(String ... var1);

        public Builder allowedMethodsWithStrings(Collection<String> var1);

        public Builder allowedMethodsWithStrings(String ... var1);

        public Builder allowedMethods(Collection<MethodName> var1);

        public Builder allowedMethods(MethodName ... var1);

        public Builder allowedHeaders(Collection<String> var1);

        public Builder allowedHeaders(String ... var1);

        public Builder maxAgeSeconds(Integer var1);

        public Builder exposeHeaders(Collection<String> var1);

        public Builder exposeHeaders(String ... var1);
    }
}

