/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.medicalimaging.model.DICOMUpdates;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataUpdates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataUpdates> {
    private static final SdkField<DICOMUpdates> DICOM_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DICOMUpdates").getter(MetadataUpdates.getter(MetadataUpdates::dicomUpdates)).setter(MetadataUpdates.setter(Builder::dicomUpdates)).constructor(DICOMUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DICOMUpdates").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DICOM_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final DICOMUpdates dicomUpdates;
    private final Type type;

    private MetadataUpdates(BuilderImpl builder) {
        this.dicomUpdates = builder.dicomUpdates;
        this.type = builder.type;
    }

    public final DICOMUpdates dicomUpdates() {
        return this.dicomUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dicomUpdates());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataUpdates)) {
            return false;
        }
        MetadataUpdates other = (MetadataUpdates)obj;
        return Objects.equals(this.dicomUpdates(), other.dicomUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataUpdates").add("DICOMUpdates", (Object)this.dicomUpdates()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DICOMUpdates": {
                return Optional.ofNullable(clazz.cast(this.dicomUpdates()));
            }
        }
        return Optional.empty();
    }

    public static MetadataUpdates fromDicomUpdates(DICOMUpdates dicomUpdates) {
        return (MetadataUpdates)MetadataUpdates.builder().dicomUpdates(dicomUpdates).build();
    }

    public static MetadataUpdates fromDicomUpdates(Consumer<DICOMUpdates.Builder> dicomUpdates) {
        DICOMUpdates.Builder builder = DICOMUpdates.builder();
        dicomUpdates.accept(builder);
        return MetadataUpdates.fromDicomUpdates((DICOMUpdates)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataUpdates, T> g) {
        return obj -> g.apply((MetadataUpdates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DICOM_UPDATES,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DICOMUpdates dicomUpdates;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataUpdates model) {
            this.dicomUpdates(model.dicomUpdates);
        }

        public final DICOMUpdates.Builder getDicomUpdates() {
            return this.dicomUpdates != null ? this.dicomUpdates.toBuilder() : null;
        }

        public final void setDicomUpdates(DICOMUpdates.BuilderImpl dicomUpdates) {
            DICOMUpdates oldValue = this.dicomUpdates;
            this.dicomUpdates = dicomUpdates != null ? dicomUpdates.build() : null;
            this.handleUnionValueChange(Type.DICOM_UPDATES, oldValue, this.dicomUpdates);
        }

        @Override
        public final Builder dicomUpdates(DICOMUpdates dicomUpdates) {
            DICOMUpdates oldValue = this.dicomUpdates;
            this.dicomUpdates = dicomUpdates;
            this.handleUnionValueChange(Type.DICOM_UPDATES, oldValue, this.dicomUpdates);
            return this;
        }

        public MetadataUpdates build() {
            return new MetadataUpdates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataUpdates> {
        public Builder dicomUpdates(DICOMUpdates var1);

        default public Builder dicomUpdates(Consumer<DICOMUpdates.Builder> dicomUpdates) {
            return this.dicomUpdates((DICOMUpdates)((DICOMUpdates.Builder)DICOMUpdates.builder().applyMutation(dicomUpdates)).build());
        }
    }
}

