/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.DatastoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreSummary> {
    private static final SdkField<String> DATASTORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreId").getter(DatastoreSummary.getter(DatastoreSummary::datastoreId)).setter(DatastoreSummary.setter(Builder::datastoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreId").build()}).build();
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreName").getter(DatastoreSummary.getter(DatastoreSummary::datastoreName)).setter(DatastoreSummary.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()}).build();
    private static final SdkField<String> DATASTORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreStatus").getter(DatastoreSummary.getter(DatastoreSummary::datastoreStatusAsString)).setter(DatastoreSummary.setter(Builder::datastoreStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStatus").build()}).build();
    private static final SdkField<String> DATASTORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreArn").getter(DatastoreSummary.getter(DatastoreSummary::datastoreArn)).setter(DatastoreSummary.setter(Builder::datastoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DatastoreSummary.getter(DatastoreSummary::createdAt)).setter(DatastoreSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DatastoreSummary.getter(DatastoreSummary::updatedAt)).setter(DatastoreSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_ID_FIELD, DATASTORE_NAME_FIELD, DATASTORE_STATUS_FIELD, DATASTORE_ARN_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("datastoreId", DATASTORE_ID_FIELD);
            this.put("datastoreName", DATASTORE_NAME_FIELD);
            this.put("datastoreStatus", DATASTORE_STATUS_FIELD);
            this.put("datastoreArn", DATASTORE_ARN_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String datastoreId;
    private final String datastoreName;
    private final String datastoreStatus;
    private final String datastoreArn;
    private final Instant createdAt;
    private final Instant updatedAt;

    private DatastoreSummary(BuilderImpl builder) {
        this.datastoreId = builder.datastoreId;
        this.datastoreName = builder.datastoreName;
        this.datastoreStatus = builder.datastoreStatus;
        this.datastoreArn = builder.datastoreArn;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String datastoreId() {
        return this.datastoreId;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public final DatastoreStatus datastoreStatus() {
        return DatastoreStatus.fromValue(this.datastoreStatus);
    }

    public final String datastoreStatusAsString() {
        return this.datastoreStatus;
    }

    public final String datastoreArn() {
        return this.datastoreArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreSummary)) {
            return false;
        }
        DatastoreSummary other = (DatastoreSummary)obj;
        return Objects.equals(this.datastoreId(), other.datastoreId()) && Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.datastoreStatusAsString(), other.datastoreStatusAsString()) && Objects.equals(this.datastoreArn(), other.datastoreArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DatastoreSummary").add("DatastoreId", (Object)this.datastoreId()).add("DatastoreName", (Object)this.datastoreName()).add("DatastoreStatus", (Object)this.datastoreStatusAsString()).add("DatastoreArn", (Object)this.datastoreArn()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreId": {
                return Optional.ofNullable(clazz.cast(this.datastoreId()));
            }
            case "datastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "datastoreStatus": {
                return Optional.ofNullable(clazz.cast(this.datastoreStatusAsString()));
            }
            case "datastoreArn": {
                return Optional.ofNullable(clazz.cast(this.datastoreArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreSummary, T> g) {
        return obj -> g.apply((DatastoreSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datastoreId;
        private String datastoreName;
        private String datastoreStatus;
        private String datastoreArn;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreSummary model) {
            this.datastoreId(model.datastoreId);
            this.datastoreName(model.datastoreName);
            this.datastoreStatus(model.datastoreStatus);
            this.datastoreArn(model.datastoreArn);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getDatastoreId() {
            return this.datastoreId;
        }

        public final void setDatastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
        }

        @Override
        public final Builder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final String getDatastoreStatus() {
            return this.datastoreStatus;
        }

        public final void setDatastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
        }

        @Override
        public final Builder datastoreStatus(String datastoreStatus) {
            this.datastoreStatus = datastoreStatus;
            return this;
        }

        @Override
        public final Builder datastoreStatus(DatastoreStatus datastoreStatus) {
            this.datastoreStatus(datastoreStatus == null ? null : datastoreStatus.toString());
            return this;
        }

        public final String getDatastoreArn() {
            return this.datastoreArn;
        }

        public final void setDatastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
        }

        @Override
        public final Builder datastoreArn(String datastoreArn) {
            this.datastoreArn = datastoreArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DatastoreSummary build() {
            return new DatastoreSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreSummary> {
        public Builder datastoreId(String var1);

        public Builder datastoreName(String var1);

        public Builder datastoreStatus(String var1);

        public Builder datastoreStatus(DatastoreStatus var1);

        public Builder datastoreArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

