/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreNetworkEdge
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreNetworkEdge> {
    private static final SdkField<String> EDGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgeLocation").getter(CoreNetworkEdge.getter(CoreNetworkEdge::edgeLocation)).setter(CoreNetworkEdge.setter(Builder::edgeLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocation").build()}).build();
    private static final SdkField<Long> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Asn").getter(CoreNetworkEdge.getter(CoreNetworkEdge::asn)).setter(CoreNetworkEdge.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Asn").build()}).build();
    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsideCidrBlocks").getter(CoreNetworkEdge.getter(CoreNetworkEdge::insideCidrBlocks)).setter(CoreNetworkEdge.setter(Builder::insideCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_LOCATION_FIELD, ASN_FIELD, INSIDE_CIDR_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EdgeLocation", EDGE_LOCATION_FIELD);
            this.put("Asn", ASN_FIELD);
            this.put("InsideCidrBlocks", INSIDE_CIDR_BLOCKS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String edgeLocation;
    private final Long asn;
    private final List<String> insideCidrBlocks;

    private CoreNetworkEdge(BuilderImpl builder) {
        this.edgeLocation = builder.edgeLocation;
        this.asn = builder.asn;
        this.insideCidrBlocks = builder.insideCidrBlocks;
    }

    public final String edgeLocation() {
        return this.edgeLocation;
    }

    public final Long asn() {
        return this.asn;
    }

    public final boolean hasInsideCidrBlocks() {
        return this.insideCidrBlocks != null && !(this.insideCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreNetworkEdge)) {
            return false;
        }
        CoreNetworkEdge other = (CoreNetworkEdge)obj;
        return Objects.equals(this.edgeLocation(), other.edgeLocation()) && Objects.equals(this.asn(), other.asn()) && this.hasInsideCidrBlocks() == other.hasInsideCidrBlocks() && Objects.equals(this.insideCidrBlocks(), other.insideCidrBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"CoreNetworkEdge").add("EdgeLocation", (Object)this.edgeLocation()).add("Asn", (Object)this.asn()).add("InsideCidrBlocks", this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeLocation": {
                return Optional.ofNullable(clazz.cast(this.edgeLocation()));
            }
            case "Asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "InsideCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.insideCidrBlocks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CoreNetworkEdge, T> g) {
        return obj -> g.apply((CoreNetworkEdge)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String edgeLocation;
        private Long asn;
        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoreNetworkEdge model) {
            this.edgeLocation(model.edgeLocation);
            this.asn(model.asn);
            this.insideCidrBlocks(model.insideCidrBlocks);
        }

        public final String getEdgeLocation() {
            return this.edgeLocation;
        }

        public final void setEdgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
        }

        @Override
        public final Builder edgeLocation(String edgeLocation) {
            this.edgeLocation = edgeLocation;
            return this;
        }

        public final Long getAsn() {
            return this.asn;
        }

        public final void setAsn(Long asn) {
            this.asn = asn;
        }

        @Override
        public final Builder asn(Long asn) {
            this.asn = asn;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (this.insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = ConstrainedStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String ... insideCidrBlocks) {
            this.insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public CoreNetworkEdge build() {
            return new CoreNetworkEdge(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreNetworkEdge> {
        public Builder edgeLocation(String var1);

        public Builder asn(Long var1);

        public Builder insideCidrBlocks(Collection<String> var1);

        public Builder insideCidrBlocks(String ... var1);
    }
}

