/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummary;
import software.amazon.awssdk.services.networkmanager.model.ConnectPeerSummaryListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectPeersResponse
extends NetworkManagerResponse
implements ToCopyableBuilder<Builder, ListConnectPeersResponse> {
    private static final SdkField<List<ConnectPeerSummary>> CONNECT_PEERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectPeers").getter(ListConnectPeersResponse.getter(ListConnectPeersResponse::connectPeers)).setter(ListConnectPeersResponse.setter(Builder::connectPeers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectPeers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectPeerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectPeersResponse.getter(ListConnectPeersResponse::nextToken)).setter(ListConnectPeersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECT_PEERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConnectPeers", CONNECT_PEERS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConnectPeerSummary> connectPeers;
    private final String nextToken;

    private ListConnectPeersResponse(BuilderImpl builder) {
        super(builder);
        this.connectPeers = builder.connectPeers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConnectPeers() {
        return this.connectPeers != null && !(this.connectPeers instanceof SdkAutoConstructList);
    }

    public final List<ConnectPeerSummary> connectPeers() {
        return this.connectPeers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectPeers() ? this.connectPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectPeersResponse)) {
            return false;
        }
        ListConnectPeersResponse other = (ListConnectPeersResponse)((Object)obj);
        return this.hasConnectPeers() == other.hasConnectPeers() && Objects.equals(this.connectPeers(), other.connectPeers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectPeersResponse").add("ConnectPeers", this.hasConnectPeers() ? this.connectPeers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectPeers": {
                return Optional.ofNullable(clazz.cast(this.connectPeers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConnectPeersResponse, T> g) {
        return obj -> g.apply((ListConnectPeersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerResponse.BuilderImpl
    implements Builder {
        private List<ConnectPeerSummary> connectPeers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectPeersResponse model) {
            super(model);
            this.connectPeers(model.connectPeers);
            this.nextToken(model.nextToken);
        }

        public final List<ConnectPeerSummary.Builder> getConnectPeers() {
            List<ConnectPeerSummary.Builder> result = ConnectPeerSummaryListCopier.copyToBuilder(this.connectPeers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectPeers(Collection<ConnectPeerSummary.BuilderImpl> connectPeers) {
            this.connectPeers = ConnectPeerSummaryListCopier.copyFromBuilder(connectPeers);
        }

        @Override
        public final Builder connectPeers(Collection<ConnectPeerSummary> connectPeers) {
            this.connectPeers = ConnectPeerSummaryListCopier.copy(connectPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectPeers(ConnectPeerSummary ... connectPeers) {
            this.connectPeers(Arrays.asList(connectPeers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectPeers(Consumer<ConnectPeerSummary.Builder> ... connectPeers) {
            this.connectPeers(Stream.of(connectPeers).map(c -> (ConnectPeerSummary)((ConnectPeerSummary.Builder)ConnectPeerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConnectPeersResponse build() {
            return new ListConnectPeersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectPeersResponse> {
        public Builder connectPeers(Collection<ConnectPeerSummary> var1);

        public Builder connectPeers(ConnectPeerSummary ... var1);

        public Builder connectPeers(Consumer<ConnectPeerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

