/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ConstrainedStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceInsertionSegments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceInsertionSegments> {
    private static final SdkField<List<String>> SEND_VIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SendVia").getter(ServiceInsertionSegments.getter(ServiceInsertionSegments::sendVia)).setter(ServiceInsertionSegments.setter(Builder::sendVia)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendVia").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SEND_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SendTo").getter(ServiceInsertionSegments.getter(ServiceInsertionSegments::sendTo)).setter(ServiceInsertionSegments.setter(Builder::sendTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendTo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEND_VIA_FIELD, SEND_TO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceInsertionSegments.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> sendVia;
    private final List<String> sendTo;

    private ServiceInsertionSegments(BuilderImpl builder) {
        this.sendVia = builder.sendVia;
        this.sendTo = builder.sendTo;
    }

    public final boolean hasSendVia() {
        return this.sendVia != null && !(this.sendVia instanceof SdkAutoConstructList);
    }

    public final List<String> sendVia() {
        return this.sendVia;
    }

    public final boolean hasSendTo() {
        return this.sendTo != null && !(this.sendTo instanceof SdkAutoConstructList);
    }

    public final List<String> sendTo() {
        return this.sendTo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSendVia() ? this.sendVia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSendTo() ? this.sendTo() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInsertionSegments)) {
            return false;
        }
        ServiceInsertionSegments other = (ServiceInsertionSegments)obj;
        return this.hasSendVia() == other.hasSendVia() && Objects.equals(this.sendVia(), other.sendVia()) && this.hasSendTo() == other.hasSendTo() && Objects.equals(this.sendTo(), other.sendTo());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceInsertionSegments").add("SendVia", this.hasSendVia() ? this.sendVia() : null).add("SendTo", this.hasSendTo() ? this.sendTo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SendVia": {
                return Optional.ofNullable(clazz.cast(this.sendVia()));
            }
            case "SendTo": {
                return Optional.ofNullable(clazz.cast(this.sendTo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("SendVia", SEND_VIA_FIELD);
        map.put("SendTo", SEND_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceInsertionSegments, T> g) {
        return obj -> g.apply((ServiceInsertionSegments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sendVia = DefaultSdkAutoConstructList.getInstance();
        private List<String> sendTo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceInsertionSegments model) {
            this.sendVia(model.sendVia);
            this.sendTo(model.sendTo);
        }

        public final Collection<String> getSendVia() {
            if (this.sendVia instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sendVia;
        }

        public final void setSendVia(Collection<String> sendVia) {
            this.sendVia = ConstrainedStringListCopier.copy(sendVia);
        }

        @Override
        public final Builder sendVia(Collection<String> sendVia) {
            this.sendVia = ConstrainedStringListCopier.copy(sendVia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendVia(String ... sendVia) {
            this.sendVia(Arrays.asList(sendVia));
            return this;
        }

        public final Collection<String> getSendTo() {
            if (this.sendTo instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sendTo;
        }

        public final void setSendTo(Collection<String> sendTo) {
            this.sendTo = ConstrainedStringListCopier.copy(sendTo);
        }

        @Override
        public final Builder sendTo(Collection<String> sendTo) {
            this.sendTo = ConstrainedStringListCopier.copy(sendTo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendTo(String ... sendTo) {
            this.sendTo(Arrays.asList(sendTo));
            return this;
        }

        public ServiceInsertionSegments build() {
            return new ServiceInsertionSegments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceInsertionSegments> {
        public Builder sendVia(Collection<String> var1);

        public Builder sendVia(String ... var1);

        public Builder sendTo(Collection<String> var1);

        public Builder sendTo(String ... var1);
    }
}

