/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRouteAnalysisRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, StartRouteAnalysisRequest> {
    private static final SdkField<String> GLOBAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalNetworkId").getter(StartRouteAnalysisRequest.getter(StartRouteAnalysisRequest::globalNetworkId)).setter(StartRouteAnalysisRequest.setter(Builder::globalNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalNetworkId").build()}).build();
    private static final SdkField<RouteAnalysisEndpointOptionsSpecification> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(StartRouteAnalysisRequest.getter(StartRouteAnalysisRequest::source)).setter(StartRouteAnalysisRequest.setter(Builder::source)).constructor(RouteAnalysisEndpointOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<RouteAnalysisEndpointOptionsSpecification> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(StartRouteAnalysisRequest.getter(StartRouteAnalysisRequest::destination)).setter(StartRouteAnalysisRequest.setter(Builder::destination)).constructor(RouteAnalysisEndpointOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RETURN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeReturnPath").getter(StartRouteAnalysisRequest.getter(StartRouteAnalysisRequest::includeReturnPath)).setter(StartRouteAnalysisRequest.setter(Builder::includeReturnPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeReturnPath").build()}).build();
    private static final SdkField<Boolean> USE_MIDDLEBOXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseMiddleboxes").getter(StartRouteAnalysisRequest.getter(StartRouteAnalysisRequest::useMiddleboxes)).setter(StartRouteAnalysisRequest.setter(Builder::useMiddleboxes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseMiddleboxes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_NETWORK_ID_FIELD, SOURCE_FIELD, DESTINATION_FIELD, INCLUDE_RETURN_PATH_FIELD, USE_MIDDLEBOXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartRouteAnalysisRequest.memberNameToFieldInitializer();
    private final String globalNetworkId;
    private final RouteAnalysisEndpointOptionsSpecification source;
    private final RouteAnalysisEndpointOptionsSpecification destination;
    private final Boolean includeReturnPath;
    private final Boolean useMiddleboxes;

    private StartRouteAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.globalNetworkId = builder.globalNetworkId;
        this.source = builder.source;
        this.destination = builder.destination;
        this.includeReturnPath = builder.includeReturnPath;
        this.useMiddleboxes = builder.useMiddleboxes;
    }

    public final String globalNetworkId() {
        return this.globalNetworkId;
    }

    public final RouteAnalysisEndpointOptionsSpecification source() {
        return this.source;
    }

    public final RouteAnalysisEndpointOptionsSpecification destination() {
        return this.destination;
    }

    public final Boolean includeReturnPath() {
        return this.includeReturnPath;
    }

    public final Boolean useMiddleboxes() {
        return this.useMiddleboxes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeReturnPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.useMiddleboxes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRouteAnalysisRequest)) {
            return false;
        }
        StartRouteAnalysisRequest other = (StartRouteAnalysisRequest)((Object)obj);
        return Objects.equals(this.globalNetworkId(), other.globalNetworkId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.includeReturnPath(), other.includeReturnPath()) && Objects.equals(this.useMiddleboxes(), other.useMiddleboxes());
    }

    public final String toString() {
        return ToString.builder((String)"StartRouteAnalysisRequest").add("GlobalNetworkId", (Object)this.globalNetworkId()).add("Source", (Object)this.source()).add("Destination", (Object)this.destination()).add("IncludeReturnPath", (Object)this.includeReturnPath()).add("UseMiddleboxes", (Object)this.useMiddleboxes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalNetworkId": {
                return Optional.ofNullable(clazz.cast(this.globalNetworkId()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "IncludeReturnPath": {
                return Optional.ofNullable(clazz.cast(this.includeReturnPath()));
            }
            case "UseMiddleboxes": {
                return Optional.ofNullable(clazz.cast(this.useMiddleboxes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("globalNetworkId", GLOBAL_NETWORK_ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("IncludeReturnPath", INCLUDE_RETURN_PATH_FIELD);
        map.put("UseMiddleboxes", USE_MIDDLEBOXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRouteAnalysisRequest, T> g) {
        return obj -> g.apply((StartRouteAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String globalNetworkId;
        private RouteAnalysisEndpointOptionsSpecification source;
        private RouteAnalysisEndpointOptionsSpecification destination;
        private Boolean includeReturnPath;
        private Boolean useMiddleboxes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRouteAnalysisRequest model) {
            super(model);
            this.globalNetworkId(model.globalNetworkId);
            this.source(model.source);
            this.destination(model.destination);
            this.includeReturnPath(model.includeReturnPath);
            this.useMiddleboxes(model.useMiddleboxes);
        }

        public final String getGlobalNetworkId() {
            return this.globalNetworkId;
        }

        public final void setGlobalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
        }

        @Override
        public final Builder globalNetworkId(String globalNetworkId) {
            this.globalNetworkId = globalNetworkId;
            return this;
        }

        public final RouteAnalysisEndpointOptionsSpecification.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(RouteAnalysisEndpointOptionsSpecification.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(RouteAnalysisEndpointOptionsSpecification source) {
            this.source = source;
            return this;
        }

        public final RouteAnalysisEndpointOptionsSpecification.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(RouteAnalysisEndpointOptionsSpecification.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(RouteAnalysisEndpointOptionsSpecification destination) {
            this.destination = destination;
            return this;
        }

        public final Boolean getIncludeReturnPath() {
            return this.includeReturnPath;
        }

        public final void setIncludeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
        }

        @Override
        public final Builder includeReturnPath(Boolean includeReturnPath) {
            this.includeReturnPath = includeReturnPath;
            return this;
        }

        public final Boolean getUseMiddleboxes() {
            return this.useMiddleboxes;
        }

        public final void setUseMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
        }

        @Override
        public final Builder useMiddleboxes(Boolean useMiddleboxes) {
            this.useMiddleboxes = useMiddleboxes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRouteAnalysisRequest build() {
            return new StartRouteAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRouteAnalysisRequest> {
        public Builder globalNetworkId(String var1);

        public Builder source(RouteAnalysisEndpointOptionsSpecification var1);

        default public Builder source(Consumer<RouteAnalysisEndpointOptionsSpecification.Builder> source) {
            return this.source((RouteAnalysisEndpointOptionsSpecification)((RouteAnalysisEndpointOptionsSpecification.Builder)RouteAnalysisEndpointOptionsSpecification.builder().applyMutation(source)).build());
        }

        public Builder destination(RouteAnalysisEndpointOptionsSpecification var1);

        default public Builder destination(Consumer<RouteAnalysisEndpointOptionsSpecification.Builder> destination) {
            return this.destination((RouteAnalysisEndpointOptionsSpecification)((RouteAnalysisEndpointOptionsSpecification.Builder)RouteAnalysisEndpointOptionsSpecification.builder().applyMutation(destination)).build());
        }

        public Builder includeReturnPath(Boolean var1);

        public Builder useMiddleboxes(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

