/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.oam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.oam.OamClient;
import software.amazon.awssdk.services.oam.model.ListSinksItem;
import software.amazon.awssdk.services.oam.model.ListSinksRequest;
import software.amazon.awssdk.services.oam.model.ListSinksResponse;

public class ListSinksIterable
implements SdkIterable<ListSinksResponse> {
    private final OamClient client;
    private final ListSinksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSinksIterable(OamClient client, ListSinksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSinksResponseFetcher();
    }

    public Iterator<ListSinksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSinksItem> items() {
        Function<ListSinksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSinksResponseFetcher
    implements SyncPageFetcher<ListSinksResponse> {
        private ListSinksResponseFetcher() {
        }

        public boolean hasNextPage(ListSinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSinksResponse nextPage(ListSinksResponse previousPage) {
            if (previousPage == null) {
                return ListSinksIterable.this.client.listSinks(ListSinksIterable.this.firstRequest);
            }
            return ListSinksIterable.this.client.listSinks((ListSinksRequest)((Object)ListSinksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

