/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pi.model.DimensionGroup;
import software.amazon.awssdk.services.pi.model.MetricQueryFilterMapCopier;
import software.amazon.awssdk.services.pi.model.PiRequest;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDimensionKeysRequest
extends PiRequest
implements ToCopyableBuilder<Builder, DescribeDimensionKeysRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::serviceTypeAsString)).setter(DescribeDimensionKeysRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::identifier)).setter(DescribeDimensionKeysRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::startTime)).setter(DescribeDimensionKeysRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::endTime)).setter(DescribeDimensionKeysRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::metric)).setter(DescribeDimensionKeysRequest.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::periodInSeconds)).setter(DescribeDimensionKeysRequest.setter(Builder::periodInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodInSeconds").build()}).build();
    private static final SdkField<DimensionGroup> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::groupBy)).setter(DescribeDimensionKeysRequest.setter(Builder::groupBy)).constructor(DimensionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build()}).build();
    private static final SdkField<DimensionGroup> PARTITION_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::partitionBy)).setter(DescribeDimensionKeysRequest.setter(Builder::partitionBy)).constructor(DimensionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionBy").build()}).build();
    private static final SdkField<Map<String, String>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::filter)).setter(DescribeDimensionKeysRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::maxResults)).setter(DescribeDimensionKeysRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDimensionKeysRequest.getter(DescribeDimensionKeysRequest::nextToken)).setter(DescribeDimensionKeysRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, IDENTIFIER_FIELD, START_TIME_FIELD, END_TIME_FIELD, METRIC_FIELD, PERIOD_IN_SECONDS_FIELD, GROUP_BY_FIELD, PARTITION_BY_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String serviceType;
    private final String identifier;
    private final Instant startTime;
    private final Instant endTime;
    private final String metric;
    private final Integer periodInSeconds;
    private final DimensionGroup groupBy;
    private final DimensionGroup partitionBy;
    private final Map<String, String> filter;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeDimensionKeysRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.metric = builder.metric;
        this.periodInSeconds = builder.periodInSeconds;
        this.groupBy = builder.groupBy;
        this.partitionBy = builder.partitionBy;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public String serviceTypeAsString() {
        return this.serviceType;
    }

    public String identifier() {
        return this.identifier;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String metric() {
        return this.metric;
    }

    public Integer periodInSeconds() {
        return this.periodInSeconds;
    }

    public DimensionGroup groupBy() {
        return this.groupBy;
    }

    public DimensionGroup partitionBy() {
        return this.partitionBy;
    }

    public boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public Map<String, String> filter() {
        return this.filter;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDimensionKeysRequest)) {
            return false;
        }
        DescribeDimensionKeysRequest other = (DescribeDimensionKeysRequest)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.metric(), other.metric()) && Objects.equals(this.periodInSeconds(), other.periodInSeconds()) && Objects.equals(this.groupBy(), other.groupBy()) && Objects.equals(this.partitionBy(), other.partitionBy()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDimensionKeysRequest").add("ServiceType", (Object)this.serviceTypeAsString()).add("Identifier", (Object)this.identifier()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Metric", (Object)this.metric()).add("PeriodInSeconds", (Object)this.periodInSeconds()).add("GroupBy", (Object)this.groupBy()).add("PartitionBy", (Object)this.partitionBy()).add("Filter", this.filter()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "PeriodInSeconds": {
                return Optional.ofNullable(clazz.cast(this.periodInSeconds()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "PartitionBy": {
                return Optional.ofNullable(clazz.cast(this.partitionBy()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDimensionKeysRequest, T> g) {
        return obj -> g.apply((DescribeDimensionKeysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiRequest.BuilderImpl
    implements Builder {
        private String serviceType;
        private String identifier;
        private Instant startTime;
        private Instant endTime;
        private String metric;
        private Integer periodInSeconds;
        private DimensionGroup groupBy;
        private DimensionGroup partitionBy;
        private Map<String, String> filter = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDimensionKeysRequest model) {
            super(model);
            this.serviceType(model.serviceType);
            this.identifier(model.identifier);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.metric(model.metric);
            this.periodInSeconds(model.periodInSeconds);
            this.groupBy(model.groupBy);
            this.partitionBy(model.partitionBy);
            this.filter(model.filter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getServiceTypeAsString() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getMetric() {
            return this.metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final Integer getPeriodInSeconds() {
            return this.periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        public final DimensionGroup.Builder getGroupBy() {
            return this.groupBy != null ? this.groupBy.toBuilder() : null;
        }

        @Override
        public final Builder groupBy(DimensionGroup groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final void setGroupBy(DimensionGroup.BuilderImpl groupBy) {
            this.groupBy = groupBy != null ? groupBy.build() : null;
        }

        public final DimensionGroup.Builder getPartitionBy() {
            return this.partitionBy != null ? this.partitionBy.toBuilder() : null;
        }

        @Override
        public final Builder partitionBy(DimensionGroup partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        public final void setPartitionBy(DimensionGroup.BuilderImpl partitionBy) {
            this.partitionBy = partitionBy != null ? partitionBy.build() : null;
        }

        public final Map<String, String> getFilter() {
            return this.filter;
        }

        @Override
        public final Builder filter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
            return this;
        }

        public final void setFilter(Map<String, String> filter) {
            this.filter = MetricQueryFilterMapCopier.copy(filter);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDimensionKeysRequest build() {
            return new DescribeDimensionKeysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDimensionKeysRequest> {
        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder identifier(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder metric(String var1);

        public Builder periodInSeconds(Integer var1);

        public Builder groupBy(DimensionGroup var1);

        default public Builder groupBy(Consumer<DimensionGroup.Builder> groupBy) {
            return this.groupBy((DimensionGroup)((DimensionGroup.Builder)DimensionGroup.builder().applyMutation(groupBy)).build());
        }

        public Builder partitionBy(DimensionGroup var1);

        default public Builder partitionBy(Consumer<DimensionGroup.Builder> partitionBy) {
            return this.partitionBy((DimensionGroup)((DimensionGroup.Builder)DimensionGroup.builder().applyMutation(partitionBy)).build());
        }

        public Builder filter(Map<String, String> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

