/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.polly.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.polly.PollyAsyncClient;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksRequest;
import software.amazon.awssdk.services.polly.model.ListSpeechSynthesisTasksResponse;

public class ListSpeechSynthesisTasksPublisher
implements SdkPublisher<ListSpeechSynthesisTasksResponse> {
    private final PollyAsyncClient client;
    private final ListSpeechSynthesisTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSpeechSynthesisTasksPublisher(PollyAsyncClient client, ListSpeechSynthesisTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSpeechSynthesisTasksPublisher(PollyAsyncClient client, ListSpeechSynthesisTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSpeechSynthesisTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSpeechSynthesisTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListSpeechSynthesisTasksPublisher resume(ListSpeechSynthesisTasksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListSpeechSynthesisTasksPublisher(this.client, (ListSpeechSynthesisTasksRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListSpeechSynthesisTasksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListSpeechSynthesisTasksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListSpeechSynthesisTasksResponseFetcher
    implements AsyncPageFetcher<ListSpeechSynthesisTasksResponse> {
        private ListSpeechSynthesisTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListSpeechSynthesisTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSpeechSynthesisTasksResponse> nextPage(ListSpeechSynthesisTasksResponse previousPage) {
            if (previousPage == null) {
                return ListSpeechSynthesisTasksPublisher.this.client.listSpeechSynthesisTasks(ListSpeechSynthesisTasksPublisher.this.firstRequest);
            }
            return ListSpeechSynthesisTasksPublisher.this.client.listSpeechSynthesisTasks((ListSpeechSynthesisTasksRequest)((Object)ListSpeechSynthesisTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

