/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.QBusinessRequest;
import software.amazon.awssdk.services.qbusiness.model.UserAlias;
import software.amazon.awssdk.services.qbusiness.model.UserAliasesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateUserRequest
extends QBusinessRequest
implements ToCopyableBuilder<Builder, UpdateUserRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(UpdateUserRequest.getter(UpdateUserRequest::applicationId)).setter(UpdateUserRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(UpdateUserRequest.getter(UpdateUserRequest::userId)).setter(UpdateUserRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("userId").build()}).build();
    private static final SdkField<List<UserAlias>> USER_ALIASES_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAliasesToUpdate").getter(UpdateUserRequest.getter(UpdateUserRequest::userAliasesToUpdate)).setter(UpdateUserRequest.setter(Builder::userAliasesToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UserAlias>> USER_ALIASES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userAliasesToDelete").getter(UpdateUserRequest.getter(UpdateUserRequest::userAliasesToDelete)).setter(UpdateUserRequest.setter(Builder::userAliasesToDelete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAliasesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, USER_ID_FIELD, USER_ALIASES_TO_UPDATE_FIELD, USER_ALIASES_TO_DELETE_FIELD));
    private final String applicationId;
    private final String userId;
    private final List<UserAlias> userAliasesToUpdate;
    private final List<UserAlias> userAliasesToDelete;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.userId = builder.userId;
        this.userAliasesToUpdate = builder.userAliasesToUpdate;
        this.userAliasesToDelete = builder.userAliasesToDelete;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasUserAliasesToUpdate() {
        return this.userAliasesToUpdate != null && !(this.userAliasesToUpdate instanceof SdkAutoConstructList);
    }

    public final List<UserAlias> userAliasesToUpdate() {
        return this.userAliasesToUpdate;
    }

    public final boolean hasUserAliasesToDelete() {
        return this.userAliasesToDelete != null && !(this.userAliasesToDelete instanceof SdkAutoConstructList);
    }

    public final List<UserAlias> userAliasesToDelete() {
        return this.userAliasesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAliasesToUpdate() ? this.userAliasesToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAliasesToDelete() ? this.userAliasesToDelete() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.userId(), other.userId()) && this.hasUserAliasesToUpdate() == other.hasUserAliasesToUpdate() && Objects.equals(this.userAliasesToUpdate(), other.userAliasesToUpdate()) && this.hasUserAliasesToDelete() == other.hasUserAliasesToDelete() && Objects.equals(this.userAliasesToDelete(), other.userAliasesToDelete());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateUserRequest").add("ApplicationId", (Object)this.applicationId()).add("UserId", (Object)this.userId()).add("UserAliasesToUpdate", this.hasUserAliasesToUpdate() ? this.userAliasesToUpdate() : null).add("UserAliasesToDelete", this.hasUserAliasesToDelete() ? this.userAliasesToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "userAliasesToUpdate": {
                return Optional.ofNullable(clazz.cast(this.userAliasesToUpdate()));
            }
            case "userAliasesToDelete": {
                return Optional.ofNullable(clazz.cast(this.userAliasesToDelete()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String userId;
        private List<UserAlias> userAliasesToUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<UserAlias> userAliasesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.userId(model.userId);
            this.userAliasesToUpdate(model.userAliasesToUpdate);
            this.userAliasesToDelete(model.userAliasesToDelete);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final List<UserAlias.Builder> getUserAliasesToUpdate() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesToUpdate(Collection<UserAlias.BuilderImpl> userAliasesToUpdate) {
            this.userAliasesToUpdate = UserAliasesCopier.copyFromBuilder(userAliasesToUpdate);
        }

        @Override
        public final Builder userAliasesToUpdate(Collection<UserAlias> userAliasesToUpdate) {
            this.userAliasesToUpdate = UserAliasesCopier.copy(userAliasesToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToUpdate(UserAlias ... userAliasesToUpdate) {
            this.userAliasesToUpdate(Arrays.asList(userAliasesToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToUpdate(Consumer<UserAlias.Builder> ... userAliasesToUpdate) {
            this.userAliasesToUpdate(Stream.of(userAliasesToUpdate).map(c -> (UserAlias)((UserAlias.Builder)UserAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UserAlias.Builder> getUserAliasesToDelete() {
            List<UserAlias.Builder> result = UserAliasesCopier.copyToBuilder(this.userAliasesToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserAliasesToDelete(Collection<UserAlias.BuilderImpl> userAliasesToDelete) {
            this.userAliasesToDelete = UserAliasesCopier.copyFromBuilder(userAliasesToDelete);
        }

        @Override
        public final Builder userAliasesToDelete(Collection<UserAlias> userAliasesToDelete) {
            this.userAliasesToDelete = UserAliasesCopier.copy(userAliasesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToDelete(UserAlias ... userAliasesToDelete) {
            this.userAliasesToDelete(Arrays.asList(userAliasesToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAliasesToDelete(Consumer<UserAlias.Builder> ... userAliasesToDelete) {
            this.userAliasesToDelete(Stream.of(userAliasesToDelete).map(c -> (UserAlias)((UserAlias.Builder)UserAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateUserRequest> {
        public Builder applicationId(String var1);

        public Builder userId(String var1);

        public Builder userAliasesToUpdate(Collection<UserAlias> var1);

        public Builder userAliasesToUpdate(UserAlias ... var1);

        public Builder userAliasesToUpdate(Consumer<UserAlias.Builder> ... var1);

        public Builder userAliasesToDelete(Collection<UserAlias> var1);

        public Builder userAliasesToDelete(UserAlias ... var1);

        public Builder userAliasesToDelete(Consumer<UserAlias.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

