/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.ProtocolMarshaller;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.services.qbusiness.model.EndOfInputEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EndOfInputEventMarshaller
implements Marshaller<EndOfInputEvent> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().hasExplicitPayloadMember(false).hasPayloadMembers(false).hasImplicitPayloadMembers(false).httpMethod(SdkHttpMethod.GET).hasEvent(true).build();
    private final BaseAwsJsonProtocolFactory protocolFactory;

    public EndOfInputEventMarshaller(BaseAwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public SdkHttpFullRequest marshall(EndOfInputEvent endOfInputEvent) {
        Validate.paramNotNull((Object)endOfInputEvent, (String)"endOfInputEvent");
        try {
            ProtocolMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING);
            return ((SdkHttpFullRequest)protocolMarshaller.marshall((SdkPojo)endOfInputEvent)).toBuilder().putHeader(":message-type", "event").putHeader(":event-type", endOfInputEvent.sdkEventType().toString()).build();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

