/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfiguration;
import software.amazon.awssdk.services.qbusiness.model.DocumentAttributeConfigurationsCopier;
import software.amazon.awssdk.services.qbusiness.model.ErrorDetail;
import software.amazon.awssdk.services.qbusiness.model.IndexCapacityConfiguration;
import software.amazon.awssdk.services.qbusiness.model.IndexStatistics;
import software.amazon.awssdk.services.qbusiness.model.IndexStatus;
import software.amazon.awssdk.services.qbusiness.model.IndexType;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIndexResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetIndexResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetIndexResponse.getter(GetIndexResponse::applicationId)).setter(GetIndexResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexId").getter(GetIndexResponse.getter(GetIndexResponse::indexId)).setter(GetIndexResponse.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetIndexResponse.getter(GetIndexResponse::displayName)).setter(GetIndexResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetIndexResponse.getter(GetIndexResponse::typeAsString)).setter(GetIndexResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(GetIndexResponse.getter(GetIndexResponse::indexArn)).setter(GetIndexResponse.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetIndexResponse.getter(GetIndexResponse::statusAsString)).setter(GetIndexResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetIndexResponse.getter(GetIndexResponse::description)).setter(GetIndexResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetIndexResponse.getter(GetIndexResponse::createdAt)).setter(GetIndexResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetIndexResponse.getter(GetIndexResponse::updatedAt)).setter(GetIndexResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<IndexCapacityConfiguration> CAPACITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capacityConfiguration").getter(GetIndexResponse.getter(GetIndexResponse::capacityConfiguration)).setter(GetIndexResponse.setter(Builder::capacityConfiguration)).constructor(IndexCapacityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityConfiguration").build()}).build();
    private static final SdkField<List<DocumentAttributeConfiguration>> DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documentAttributeConfigurations").getter(GetIndexResponse.getter(GetIndexResponse::documentAttributeConfigurations)).setter(GetIndexResponse.setter(Builder::documentAttributeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentAttributeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentAttributeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetIndexResponse.getter(GetIndexResponse::error)).setter(GetIndexResponse.setter(Builder::error)).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<IndexStatistics> INDEX_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("indexStatistics").getter(GetIndexResponse.getter(GetIndexResponse::indexStatistics)).setter(GetIndexResponse.setter(Builder::indexStatistics)).constructor(IndexStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexStatistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, INDEX_ID_FIELD, DISPLAY_NAME_FIELD, TYPE_FIELD, INDEX_ARN_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, CAPACITY_CONFIGURATION_FIELD, DOCUMENT_ATTRIBUTE_CONFIGURATIONS_FIELD, ERROR_FIELD, INDEX_STATISTICS_FIELD));
    private final String applicationId;
    private final String indexId;
    private final String displayName;
    private final String type;
    private final String indexArn;
    private final String status;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final IndexCapacityConfiguration capacityConfiguration;
    private final List<DocumentAttributeConfiguration> documentAttributeConfigurations;
    private final ErrorDetail error;
    private final IndexStatistics indexStatistics;

    private GetIndexResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.indexId = builder.indexId;
        this.displayName = builder.displayName;
        this.type = builder.type;
        this.indexArn = builder.indexArn;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.capacityConfiguration = builder.capacityConfiguration;
        this.documentAttributeConfigurations = builder.documentAttributeConfigurations;
        this.error = builder.error;
        this.indexStatistics = builder.indexStatistics;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final IndexType type() {
        return IndexType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final IndexStatus status() {
        return IndexStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final IndexCapacityConfiguration capacityConfiguration() {
        return this.capacityConfiguration;
    }

    public final boolean hasDocumentAttributeConfigurations() {
        return this.documentAttributeConfigurations != null && !(this.documentAttributeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<DocumentAttributeConfiguration> documentAttributeConfigurations() {
        return this.documentAttributeConfigurations;
    }

    public final ErrorDetail error() {
        return this.error;
    }

    public final IndexStatistics indexStatistics() {
        return this.indexStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentAttributeConfigurations() ? this.documentAttributeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexResponse)) {
            return false;
        }
        GetIndexResponse other = (GetIndexResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.capacityConfiguration(), other.capacityConfiguration()) && this.hasDocumentAttributeConfigurations() == other.hasDocumentAttributeConfigurations() && Objects.equals(this.documentAttributeConfigurations(), other.documentAttributeConfigurations()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.indexStatistics(), other.indexStatistics());
    }

    public final String toString() {
        return ToString.builder((String)"GetIndexResponse").add("ApplicationId", (Object)this.applicationId()).add("IndexId", (Object)this.indexId()).add("DisplayName", (Object)this.displayName()).add("Type", (Object)this.typeAsString()).add("IndexArn", (Object)this.indexArn()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("CapacityConfiguration", (Object)this.capacityConfiguration()).add("DocumentAttributeConfigurations", this.hasDocumentAttributeConfigurations() ? this.documentAttributeConfigurations() : null).add("Error", (Object)this.error()).add("IndexStatistics", (Object)this.indexStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "indexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "capacityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capacityConfiguration()));
            }
            case "documentAttributeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeConfigurations()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "indexStatistics": {
                return Optional.ofNullable(clazz.cast(this.indexStatistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIndexResponse, T> g) {
        return obj -> g.apply((GetIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String indexId;
        private String displayName;
        private String type;
        private String indexArn;
        private String status;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private IndexCapacityConfiguration capacityConfiguration;
        private List<DocumentAttributeConfiguration> documentAttributeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private ErrorDetail error;
        private IndexStatistics indexStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.indexId(model.indexId);
            this.displayName(model.displayName);
            this.type(model.type);
            this.indexArn(model.indexArn);
            this.status(model.status);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.capacityConfiguration(model.capacityConfiguration);
            this.documentAttributeConfigurations(model.documentAttributeConfigurations);
            this.error(model.error);
            this.indexStatistics(model.indexStatistics);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IndexType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IndexStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final IndexCapacityConfiguration.Builder getCapacityConfiguration() {
            return this.capacityConfiguration != null ? this.capacityConfiguration.toBuilder() : null;
        }

        public final void setCapacityConfiguration(IndexCapacityConfiguration.BuilderImpl capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration != null ? capacityConfiguration.build() : null;
        }

        @Override
        public final Builder capacityConfiguration(IndexCapacityConfiguration capacityConfiguration) {
            this.capacityConfiguration = capacityConfiguration;
            return this;
        }

        public final List<DocumentAttributeConfiguration.Builder> getDocumentAttributeConfigurations() {
            List<DocumentAttributeConfiguration.Builder> result = DocumentAttributeConfigurationsCopier.copyToBuilder(this.documentAttributeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributeConfigurations(Collection<DocumentAttributeConfiguration.BuilderImpl> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier.copyFromBuilder(documentAttributeConfigurations);
        }

        @Override
        public final Builder documentAttributeConfigurations(Collection<DocumentAttributeConfiguration> documentAttributeConfigurations) {
            this.documentAttributeConfigurations = DocumentAttributeConfigurationsCopier.copy(documentAttributeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(DocumentAttributeConfiguration ... documentAttributeConfigurations) {
            this.documentAttributeConfigurations(Arrays.asList(documentAttributeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeConfigurations(Consumer<DocumentAttributeConfiguration.Builder> ... documentAttributeConfigurations) {
            this.documentAttributeConfigurations(Stream.of(documentAttributeConfigurations).map(c -> (DocumentAttributeConfiguration)((DocumentAttributeConfiguration.Builder)DocumentAttributeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final IndexStatistics.Builder getIndexStatistics() {
            return this.indexStatistics != null ? this.indexStatistics.toBuilder() : null;
        }

        public final void setIndexStatistics(IndexStatistics.BuilderImpl indexStatistics) {
            this.indexStatistics = indexStatistics != null ? indexStatistics.build() : null;
        }

        @Override
        public final Builder indexStatistics(IndexStatistics indexStatistics) {
            this.indexStatistics = indexStatistics;
            return this;
        }

        @Override
        public GetIndexResponse build() {
            return new GetIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIndexResponse> {
        public Builder applicationId(String var1);

        public Builder indexId(String var1);

        public Builder displayName(String var1);

        public Builder type(String var1);

        public Builder type(IndexType var1);

        public Builder indexArn(String var1);

        public Builder status(String var1);

        public Builder status(IndexStatus var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder capacityConfiguration(IndexCapacityConfiguration var1);

        default public Builder capacityConfiguration(Consumer<IndexCapacityConfiguration.Builder> capacityConfiguration) {
            return this.capacityConfiguration((IndexCapacityConfiguration)((IndexCapacityConfiguration.Builder)IndexCapacityConfiguration.builder().applyMutation(capacityConfiguration)).build());
        }

        public Builder documentAttributeConfigurations(Collection<DocumentAttributeConfiguration> var1);

        public Builder documentAttributeConfigurations(DocumentAttributeConfiguration ... var1);

        public Builder documentAttributeConfigurations(Consumer<DocumentAttributeConfiguration.Builder> ... var1);

        public Builder error(ErrorDetail var1);

        default public Builder error(Consumer<ErrorDetail.Builder> error) {
            return this.error((ErrorDetail)((ErrorDetail.Builder)ErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder indexStatistics(IndexStatistics var1);

        default public Builder indexStatistics(Consumer<IndexStatistics.Builder> indexStatistics) {
            return this.indexStatistics((IndexStatistics)((IndexStatistics.Builder)IndexStatistics.builder().applyMutation(indexStatistics)).build());
        }
    }
}

