/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.Conversation;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsRequest;
import software.amazon.awssdk.services.qbusiness.model.ListConversationsResponse;

public class ListConversationsIterable
implements SdkIterable<ListConversationsResponse> {
    private final QBusinessClient client;
    private final ListConversationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConversationsIterable(QBusinessClient client, ListConversationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConversationsResponseFetcher();
    }

    public Iterator<ListConversationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Conversation> conversations() {
        Function<ListConversationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.conversations() != null) {
                return response.conversations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConversationsResponseFetcher
    implements SyncPageFetcher<ListConversationsResponse> {
        private ListConversationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConversationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConversationsResponse nextPage(ListConversationsResponse previousPage) {
            if (previousPage == null) {
                return ListConversationsIterable.this.client.listConversations(ListConversationsIterable.this.firstRequest);
            }
            return ListConversationsIterable.this.client.listConversations((ListConversationsRequest)((Object)ListConversationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

