/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qbusiness.model.ActionConfiguration;
import software.amazon.awssdk.services.qbusiness.model.ActionConfigurationListCopier;
import software.amazon.awssdk.services.qbusiness.model.QBusinessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataAccessorResponse
extends QBusinessResponse
implements ToCopyableBuilder<Builder, GetDataAccessorResponse> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::displayName)).setter(GetDataAccessorResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DATA_ACCESSOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessorId").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::dataAccessorId)).setter(GetDataAccessorResponse.setter(Builder::dataAccessorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorId").build()}).build();
    private static final SdkField<String> DATA_ACCESSOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessorArn").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::dataAccessorArn)).setter(GetDataAccessorResponse.setter(Builder::dataAccessorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessorArn").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::applicationId)).setter(GetDataAccessorResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idcApplicationArn").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::idcApplicationArn)).setter(GetDataAccessorResponse.setter(Builder::idcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idcApplicationArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principal").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::principal)).setter(GetDataAccessorResponse.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build()}).build();
    private static final SdkField<List<ActionConfiguration>> ACTION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionConfigurations").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::actionConfigurations)).setter(GetDataAccessorResponse.setter(Builder::actionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::createdAt)).setter(GetDataAccessorResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetDataAccessorResponse.getter(GetDataAccessorResponse::updatedAt)).setter(GetDataAccessorResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, DATA_ACCESSOR_ID_FIELD, DATA_ACCESSOR_ARN_FIELD, APPLICATION_ID_FIELD, IDC_APPLICATION_ARN_FIELD, PRINCIPAL_FIELD, ACTION_CONFIGURATIONS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataAccessorResponse.memberNameToFieldInitializer();
    private final String displayName;
    private final String dataAccessorId;
    private final String dataAccessorArn;
    private final String applicationId;
    private final String idcApplicationArn;
    private final String principal;
    private final List<ActionConfiguration> actionConfigurations;
    private final Instant createdAt;
    private final Instant updatedAt;

    private GetDataAccessorResponse(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.dataAccessorId = builder.dataAccessorId;
        this.dataAccessorArn = builder.dataAccessorArn;
        this.applicationId = builder.applicationId;
        this.idcApplicationArn = builder.idcApplicationArn;
        this.principal = builder.principal;
        this.actionConfigurations = builder.actionConfigurations;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String dataAccessorId() {
        return this.dataAccessorId;
    }

    public final String dataAccessorArn() {
        return this.dataAccessorArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String idcApplicationArn() {
        return this.idcApplicationArn;
    }

    public final String principal() {
        return this.principal;
    }

    public final boolean hasActionConfigurations() {
        return this.actionConfigurations != null && !(this.actionConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ActionConfiguration> actionConfigurations() {
        return this.actionConfigurations;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionConfigurations() ? this.actionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataAccessorResponse)) {
            return false;
        }
        GetDataAccessorResponse other = (GetDataAccessorResponse)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.dataAccessorId(), other.dataAccessorId()) && Objects.equals(this.dataAccessorArn(), other.dataAccessorArn()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.idcApplicationArn(), other.idcApplicationArn()) && Objects.equals(this.principal(), other.principal()) && this.hasActionConfigurations() == other.hasActionConfigurations() && Objects.equals(this.actionConfigurations(), other.actionConfigurations()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataAccessorResponse").add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("DataAccessorId", (Object)this.dataAccessorId()).add("DataAccessorArn", (Object)this.dataAccessorArn()).add("ApplicationId", (Object)this.applicationId()).add("IdcApplicationArn", (Object)this.idcApplicationArn()).add("Principal", (Object)this.principal()).add("ActionConfigurations", this.hasActionConfigurations() ? this.actionConfigurations() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "dataAccessorId": {
                return Optional.ofNullable(clazz.cast(this.dataAccessorId()));
            }
            case "dataAccessorArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessorArn()));
            }
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "idcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.idcApplicationArn()));
            }
            case "principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "actionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.actionConfigurations()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("dataAccessorId", DATA_ACCESSOR_ID_FIELD);
        map.put("dataAccessorArn", DATA_ACCESSOR_ARN_FIELD);
        map.put("applicationId", APPLICATION_ID_FIELD);
        map.put("idcApplicationArn", IDC_APPLICATION_ARN_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("actionConfigurations", ACTION_CONFIGURATIONS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataAccessorResponse, T> g) {
        return obj -> g.apply((GetDataAccessorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QBusinessResponse.BuilderImpl
    implements Builder {
        private String displayName;
        private String dataAccessorId;
        private String dataAccessorArn;
        private String applicationId;
        private String idcApplicationArn;
        private String principal;
        private List<ActionConfiguration> actionConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataAccessorResponse model) {
            super(model);
            this.displayName(model.displayName);
            this.dataAccessorId(model.dataAccessorId);
            this.dataAccessorArn(model.dataAccessorArn);
            this.applicationId(model.applicationId);
            this.idcApplicationArn(model.idcApplicationArn);
            this.principal(model.principal);
            this.actionConfigurations(model.actionConfigurations);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDataAccessorId() {
            return this.dataAccessorId;
        }

        public final void setDataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
        }

        @Override
        public final Builder dataAccessorId(String dataAccessorId) {
            this.dataAccessorId = dataAccessorId;
            return this;
        }

        public final String getDataAccessorArn() {
            return this.dataAccessorArn;
        }

        public final void setDataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
        }

        @Override
        public final Builder dataAccessorArn(String dataAccessorArn) {
            this.dataAccessorArn = dataAccessorArn;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getIdcApplicationArn() {
            return this.idcApplicationArn;
        }

        public final void setIdcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
        }

        @Override
        public final Builder idcApplicationArn(String idcApplicationArn) {
            this.idcApplicationArn = idcApplicationArn;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final List<ActionConfiguration.Builder> getActionConfigurations() {
            List<ActionConfiguration.Builder> result = ActionConfigurationListCopier.copyToBuilder(this.actionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionConfigurations(Collection<ActionConfiguration.BuilderImpl> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copyFromBuilder(actionConfigurations);
        }

        @Override
        public final Builder actionConfigurations(Collection<ActionConfiguration> actionConfigurations) {
            this.actionConfigurations = ActionConfigurationListCopier.copy(actionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(ActionConfiguration ... actionConfigurations) {
            this.actionConfigurations(Arrays.asList(actionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionConfigurations(Consumer<ActionConfiguration.Builder> ... actionConfigurations) {
            this.actionConfigurations(Stream.of(actionConfigurations).map(c -> (ActionConfiguration)((ActionConfiguration.Builder)ActionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetDataAccessorResponse build() {
            return new GetDataAccessorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataAccessorResponse> {
        public Builder displayName(String var1);

        public Builder dataAccessorId(String var1);

        public Builder dataAccessorArn(String var1);

        public Builder applicationId(String var1);

        public Builder idcApplicationArn(String var1);

        public Builder principal(String var1);

        public Builder actionConfigurations(Collection<ActionConfiguration> var1);

        public Builder actionConfigurations(ActionConfiguration ... var1);

        public Builder actionConfigurations(Consumer<ActionConfiguration.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

