/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qbusiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qbusiness.QBusinessClient;
import software.amazon.awssdk.services.qbusiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversRequest;
import software.amazon.awssdk.services.qbusiness.model.ListRetrieversResponse;
import software.amazon.awssdk.services.qbusiness.model.Retriever;

public class ListRetrieversIterable
implements SdkIterable<ListRetrieversResponse> {
    private final QBusinessClient client;
    private final ListRetrieversRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRetrieversIterable(QBusinessClient client, ListRetrieversRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRetrieversResponseFetcher();
    }

    public Iterator<ListRetrieversResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Retriever> retrievers() {
        Function<ListRetrieversResponse, Iterator> getIterator = response -> {
            if (response != null && response.retrievers() != null) {
                return response.retrievers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRetrieversResponseFetcher
    implements SyncPageFetcher<ListRetrieversResponse> {
        private ListRetrieversResponseFetcher() {
        }

        public boolean hasNextPage(ListRetrieversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRetrieversResponse nextPage(ListRetrieversResponse previousPage) {
            if (previousPage == null) {
                return ListRetrieversIterable.this.client.listRetrievers(ListRetrieversIterable.this.firstRequest);
            }
            return ListRetrieversIterable.this.client.listRetrievers((ListRetrieversRequest)((Object)ListRetrieversIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

