/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AssistantCapabilityConfiguration;
import software.amazon.awssdk.services.qconnect.model.AssistantIntegrationConfiguration;
import software.amazon.awssdk.services.qconnect.model.AssistantStatus;
import software.amazon.awssdk.services.qconnect.model.AssistantType;
import software.amazon.awssdk.services.qconnect.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.qconnect.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssistantData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssistantData> {
    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantArn").getter(AssistantData.getter(AssistantData::assistantArn)).setter(AssistantData.setter(Builder::assistantArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(AssistantData.getter(AssistantData::assistantId)).setter(AssistantData.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()}).build();
    private static final SdkField<AssistantCapabilityConfiguration> CAPABILITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("capabilityConfiguration").getter(AssistantData.getter(AssistantData::capabilityConfiguration)).setter(AssistantData.setter(Builder::capabilityConfiguration)).constructor(AssistantCapabilityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilityConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AssistantData.getter(AssistantData::description)).setter(AssistantData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<AssistantIntegrationConfiguration> INTEGRATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("integrationConfiguration").getter(AssistantData.getter(AssistantData::integrationConfiguration)).setter(AssistantData.setter(Builder::integrationConfiguration)).constructor(AssistantIntegrationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssistantData.getter(AssistantData::name)).setter(AssistantData.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryptionConfiguration").getter(AssistantData.getter(AssistantData::serverSideEncryptionConfiguration)).setter(AssistantData.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AssistantData.getter(AssistantData::statusAsString)).setter(AssistantData.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AssistantData.getter(AssistantData::tags)).setter(AssistantData.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AssistantData.getter(AssistantData::typeAsString)).setter(AssistantData.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ARN_FIELD, ASSISTANT_ID_FIELD, CAPABILITY_CONFIGURATION_FIELD, DESCRIPTION_FIELD, INTEGRATION_CONFIGURATION_FIELD, NAME_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assistantArn;
    private final String assistantId;
    private final AssistantCapabilityConfiguration capabilityConfiguration;
    private final String description;
    private final AssistantIntegrationConfiguration integrationConfiguration;
    private final String name;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final String status;
    private final Map<String, String> tags;
    private final String type;

    private AssistantData(BuilderImpl builder) {
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.capabilityConfiguration = builder.capabilityConfiguration;
        this.description = builder.description;
        this.integrationConfiguration = builder.integrationConfiguration;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String assistantArn() {
        return this.assistantArn;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final AssistantCapabilityConfiguration capabilityConfiguration() {
        return this.capabilityConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final AssistantIntegrationConfiguration integrationConfiguration() {
        return this.integrationConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final AssistantStatus status() {
        return AssistantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AssistantType type() {
        return AssistantType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssistantData)) {
            return false;
        }
        AssistantData other = (AssistantData)obj;
        return Objects.equals(this.assistantArn(), other.assistantArn()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.capabilityConfiguration(), other.capabilityConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.integrationConfiguration(), other.integrationConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssistantData").add("AssistantArn", (Object)this.assistantArn()).add("AssistantId", (Object)this.assistantId()).add("CapabilityConfiguration", (Object)this.capabilityConfiguration()).add("Description", (Object)this.description()).add("IntegrationConfiguration", (Object)this.integrationConfiguration()).add("Name", (Object)this.name()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantArn": {
                return Optional.ofNullable(clazz.cast(this.assistantArn()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "capabilityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.capabilityConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "integrationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.integrationConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serverSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssistantData, T> g) {
        return obj -> g.apply((AssistantData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assistantArn;
        private String assistantId;
        private AssistantCapabilityConfiguration capabilityConfiguration;
        private String description;
        private AssistantIntegrationConfiguration integrationConfiguration;
        private String name;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AssistantData model) {
            this.assistantArn(model.assistantArn);
            this.assistantId(model.assistantId);
            this.capabilityConfiguration(model.capabilityConfiguration);
            this.description(model.description);
            this.integrationConfiguration(model.integrationConfiguration);
            this.name(model.name);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.status(model.status);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getAssistantArn() {
            return this.assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final AssistantCapabilityConfiguration.Builder getCapabilityConfiguration() {
            return this.capabilityConfiguration != null ? this.capabilityConfiguration.toBuilder() : null;
        }

        public final void setCapabilityConfiguration(AssistantCapabilityConfiguration.BuilderImpl capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration != null ? capabilityConfiguration.build() : null;
        }

        @Override
        public final Builder capabilityConfiguration(AssistantCapabilityConfiguration capabilityConfiguration) {
            this.capabilityConfiguration = capabilityConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AssistantIntegrationConfiguration.Builder getIntegrationConfiguration() {
            return this.integrationConfiguration != null ? this.integrationConfiguration.toBuilder() : null;
        }

        public final void setIntegrationConfiguration(AssistantIntegrationConfiguration.BuilderImpl integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration != null ? integrationConfiguration.build() : null;
        }

        @Override
        public final Builder integrationConfiguration(AssistantIntegrationConfiguration integrationConfiguration) {
            this.integrationConfiguration = integrationConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AssistantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AssistantType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public AssistantData build() {
            return new AssistantData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssistantData> {
        public Builder assistantArn(String var1);

        public Builder assistantId(String var1);

        public Builder capabilityConfiguration(AssistantCapabilityConfiguration var1);

        default public Builder capabilityConfiguration(Consumer<AssistantCapabilityConfiguration.Builder> capabilityConfiguration) {
            return this.capabilityConfiguration((AssistantCapabilityConfiguration)((AssistantCapabilityConfiguration.Builder)AssistantCapabilityConfiguration.builder().applyMutation(capabilityConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder integrationConfiguration(AssistantIntegrationConfiguration var1);

        default public Builder integrationConfiguration(Consumer<AssistantIntegrationConfiguration.Builder> integrationConfiguration) {
            return this.integrationConfiguration((AssistantIntegrationConfiguration)((AssistantIntegrationConfiguration.Builder)AssistantIntegrationConfiguration.builder().applyMutation(integrationConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(AssistantStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(AssistantType var1);
    }
}

