/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.DataSummary;
import software.amazon.awssdk.services.qconnect.model.Document;
import software.amazon.awssdk.services.qconnect.model.RecommendationType;
import software.amazon.awssdk.services.qconnect.model.RelevanceLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationData> {
    private static final SdkField<DataSummary> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(RecommendationData.getter(RecommendationData::data)).setter(RecommendationData.setter(Builder::data)).constructor(DataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<Document> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(RecommendationData.getter(RecommendationData::document)).setter(RecommendationData.setter(Builder::document)).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(RecommendationData.getter(RecommendationData::recommendationId)).setter(RecommendationData.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<String> RELEVANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relevanceLevel").getter(RecommendationData.getter(RecommendationData::relevanceLevelAsString)).setter(RecommendationData.setter(Builder::relevanceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceLevel").build()}).build();
    private static final SdkField<Double> RELEVANCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("relevanceScore").getter(RecommendationData.getter(RecommendationData::relevanceScore)).setter(RecommendationData.setter(Builder::relevanceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RecommendationData.getter(RecommendationData::typeAsString)).setter(RecommendationData.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, DOCUMENT_FIELD, RECOMMENDATION_ID_FIELD, RELEVANCE_LEVEL_FIELD, RELEVANCE_SCORE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("data", DATA_FIELD);
            this.put("document", DOCUMENT_FIELD);
            this.put("recommendationId", RECOMMENDATION_ID_FIELD);
            this.put("relevanceLevel", RELEVANCE_LEVEL_FIELD);
            this.put("relevanceScore", RELEVANCE_SCORE_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DataSummary data;
    private final Document document;
    private final String recommendationId;
    private final String relevanceLevel;
    private final Double relevanceScore;
    private final String type;

    private RecommendationData(BuilderImpl builder) {
        this.data = builder.data;
        this.document = builder.document;
        this.recommendationId = builder.recommendationId;
        this.relevanceLevel = builder.relevanceLevel;
        this.relevanceScore = builder.relevanceScore;
        this.type = builder.type;
    }

    public final DataSummary data() {
        return this.data;
    }

    public final Document document() {
        return this.document;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final RelevanceLevel relevanceLevel() {
        return RelevanceLevel.fromValue(this.relevanceLevel);
    }

    public final String relevanceLevelAsString() {
        return this.relevanceLevel;
    }

    public final Double relevanceScore() {
        return this.relevanceScore;
    }

    public final RecommendationType type() {
        return RecommendationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.relevanceScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationData)) {
            return false;
        }
        RecommendationData other = (RecommendationData)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.document(), other.document()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.relevanceLevelAsString(), other.relevanceLevelAsString()) && Objects.equals(this.relevanceScore(), other.relevanceScore()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationData").add("Data", (Object)this.data()).add("Document", (Object)this.document()).add("RecommendationId", (Object)this.recommendationId()).add("RelevanceLevel", (Object)this.relevanceLevelAsString()).add("RelevanceScore", (Object)this.relevanceScore()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "relevanceLevel": {
                return Optional.ofNullable(clazz.cast(this.relevanceLevelAsString()));
            }
            case "relevanceScore": {
                return Optional.ofNullable(clazz.cast(this.relevanceScore()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationData, T> g) {
        return obj -> g.apply((RecommendationData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataSummary data;
        private Document document;
        private String recommendationId;
        private String relevanceLevel;
        private Double relevanceScore;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationData model) {
            this.data(model.data);
            this.document(model.document);
            this.recommendationId(model.recommendationId);
            this.relevanceLevel(model.relevanceLevel);
            this.relevanceScore(model.relevanceScore);
            this.type(model.type);
        }

        public final DataSummary.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(DataSummary.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(DataSummary data) {
            this.data = data;
            return this;
        }

        public final Document.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(Document.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(Document document) {
            this.document = document;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getRelevanceLevel() {
            return this.relevanceLevel;
        }

        public final void setRelevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
        }

        @Override
        public final Builder relevanceLevel(String relevanceLevel) {
            this.relevanceLevel = relevanceLevel;
            return this;
        }

        @Override
        public final Builder relevanceLevel(RelevanceLevel relevanceLevel) {
            this.relevanceLevel(relevanceLevel == null ? null : relevanceLevel.toString());
            return this;
        }

        public final Double getRelevanceScore() {
            return this.relevanceScore;
        }

        public final void setRelevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Double relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public RecommendationData build() {
            return new RecommendationData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationData> {
        public Builder data(DataSummary var1);

        default public Builder data(Consumer<DataSummary.Builder> data) {
            return this.data((DataSummary)((DataSummary.Builder)DataSummary.builder().applyMutation(data)).build());
        }

        public Builder document(Document var1);

        default public Builder document(Consumer<Document.Builder> document) {
            return this.document((Document)((Document.Builder)Document.builder().applyMutation(document)).build());
        }

        public Builder recommendationId(String var1);

        public Builder relevanceLevel(String var1);

        public Builder relevanceLevel(RelevanceLevel var1);

        public Builder relevanceScore(Double var1);

        public Builder type(String var1);

        public Builder type(RecommendationType var1);
    }
}

