/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecommendationSourceType {
    ISSUE_DETECTION("ISSUE_DETECTION"),
    RULE_EVALUATION("RULE_EVALUATION"),
    OTHER("OTHER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecommendationSourceType> VALUE_MAP;
    private final String value;

    private RecommendationSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecommendationSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecommendationSourceType> knownValues() {
        EnumSet<RecommendationSourceType> knownValues = EnumSet.allOf(RecommendationSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecommendationSourceType.class, RecommendationSourceType::toString);
    }
}

