/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachment;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttachmentListCopier;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateAttributeKeyListCopier;
import software.amazon.awssdk.services.qconnect.model.MessageTemplateContentProvider;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenderMessageTemplateResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, RenderMessageTemplateResponse> {
    private static final SdkField<List<MessageTemplateAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(RenderMessageTemplateResponse.getter(RenderMessageTemplateResponse::attachments)).setter(RenderMessageTemplateResponse.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageTemplateAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_NOT_INTERPOLATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributesNotInterpolated").getter(RenderMessageTemplateResponse.getter(RenderMessageTemplateResponse::attributesNotInterpolated)).setter(RenderMessageTemplateResponse.setter(Builder::attributesNotInterpolated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributesNotInterpolated").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MessageTemplateContentProvider> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(RenderMessageTemplateResponse.getter(RenderMessageTemplateResponse::content)).setter(RenderMessageTemplateResponse.setter(Builder::content)).constructor(MessageTemplateContentProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD, ATTRIBUTES_NOT_INTERPOLATED_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("attachments", ATTACHMENTS_FIELD);
            this.put("attributesNotInterpolated", ATTRIBUTES_NOT_INTERPOLATED_FIELD);
            this.put("content", CONTENT_FIELD);
        }
    });
    private final List<MessageTemplateAttachment> attachments;
    private final List<String> attributesNotInterpolated;
    private final MessageTemplateContentProvider content;

    private RenderMessageTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.attachments = builder.attachments;
        this.attributesNotInterpolated = builder.attributesNotInterpolated;
        this.content = builder.content;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<MessageTemplateAttachment> attachments() {
        return this.attachments;
    }

    public final boolean hasAttributesNotInterpolated() {
        return this.attributesNotInterpolated != null && !(this.attributesNotInterpolated instanceof SdkAutoConstructList);
    }

    public final List<String> attributesNotInterpolated() {
        return this.attributesNotInterpolated;
    }

    public final MessageTemplateContentProvider content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesNotInterpolated() ? this.attributesNotInterpolated() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenderMessageTemplateResponse)) {
            return false;
        }
        RenderMessageTemplateResponse other = (RenderMessageTemplateResponse)((Object)obj);
        return this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && this.hasAttributesNotInterpolated() == other.hasAttributesNotInterpolated() && Objects.equals(this.attributesNotInterpolated(), other.attributesNotInterpolated()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"RenderMessageTemplateResponse").add("Attachments", this.hasAttachments() ? this.attachments() : null).add("AttributesNotInterpolated", (Object)(this.attributesNotInterpolated() == null ? null : "*** Sensitive Data Redacted ***")).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "attributesNotInterpolated": {
                return Optional.ofNullable(clazz.cast(this.attributesNotInterpolated()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RenderMessageTemplateResponse, T> g) {
        return obj -> g.apply((RenderMessageTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<MessageTemplateAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private List<String> attributesNotInterpolated = DefaultSdkAutoConstructList.getInstance();
        private MessageTemplateContentProvider content;

        private BuilderImpl() {
        }

        private BuilderImpl(RenderMessageTemplateResponse model) {
            super(model);
            this.attachments(model.attachments);
            this.attributesNotInterpolated(model.attributesNotInterpolated);
            this.content(model.content);
        }

        public final List<MessageTemplateAttachment.Builder> getAttachments() {
            List<MessageTemplateAttachment.Builder> result = MessageTemplateAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<MessageTemplateAttachment.BuilderImpl> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<MessageTemplateAttachment> attachments) {
            this.attachments = MessageTemplateAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(MessageTemplateAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<MessageTemplateAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (MessageTemplateAttachment)((MessageTemplateAttachment.Builder)MessageTemplateAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAttributesNotInterpolated() {
            if (this.attributesNotInterpolated instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesNotInterpolated;
        }

        public final void setAttributesNotInterpolated(Collection<String> attributesNotInterpolated) {
            this.attributesNotInterpolated = MessageTemplateAttributeKeyListCopier.copy(attributesNotInterpolated);
        }

        @Override
        public final Builder attributesNotInterpolated(Collection<String> attributesNotInterpolated) {
            this.attributesNotInterpolated = MessageTemplateAttributeKeyListCopier.copy(attributesNotInterpolated);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesNotInterpolated(String ... attributesNotInterpolated) {
            this.attributesNotInterpolated(Arrays.asList(attributesNotInterpolated));
            return this;
        }

        public final MessageTemplateContentProvider.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(MessageTemplateContentProvider.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(MessageTemplateContentProvider content) {
            this.content = content;
            return this;
        }

        @Override
        public RenderMessageTemplateResponse build() {
            return new RenderMessageTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RenderMessageTemplateResponse> {
        public Builder attachments(Collection<MessageTemplateAttachment> var1);

        public Builder attachments(MessageTemplateAttachment ... var1);

        public Builder attachments(Consumer<MessageTemplateAttachment.Builder> ... var1);

        public Builder attributesNotInterpolated(Collection<String> var1);

        public Builder attributesNotInterpolated(String ... var1);

        public Builder content(MessageTemplateContentProvider var1);

        default public Builder content(Consumer<MessageTemplateContentProvider.Builder> content) {
            return this.content((MessageTemplateContentProvider)((MessageTemplateContentProvider.Builder)MessageTemplateContentProvider.builder().applyMutation(content)).build());
        }
    }
}

