/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ContentSummary;
import software.amazon.awssdk.services.qconnect.model.ContentSummaryListCopier;
import software.amazon.awssdk.services.qconnect.model.QConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchContentResponse
extends QConnectResponse
implements ToCopyableBuilder<Builder, SearchContentResponse> {
    private static final SdkField<List<ContentSummary>> CONTENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contentSummaries").getter(SearchContentResponse.getter(SearchContentResponse::contentSummaries)).setter(SearchContentResponse.setter(Builder::contentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchContentResponse.getter(SearchContentResponse::nextToken)).setter(SearchContentResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("contentSummaries", CONTENT_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ContentSummary> contentSummaries;
    private final String nextToken;

    private SearchContentResponse(BuilderImpl builder) {
        super(builder);
        this.contentSummaries = builder.contentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContentSummaries() {
        return this.contentSummaries != null && !(this.contentSummaries instanceof SdkAutoConstructList);
    }

    public final List<ContentSummary> contentSummaries() {
        return this.contentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentSummaries() ? this.contentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContentResponse)) {
            return false;
        }
        SearchContentResponse other = (SearchContentResponse)((Object)obj);
        return this.hasContentSummaries() == other.hasContentSummaries() && Objects.equals(this.contentSummaries(), other.contentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchContentResponse").add("ContentSummaries", this.hasContentSummaries() ? this.contentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentSummaries": {
                return Optional.ofNullable(clazz.cast(this.contentSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchContentResponse, T> g) {
        return obj -> g.apply((SearchContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectResponse.BuilderImpl
    implements Builder {
        private List<ContentSummary> contentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContentResponse model) {
            super(model);
            this.contentSummaries(model.contentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ContentSummary.Builder> getContentSummaries() {
            List<ContentSummary.Builder> result = ContentSummaryListCopier.copyToBuilder(this.contentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentSummaries(Collection<ContentSummary.BuilderImpl> contentSummaries) {
            this.contentSummaries = ContentSummaryListCopier.copyFromBuilder(contentSummaries);
        }

        @Override
        public final Builder contentSummaries(Collection<ContentSummary> contentSummaries) {
            this.contentSummaries = ContentSummaryListCopier.copy(contentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentSummaries(ContentSummary ... contentSummaries) {
            this.contentSummaries(Arrays.asList(contentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentSummaries(Consumer<ContentSummary.Builder> ... contentSummaries) {
            this.contentSummaries(Stream.of(contentSummaries).map(c -> (ContentSummary)((ContentSummary.Builder)ContentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchContentResponse build() {
            return new SearchContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchContentResponse> {
        public Builder contentSummaries(Collection<ContentSummary> var1);

        public Builder contentSummaries(ContentSummary ... var1);

        public Builder contentSummaries(Consumer<ContentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

