/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse;
import software.amazon.awssdk.services.rds.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.rds.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateIntegrationRequest;
import software.amazon.awssdk.services.rds.model.CreateIntegrationResponse;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateTenantDatabaseRequest;
import software.amazon.awssdk.services.rds.model.CreateTenantDatabaseResponse;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.rds.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteTenantDatabaseRequest;
import software.amazon.awssdk.services.rds.model.DeleteTenantDatabaseResponse;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbShardGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbShardGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.rds.model.DisableHttpEndpointRequest;
import software.amazon.awssdk.services.rds.model.DisableHttpEndpointResponse;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse;
import software.amazon.awssdk.services.rds.model.EnableHttpEndpointRequest;
import software.amazon.awssdk.services.rds.model.EnableHttpEndpointResponse;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbRecommendationRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbRecommendationResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyIntegrationRequest;
import software.amazon.awssdk.services.rds.model.ModifyIntegrationResponse;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyTenantDatabaseRequest;
import software.amazon.awssdk.services.rds.model.ModifyTenantDatabaseResponse;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse;
import software.amazon.awssdk.services.rds.model.RebootDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RebootDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RebootDbShardGroupRequest;
import software.amazon.awssdk.services.rds.model.RebootDbShardGroupResponse;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.StartActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StartActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StartDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StartDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StartExportTaskRequest;
import software.amazon.awssdk.services.rds.model.StartExportTaskResponse;
import software.amazon.awssdk.services.rds.model.StopActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StopActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StopDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StopDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse;
import software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterAutomatedBackupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBParametersPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBRecommendationsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotTenantDatabasesPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeExportTasksPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeIntegrationsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsPublisher;
import software.amazon.awssdk.services.rds.paginators.DescribeTenantDatabasesPublisher;
import software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionPublisher;
import software.amazon.awssdk.services.rds.waiters.RdsAsyncWaiter;

/**
 * Service client for accessing Amazon RDS asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon Relational Database Service</fullname>
 * <p/>
 * <p>
 * Amazon Relational Database Service (Amazon RDS) is a web service that makes it easier to set up, operate, and scale a
 * relational database in the cloud. It provides cost-efficient, resizeable capacity for an industry-standard relational
 * database and manages common database administration tasks, freeing up developers to focus on what makes their
 * applications and businesses unique.
 * </p>
 * <p>
 * Amazon RDS gives you access to the capabilities of a MySQL, MariaDB, PostgreSQL, Microsoft SQL Server, Oracle, Db2,
 * or Amazon Aurora database server. These capabilities mean that the code, applications, and tools you already use
 * today with your existing databases work with Amazon RDS without modification. Amazon RDS automatically backs up your
 * database and maintains the database software that powers your DB instance. Amazon RDS is flexible: you can scale your
 * DB instance's compute resources and storage capacity to meet your application's demand. As with all Amazon Web
 * Services, there are no up-front investments, and you pay only for the resources you use.
 * </p>
 * <p>
 * This interface reference for Amazon RDS contains documentation for a programming or command line interface you can
 * use to manage Amazon RDS. Amazon RDS is asynchronous, which means that some interfaces might require techniques such
 * as polling or callback functions to determine when a command has been applied. In this reference, the parameter
 * descriptions indicate whether a command is applied immediately, on the next instance reboot, or during the
 * maintenance window. The reference structure is as follows, and we list following some related topics from the user
 * guide.
 * </p>
 * <p>
 * <b>Amazon RDS API Reference</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For the alphabetical list of API actions, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Operations.html">API Actions</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For the alphabetical list of data types, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Types.html">Data Types</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For a list of common query parameters, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonParameters.html">Common Parameters</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of the error codes, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonErrors.html">Common Errors</a>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Amazon RDS User Guide</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For a summary of the Amazon RDS interfaces, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces">Available RDS
 * Interfaces</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For more information about how to use the Query API, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Using_the_Query_API.html">Using the Query API</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RdsAsyncClient extends AwsClient {
    String SERVICE_NAME = "rds";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rds";

    /**
     * Creates an instance of {@link RdsUtilities} object with the configuration set on this client.
     */
    default RdsUtilities utilities() {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRoleToDbClusterResponse> addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToDbClusterRequest.Builder} avoiding the
     * need to create one manually via {@link AddRoleToDbClusterRequest#builder()}
     * </p>
     *
     * @param addRoleToDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddRoleToDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterRoleAlreadyExistsException The specified IAM role Amazon Resource Name (ARN) is already
     *         associated with the specified DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterRoleQuotaExceededException You have exceeded the maximum number of IAM roles that can be
     *         associated with the specified DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRoleToDbClusterResponse> addRoleToDBCluster(
            Consumer<AddRoleToDbClusterRequest.Builder> addRoleToDbClusterRequest) {
        return addRoleToDBCluster(AddRoleToDbClusterRequest.builder().applyMutation(addRoleToDbClusterRequest).build());
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     * </p>
     * <note>
     * <p>
     * To add a role to a DB instance, the status of the DB instance must be <code>available</code>.
     * </p>
     * </note>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param addRoleToDbInstanceRequest
     * @return A Java Future containing the result of the AddRoleToDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceRoleAlreadyExistsException The specified <code>RoleArn</code> or <code>FeatureName</code>
     *         value is already associated with the DB instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceRoleQuotaExceededException You can't associate any more Amazon Web Services Identity and
     *         Access Management (IAM) roles with the DB instance because the quota has been reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddRoleToDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRoleToDbInstanceResponse> addRoleToDBInstance(
            AddRoleToDbInstanceRequest addRoleToDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     * </p>
     * <note>
     * <p>
     * To add a role to a DB instance, the status of the DB instance must be <code>available</code>.
     * </p>
     * </note>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToDbInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link AddRoleToDbInstanceRequest#builder()}
     * </p>
     *
     * @param addRoleToDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddRoleToDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceRoleAlreadyExistsException The specified <code>RoleArn</code> or <code>FeatureName</code>
     *         value is already associated with the DB instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceRoleQuotaExceededException You can't associate any more Amazon Web Services Identity and
     *         Access Management (IAM) roles with the DB instance because the quota has been reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddRoleToDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddRoleToDbInstanceResponse> addRoleToDBInstance(
            Consumer<AddRoleToDbInstanceRequest.Builder> addRoleToDbInstanceRequest) {
        return addRoleToDBInstance(AddRoleToDbInstanceRequest.builder().applyMutation(addRoleToDbInstanceRequest).build());
    }

    /**
     * <p>
     * Adds a source identifier to an existing RDS event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a source identifier to an existing RDS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddSourceIdentifierToSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link AddSourceIdentifierToSubscriptionRequest#builder()}
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AddSourceIdentifierToSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddSourceIdentifierToSubscriptionResponse> addSourceIdentifierToSubscription(
            Consumer<AddSourceIdentifierToSubscriptionRequest.Builder> addSourceIdentifierToSubscriptionRequest) {
        return addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.builder()
                .applyMutation(addSourceIdentifierToSubscriptionRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track
     * cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * </p>
     * <p>
     * For an overview on tagging your relational database resources, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a>
     * or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora
     * and Amazon RDS Resources</a>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>TenantDatabaseNotFoundException The specified tenant database wasn't found in the DB instance.</li>
     *         <li>DbSnapshotTenantDatabaseNotFoundException The specified snapshot tenant database wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track
     * cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * </p>
     * <p>
     * For an overview on tagging your relational database resources, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a>
     * or <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html">Tagging Amazon Aurora
     * and Amazon RDS Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>TenantDatabaseNotFoundException The specified tenant database wasn't found in the DB instance.</li>
     *         <li>DbSnapshotTenantDatabaseNotFoundException The specified snapshot tenant database wasn't found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest) {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups
     * can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances.
     * Second, IP ranges are available if the application accessing your database is running on the internet. Required
     * parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
     * EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     * </p>
     * <p>
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB
     * instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB
     * instance in another.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param authorizeDbSecurityGroupIngressRequest
     * @return A Java Future containing the result of the AuthorizeDBSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR IP range or Amazon EC2 security group is
     *         already authorized for the specified DB security group.</li>
     *         <li>AuthorizationQuotaExceededException The DB security group authorization quota has been reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AuthorizeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeDbSecurityGroupIngressResponse> authorizeDBSecurityGroupIngress(
            AuthorizeDbSecurityGroupIngressRequest authorizeDbSecurityGroupIngressRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups
     * can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances.
     * Second, IP ranges are available if the application accessing your database is running on the internet. Required
     * parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
     * EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     * </p>
     * <p>
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB
     * instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB
     * instance in another.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeDbSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeDbSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeDbSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AuthorizeDBSecurityGroupIngress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>AuthorizationAlreadyExistsException The specified CIDR IP range or Amazon EC2 security group is
     *         already authorized for the specified DB security group.</li>
     *         <li>AuthorizationQuotaExceededException The DB security group authorization quota has been reached.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.AuthorizeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AuthorizeDbSecurityGroupIngressResponse> authorizeDBSecurityGroupIngress(
            Consumer<AuthorizeDbSecurityGroupIngressRequest.Builder> authorizeDbSecurityGroupIngressRequest) {
        return authorizeDBSecurityGroupIngress(AuthorizeDbSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeDbSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * </p>
     * <p>
     * For more information on backtracking, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param backtrackDbClusterRequest
     * @return A Java Future containing the result of the BacktrackDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.BacktrackDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BacktrackDbClusterResponse> backtrackDBCluster(BacktrackDbClusterRequest backtrackDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * </p>
     * <p>
     * For more information on backtracking, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora MySQL DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BacktrackDbClusterRequest.Builder} avoiding the
     * need to create one manually via {@link BacktrackDbClusterRequest#builder()}
     * </p>
     *
     * @param backtrackDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BacktrackDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.BacktrackDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BacktrackDbClusterResponse> backtrackDBCluster(
            Consumer<BacktrackDbClusterRequest.Builder> backtrackDbClusterRequest) {
        return backtrackDBCluster(BacktrackDbClusterRequest.builder().applyMutation(backtrackDbClusterRequest).build());
    }

    /**
     * <p>
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has
     * already been written to the S3 bucket isn't removed.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>InvalidExportTaskStateException You can't cancel an export task that has completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportTaskResponse> cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has
     * already been written to the S3 bucket isn't removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportTaskRequest#builder()}
     * </p>
     *
     * @param cancelExportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CancelExportTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelExportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>InvalidExportTaskStateException You can't cancel an export task that has completed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelExportTaskResponse> cancelExportTask(
            Consumer<CancelExportTaskRequest.Builder> cancelExportTaskRequest) {
        return cancelExportTask(CancelExportTaskRequest.builder().applyMutation(cancelExportTaskRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     * <note>
     * <p>
     * You can't copy a default DB cluster parameter group. Instead, create a new custom DB cluster parameter group,
     * which copies the default parameters and values for the specified DB cluster parameter group family.
     * </p>
     * </note>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     * <note>
     * <p>
     * You can't copy a default DB cluster parameter group. Instead, create a new custom DB cluster parameter group,
     * which copies the default parameters and values for the specified DB cluster parameter group family.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CopyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyDBClusterParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CopyDbClusterParameterGroupResponse> copyDBClusterParameterGroup(
            Consumer<CopyDbClusterParameterGroupRequest.Builder> copyDbClusterParameterGroupRequest) {
        return copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest.builder()
                .applyMutation(copyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon
     * Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web
     * Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
     * from another Amazon Web Services Region, you must provide the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
     * for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is
     * the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <p>
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region
     * to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon
     * Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web
     * Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
     * from another Amazon Web Services Region, you must provide the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
     * for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is
     * the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <p>
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region
     * to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CopyDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyDbClusterSnapshotResponse> copyDBClusterSnapshot(
            Consumer<CopyDbClusterSnapshotRequest.Builder> copyDbClusterSnapshotRequest) {
        return copyDBClusterSnapshot(CopyDbClusterSnapshotRequest.builder().applyMutation(copyDbClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     * <note>
     * <p>
     * You can't copy a default DB parameter group. Instead, create a new custom DB parameter group, which copies the
     * default parameters and values for the specified DB parameter group family.
     * </p>
     * </note>
     *
     * @param copyDbParameterGroupRequest
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            CopyDbParameterGroupRequest copyDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     * <note>
     * <p>
     * You can't copy a default DB parameter group. Instead, create a new custom DB parameter group, which copies the
     * default parameters and values for the specified DB parameter group family.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopyDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyDbParameterGroupResponse> copyDBParameterGroup(
            Consumer<CopyDbParameterGroupRequest.Builder> copyDbParameterGroupRequest) {
        return copyDBParameterGroup(CopyDbParameterGroupRequest.builder().applyMutation(copyDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.
     * </p>
     * <p>
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services
     * Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for
     * the DB snapshot copy.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information about copying snapshots, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying
     * a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbSnapshotRequest
     * @return A Java Future containing the result of the CopyDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>CustomAvailabilityZoneNotFoundException <code>CustomAvailabilityZoneId</code> doesn't refer to an
     *         existing custom Availability Zone identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyDbSnapshotResponse> copyDBSnapshot(CopyDbSnapshotRequest copyDbSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.
     * </p>
     * <p>
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services
     * Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for
     * the DB snapshot copy.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information about copying snapshots, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying
     * a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopyDbSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopyDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>CustomAvailabilityZoneNotFoundException <code>CustomAvailabilityZoneId</code> doesn't refer to an
     *         existing custom Availability Zone identifier.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyDbSnapshotResponse> copyDBSnapshot(Consumer<CopyDbSnapshotRequest.Builder> copyDbSnapshotRequest) {
        return copyDBSnapshot(CopyDbSnapshotRequest.builder().applyMutation(copyDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Copies the specified option group.
     * </p>
     *
     * @param copyOptionGroupRequest
     * @return A Java Future containing the result of the CopyOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupAlreadyExistsException The option group you are trying to create already exists.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>OptionGroupQuotaExceededException The quota of 20 option groups was exceeded for this Amazon Web
     *         Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyOptionGroupResponse> copyOptionGroup(CopyOptionGroupRequest copyOptionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified option group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyOptionGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CopyOptionGroupRequest#builder()}
     * </p>
     *
     * @param copyOptionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CopyOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupAlreadyExistsException The option group you are trying to create already exists.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>OptionGroupQuotaExceededException The quota of 20 option groups was exceeded for this Amazon Web
     *         Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CopyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CopyOptionGroupResponse> copyOptionGroup(
            Consumer<CopyOptionGroupRequest.Builder> copyOptionGroupRequest) {
        return copyOptionGroup(CopyOptionGroupRequest.builder().applyMutation(copyOptionGroupRequest).build());
    }

    /**
     * <p>
     * Creates a blue/green deployment.
     * </p>
     * <p>
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green
     * deployment, the blue environment is the current production environment. The green environment is the staging
     * environment, and it stays in sync with the current production environment.
     * </p>
     * <p>
     * You can make changes to the databases in the green environment without affecting production workloads. For
     * example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes
     * in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch
     * over the environments to promote the green environment to be the new production environment. The switchover
     * typically takes under a minute.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createBlueGreenDeploymentRequest
     * @return A Java Future containing the result of the CreateBlueGreenDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SourceDatabaseNotSupportedException The source DB instance isn't supported for a blue/green
     *         deployment.</li>
     *         <li>SourceClusterNotSupportedException The source DB cluster isn't supported for a blue/green deployment.
     *         </li>
     *         <li>BlueGreenDeploymentAlreadyExistsException A blue/green deployment with the specified name already
     *         exists.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBlueGreenDeploymentResponse> createBlueGreenDeployment(
            CreateBlueGreenDeploymentRequest createBlueGreenDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a blue/green deployment.
     * </p>
     * <p>
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green
     * deployment, the blue environment is the current production environment. The green environment is the staging
     * environment, and it stays in sync with the current production environment.
     * </p>
     * <p>
     * You can make changes to the databases in the green environment without affecting production workloads. For
     * example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes
     * in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch
     * over the environments to promote the green environment to be the new production environment. The switchover
     * typically takes under a minute.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueGreenDeploymentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBlueGreenDeploymentRequest#builder()}
     * </p>
     *
     * @param createBlueGreenDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBlueGreenDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SourceDatabaseNotSupportedException The source DB instance isn't supported for a blue/green
     *         deployment.</li>
     *         <li>SourceClusterNotSupportedException The source DB cluster isn't supported for a blue/green deployment.
     *         </li>
     *         <li>BlueGreenDeploymentAlreadyExistsException A blue/green deployment with the specified name already
     *         exists.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBlueGreenDeploymentResponse> createBlueGreenDeployment(
            Consumer<CreateBlueGreenDeploymentRequest.Builder> createBlueGreenDeploymentRequest) {
        return createBlueGreenDeployment(CreateBlueGreenDeploymentRequest.builder()
                .applyMutation(createBlueGreenDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a custom DB engine version (CEV).
     * </p>
     *
     * @param createCustomDbEngineVersionRequest
     * @return A Java Future containing the result of the CreateCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CustomDbEngineVersionAlreadyExistsException A CEV with the specified name already exists.</li>
     *         <li>CustomDbEngineVersionQuotaExceededException You have exceeded your CEV quota.</li>
     *         <li>Ec2ImagePropertiesNotSupportedException The AMI configuration prerequisite has not been met.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>CreateCustomDbEngineVersionException An error occurred while trying to create the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDbEngineVersionResponse> createCustomDBEngineVersion(
            CreateCustomDbEngineVersionRequest createCustomDbEngineVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom DB engine version (CEV).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomDbEngineVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomDbEngineVersionRequest#builder()}
     * </p>
     *
     * @param createCustomDbEngineVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CustomDbEngineVersionAlreadyExistsException A CEV with the specified name already exists.</li>
     *         <li>CustomDbEngineVersionQuotaExceededException You have exceeded your CEV quota.</li>
     *         <li>Ec2ImagePropertiesNotSupportedException The AMI configuration prerequisite has not been met.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>CreateCustomDbEngineVersionException An error occurred while trying to create the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCustomDbEngineVersionResponse> createCustomDBEngineVersion(
            Consumer<CreateCustomDbEngineVersionRequest.Builder> createCustomDbEngineVersionRequest) {
        return createCustomDBEngineVersion(CreateCustomDbEngineVersionRequest.builder()
                .applyMutation(createCustomDbEngineVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * </p>
     * <p>
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer
     * instance for your DB cluster using the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a>
     * operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you,
     * each in a different Availability Zone.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a
     * read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about
     * Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read
     * replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB
     * clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterRequest
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbSubnetGroupException The DBSubnetGroup doesn't belong to the same VPC as that of an existing
     *         cross-region read replica of the same source instance.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbClusterResponse> createDBCluster(CreateDbClusterRequest createDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * </p>
     * <p>
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer
     * instance for your DB cluster using the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a>
     * operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you,
     * each in a different Availability Zone.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a
     * read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about
     * Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read
     * replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB
     * clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbClusterRequest#builder()}
     * </p>
     *
     * @param createDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterAlreadyExistsException The user already has a DB cluster with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>InsufficientStorageClusterCapacityException There is insufficient storage available for the current
     *         action. You might be able to resolve this error by updating your subnet group to use different
     *         Availability Zones that have more storage available.</li>
     *         <li>DbClusterQuotaExceededException The user attempted to create a new DB cluster and the user has
     *         already reached the maximum allowed DB cluster quota.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidDbSubnetGroupException The DBSubnetGroup doesn't belong to the same VPC as that of an existing
     *         cross-region read replica of the same source instance.</li>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbClusterParameterGroupNotFoundException <code>DBClusterParameterGroupName</code> doesn't refer to an
     *         existing DB cluster parameter group.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbClusterResponse> createDBCluster(
            Consumer<CreateDbClusterRequest.Builder> createDbClusterRequest) {
        return createDBCluster(CreateDbClusterRequest.builder().applyMutation(createDbClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createDbClusterEndpointRequest
     * @return A Java Future containing the result of the CreateDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterEndpointQuotaExceededException The cluster already has the maximum number of custom
     *         endpoints.</li>
     *         <li>DbClusterEndpointAlreadyExistsException The specified custom endpoint can't be created because it
     *         already exists.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterEndpointResponse> createDBClusterEndpoint(
            CreateDbClusterEndpointRequest createDbClusterEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param createDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterEndpointQuotaExceededException The cluster already has the maximum number of custom
     *         endpoints.</li>
     *         <li>DbClusterEndpointAlreadyExistsException The specified custom endpoint can't be created because it
     *         already exists.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterEndpointResponse> createDBClusterEndpoint(
            Consumer<CreateDbClusterEndpointRequest.Builder> createDbClusterEndpointRequest) {
        return createDBClusterEndpoint(CreateDbClusterEndpointRequest.builder().applyMutation(createDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group,
     * you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
     * the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster
     * without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the DB cluster parameter group is used as the default for a new DB cluster.
     * This is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code>
     * operation to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group,
     * you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
     * the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster
     * without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the DB cluster parameter group is used as the default for a new DB cluster.
     * This is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code>
     * operation to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterParameterGroupResponse> createDBClusterParameterGroup(
            Consumer<CreateDbClusterParameterGroupRequest.Builder> createDbClusterParameterGroupRequest) {
        return createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest.builder()
                .applyMutation(createDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbClusterSnapshotResponse> createDBClusterSnapshot(
            Consumer<CreateDbClusterSnapshotRequest.Builder> createDbClusterSnapshotRequest) {
        return createDBClusterSnapshot(CreateDbClusterSnapshotRequest.builder().applyMutation(createDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <p>
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora
     * DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     * </p>
     * <p>
     * For more information about creating an RDS DB instance, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS
     * DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a DB instance in an Aurora DB cluster, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an
     * Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>TenantDatabaseQuotaExceededException You attempted to create more tenant databases than are permitted
     *         in your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceResponse> createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <p>
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora
     * DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     * </p>
     * <p>
     * For more information about creating an RDS DB instance, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS
     * DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a DB instance in an Aurora DB cluster, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an
     * Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbInstanceRequest#builder()}
     * </p>
     *
     * @param createDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>AuthorizationNotFoundException The specified CIDR IP range or Amazon EC2 security group might not be
     *         authorized for the specified DB security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>TenantDatabaseQuotaExceededException You attempted to create more tenant databases than are permitted
     *         in your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceResponse> createDBInstance(
            Consumer<CreateDbInstanceRequest.Builder> createDbInstanceRequest) {
        return createDBInstance(CreateDbInstanceRequest.builder().applyMutation(createDbInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster.
     * You can create a read replica for a DB instance running Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server.
     * You can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a>
     * and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica"
     * >Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User
     * Guide</i>.
     * </p>
     * <p>
     * Amazon Aurora doesn't support this operation. To create a DB instance for an Aurora DB cluster, use the
     * <code>CreateDBInstance</code> operation.
     * </p>
     * <p>
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security
     * groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     * </p>
     * <important>
     * <p>
     * Your source DB instance or cluster must have backup retention enabled.
     * </p>
     * </important>
     *
     * @param createDbInstanceReadReplicaRequest
     * @return A Java Future containing the result of the CreateDBInstanceReadReplica operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbSubnetGroupNotAllowedException The DBSubnetGroup shouldn't be specified while creating read
     *         replicas that lie in the same region as the source instance.</li>
     *         <li>InvalidDbSubnetGroupException The DBSubnetGroup doesn't belong to the same VPC as that of an existing
     *         cross-region read replica of the same source instance.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>TenantDatabaseQuotaExceededException You attempted to create more tenant databases than are permitted
     *         in your Amazon Web Services account.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBInstanceReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceReadReplicaResponse> createDBInstanceReadReplica(
            CreateDbInstanceReadReplicaRequest createDbInstanceReadReplicaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster.
     * You can create a read replica for a DB instance running Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server.
     * You can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a>
     * and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica"
     * >Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User
     * Guide</i>.
     * </p>
     * <p>
     * Amazon Aurora doesn't support this operation. To create a DB instance for an Aurora DB cluster, use the
     * <code>CreateDBInstance</code> operation.
     * </p>
     * <p>
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security
     * groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     * </p>
     * <important>
     * <p>
     * Your source DB instance or cluster must have backup retention enabled.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceReadReplicaRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbInstanceReadReplicaRequest#builder()}
     * </p>
     *
     * @param createDbInstanceReadReplicaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBInstanceReadReplica operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAlreadyExistsException The user already has a DB instance with the given identifier.</li>
     *         <li>InsufficientDbInstanceCapacityException The specified DB instance class isn't available in the
     *         specified Availability Zone.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>InstanceQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB instances.</li>
     *         <li>StorageQuotaExceededException The request would result in the user exceeding the allowed amount of
     *         storage available across all DB instances.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>ProvisionedIopsNotAvailableInAzException Provisioned IOPS not available in the specified Availability
     *         Zone.</li>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>DbSubnetGroupNotAllowedException The DBSubnetGroup shouldn't be specified while creating read
     *         replicas that lie in the same region as the source instance.</li>
     *         <li>InvalidDbSubnetGroupException The DBSubnetGroup doesn't belong to the same VPC as that of an existing
     *         cross-region read replica of the same source instance.</li>
     *         <li>StorageTypeNotSupportedException The specified <code>StorageType</code> can't be associated with the
     *         DB instance.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>DomainNotFoundException <code>Domain</code> doesn't refer to an existing Active Directory domain.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>TenantDatabaseQuotaExceededException You attempted to create more tenant databases than are permitted
     *         in your Amazon Web Services account.</li>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBInstanceReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDbInstanceReadReplicaResponse> createDBInstanceReadReplica(
            Consumer<CreateDbInstanceReadReplicaRequest.Builder> createDbInstanceReadReplicaRequest) {
        return createDBInstanceReadReplica(CreateDbInstanceReadReplicaRequest.builder()
                .applyMutation(createDbInstanceReadReplicaRequest).build());
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to associate it with your
     * DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB
     * instance, you need to reboot the DB instance without failover for the new DB parameter group and associated
     * settings to take effect.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param createDbParameterGroupRequest
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            CreateDbParameterGroupRequest createDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to associate it with your
     * DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB
     * instance, you need to reboot the DB instance without failover for the new DB parameter group and associated
     * settings to take effect.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB parameter groups.</li>
     *         <li>DbParameterGroupAlreadyExistsException A DB parameter group with the same name exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDbParameterGroupResponse> createDBParameterGroup(
            Consumer<CreateDbParameterGroupRequest.Builder> createDbParameterGroupRequest) {
        return createDBParameterGroup(CreateDbParameterGroupRequest.builder().applyMutation(createDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB proxy.
     * </p>
     *
     * @param createDbProxyRequest
     * @return A Java Future containing the result of the CreateDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbProxyAlreadyExistsException The specified proxy name must be unique for all proxies owned by your
     *         Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyQuotaExceededException Your Amazon Web Services account already has the maximum number of
     *         proxies in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbProxyResponse> createDBProxy(CreateDbProxyRequest createDbProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbProxyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDbProxyRequest#builder()}
     * </p>
     *
     * @param createDbProxyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbProxyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbProxyAlreadyExistsException The specified proxy name must be unique for all proxies owned by your
     *         Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyQuotaExceededException Your Amazon Web Services account already has the maximum number of
     *         proxies in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbProxyResponse> createDBProxy(Consumer<CreateDbProxyRequest.Builder> createDbProxyRequest) {
        return createDBProxy(CreateDbProxyRequest.builder().applyMutation(createDbProxyRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You
     * can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy
     * endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     * </p>
     *
     * @param createDbProxyEndpointRequest
     * @return A Java Future containing the result of the CreateDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointAlreadyExistsException The specified DB proxy endpoint name must be unique for all DB
     *         proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointQuotaExceededException The DB proxy already has the maximum number of endpoints.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbProxyEndpointResponse> createDBProxyEndpoint(
            CreateDbProxyEndpointRequest createDbProxyEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You
     * can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy
     * endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbProxyEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbProxyEndpointRequest#builder()}
     * </p>
     *
     * @param createDbProxyEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointAlreadyExistsException The specified DB proxy endpoint name must be unique for all DB
     *         proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointQuotaExceededException The DB proxy already has the maximum number of endpoints.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbProxyEndpointResponse> createDBProxyEndpoint(
            Consumer<CreateDbProxyEndpointRequest.Builder> createDbProxyEndpointRequest) {
        return createDBProxyEndpoint(CreateDbProxyEndpointRequest.builder().applyMutation(createDbProxyEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new DB security group. DB security groups control access to a DB instance.
     * </p>
     * <p>
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param createDbSecurityGroupRequest
     * @return A Java Future containing the result of the CreateDBSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupAlreadyExistsException A DB security group with the name specified in
     *         <code>DBSecurityGroupName</code> already exists.</li>
     *         <li>DbSecurityGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB security groups.</li>
     *         <li>DbSecurityGroupNotSupportedException A DB security group isn't allowed for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbSecurityGroupResponse> createDBSecurityGroup(
            CreateDbSecurityGroupRequest createDbSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB security group. DB security groups control access to a DB instance.
     * </p>
     * <p>
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createDbSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDBSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupAlreadyExistsException A DB security group with the name specified in
     *         <code>DBSecurityGroupName</code> already exists.</li>
     *         <li>DbSecurityGroupQuotaExceededException The request would result in the user exceeding the allowed
     *         number of DB security groups.</li>
     *         <li>DbSecurityGroupNotSupportedException A DB security group isn't allowed for this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbSecurityGroupResponse> createDBSecurityGroup(
            Consumer<CreateDbSecurityGroupRequest.Builder> createDbSecurityGroupRequest) {
        return createDBSecurityGroup(CreateDbSecurityGroupRequest.builder().applyMutation(createDbSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a
     * DB shard group.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     *
     * @param createDbShardGroupRequest
     * @return A Java Future containing the result of the CreateDBShardGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbShardGroupAlreadyExistsException The specified DB shard group name must be unique in your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>MaxDbShardGroupLimitReachedException The maximum number of DB shard groups for your Amazon Web
     *         Services account in the specified Amazon Web Services Region has been reached.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>UnsupportedDbEngineVersionException The specified DB engine version isn't supported for Aurora
     *         Limitless Database.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbShardGroupResponse> createDBShardGroup(CreateDbShardGroupRequest createDbShardGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora Limitless Database to create a
     * DB shard group.
     * </p>
     * <p>
     * Valid for: Aurora DB clusters only
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbShardGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbShardGroupRequest#builder()}
     * </p>
     *
     * @param createDbShardGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbShardGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBShardGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbShardGroupAlreadyExistsException The specified DB shard group name must be unique in your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>MaxDbShardGroupLimitReachedException The maximum number of DB shard groups for your Amazon Web
     *         Services account in the specified Amazon Web Services Region has been reached.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>UnsupportedDbEngineVersionException The specified DB engine version isn't supported for Aurora
     *         Limitless Database.</li>
     *         <li>InvalidVpcNetworkStateException The DB subnet group doesn't cover all Availability Zones after it's
     *         created because of users' change.</li>
     *         <li>NetworkTypeNotSupportedException The network type is invalid for the DB instance. Valid nework type
     *         values are <code>IPV4</code> and <code>DUAL</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbShardGroupResponse> createDBShardGroup(
            Consumer<CreateDbShardGroupRequest.Builder> createDbShardGroupRequest) {
        return createDBShardGroup(CreateDbShardGroupRequest.builder().applyMutation(createDbShardGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
     * <code>storage-optimization</code> state.
     * </p>
     *
     * @param createDbSnapshotRequest
     * @return A Java Future containing the result of the CreateDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbSnapshotResponse> createDBSnapshot(CreateDbSnapshotRequest createDbSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
     * <code>storage-optimization</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbSnapshotResponse> createDBSnapshot(
            Consumer<CreateDbSnapshotRequest.Builder> createDbSnapshotRequest) {
        return createDBSnapshot(CreateDbSnapshotRequest.builder().applyMutation(createDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Web Services Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <code>DBSubnetGroupName</code> is already used by an existing DB
     *         subnet group.</li>
     *         <li>DbSubnetGroupQuotaExceededException The request would result in the user exceeding the allowed number
     *         of DB subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException The request would result in the user exceeding the allowed number of
     *         subnets in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            CreateDbSubnetGroupRequest createDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupAlreadyExistsException <code>DBSubnetGroupName</code> is already used by an existing DB
     *         subnet group.</li>
     *         <li>DbSubnetGroupQuotaExceededException The request would result in the user exceeding the allowed number
     *         of DB subnet groups.</li>
     *         <li>DbSubnetQuotaExceededException The request would result in the user exceeding the allowed number of
     *         subnets in a DB subnet groups.</li>
     *         <li>DbSubnetGroupDoesNotCoverEnoughAZsException Subnets in the DB subnet group should cover at least two
     *         Availability Zones unless there is only one Availability Zone.</li>
     *         <li>InvalidSubnetException The requested subnet is invalid, or multiple subnets were requested that are
     *         not all in a common VPC.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDbSubnetGroupResponse> createDBSubnetGroup(
            Consumer<CreateDbSubnetGroupRequest.Builder> createDbSubnetGroupRequest) {
        return createDBSubnetGroup(CreateDbSubnetGroupRequest.builder().applyMutation(createDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN)
     * created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a
     * topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list
     * of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories
     * (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify
     * <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>,
     * <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.
     * </p>
     * <p>
     * If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> =
     * <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the
     * <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not
     * specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources.
     * If you don't specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated
     * from all RDS sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about subscribing to an event for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon
     * RDS event notification</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about subscribing to an event for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to
     * Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have reached the maximum number of event subscriptions.</li>
     *         <li>SubscriptionAlreadyExistException The supplied subscription name already exists.</li>
     *         <li>SnsInvalidTopicException SNS has responded that there is a problem with the SNS topic specified.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the SNS topic ARN.</li>
     *         <li>SnsTopicArnNotFoundException The SNS topic ARN does not exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The supplied category does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN)
     * created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a
     * topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list
     * of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories
     * (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify
     * <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>,
     * <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.
     * </p>
     * <p>
     * If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> =
     * <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the
     * <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not
     * specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources.
     * If you don't specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated
     * from all RDS sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about subscribing to an event for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon
     * RDS event notification</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about subscribing to an event for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to
     * Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EventSubscriptionQuotaExceededException You have reached the maximum number of event subscriptions.</li>
     *         <li>SubscriptionAlreadyExistException The supplied subscription name already exists.</li>
     *         <li>SnsInvalidTopicException SNS has responded that there is a problem with the SNS topic specified.</li>
     *         <li>SnsNoAuthorizationException You do not have permission to publish to the SNS topic ARN.</li>
     *         <li>SnsTopicArnNotFoundException The SNS topic ARN does not exist.</li>
     *         <li>SubscriptionCategoryNotFoundException The supplied category does not exist.</li>
     *         <li>SourceNotFoundException The requested source could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest) {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then create the primary and secondary DB clusters
     * in the global database. Or you can specify an existing Aurora cluster during the create operation, and this
     * cluster becomes the primary cluster of the global database.
     * </p>
     * <note>
     * <p>
     * This operation applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createGlobalClusterRequest
     * @return A Java Future containing the result of the CreateGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterAlreadyExistsException The <code>GlobalClusterIdentifier</code> already exists. Specify
     *         a new global database identifier (unique name) to create a new global database cluster or to rename an
     *         existing one.</li>
     *         <li>GlobalClusterQuotaExceededException The number of global database clusters for this account is
     *         already at the maximum allowed.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGlobalClusterResponse> createGlobalCluster(
            CreateGlobalClusterRequest createGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then create the primary and secondary DB clusters
     * in the global database. Or you can specify an existing Aurora cluster during the create operation, and this
     * cluster becomes the primary cluster of the global database.
     * </p>
     * <note>
     * <p>
     * This operation applies only to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalClusterRequest#builder()}
     * </p>
     *
     * @param createGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterAlreadyExistsException The <code>GlobalClusterIdentifier</code> already exists. Specify
     *         a new global database identifier (unique name) to create a new global database cluster or to rename an
     *         existing one.</li>
     *         <li>GlobalClusterQuotaExceededException The number of global database clusters for this account is
     *         already at the maximum allowed.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGlobalClusterResponse> createGlobalCluster(
            Consumer<CreateGlobalClusterRequest.Builder> createGlobalClusterRequest) {
        return createGlobalCluster(CreateGlobalClusterRequest.builder().applyMutation(createGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Creates a zero-ETL integration with Amazon Redshift.
     * </p>
     *
     * @param createIntegrationRequest
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>IntegrationAlreadyExistsException The integration you are trying to create already exists.</li>
     *         <li>IntegrationQuotaExceededException You can't crate any more zero-ETL integrations because the quota
     *         has been reached.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. Typically occurs when there are multiple requests being made to the same resource
     *         at the same time, and these requests conflict with each other.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIntegrationResponse> createIntegration(CreateIntegrationRequest createIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a zero-ETL integration with Amazon Redshift.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateIntegrationRequest#builder()}
     * </p>
     *
     * @param createIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateIntegrationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>IntegrationAlreadyExistsException The integration you are trying to create already exists.</li>
     *         <li>IntegrationQuotaExceededException You can't crate any more zero-ETL integrations because the quota
     *         has been reached.</li>
     *         <li>KmsKeyNotAccessibleException An error occurred accessing an Amazon Web Services KMS key.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. Typically occurs when there are multiple requests being made to the same resource
     *         at the same time, and these requests conflict with each other.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateIntegrationResponse> createIntegration(
            Consumer<CreateIntegrationRequest.Builder> createIntegrationRequest) {
        return createIntegration(CreateIntegrationRequest.builder().applyMutation(createIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates a new option group. You can create up to 20 option groups.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param createOptionGroupRequest
     * @return A Java Future containing the result of the CreateOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupAlreadyExistsException The option group you are trying to create already exists.</li>
     *         <li>OptionGroupQuotaExceededException The quota of 20 option groups was exceeded for this Amazon Web
     *         Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOptionGroupResponse> createOptionGroup(CreateOptionGroupRequest createOptionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new option group. You can create up to 20 option groups.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOptionGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOptionGroupRequest#builder()}
     * </p>
     *
     * @param createOptionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupAlreadyExistsException The option group you are trying to create already exists.</li>
     *         <li>OptionGroupQuotaExceededException The quota of 20 option groups was exceeded for this Amazon Web
     *         Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOptionGroupResponse> createOptionGroup(
            Consumer<CreateOptionGroupRequest.Builder> createOptionGroupRequest) {
        return createOptionGroup(CreateOptionGroupRequest.builder().applyMutation(createOptionGroupRequest).build());
    }

    /**
     * <p>
     * Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle
     * container database (CDB) instances are supported.
     * </p>
     *
     * @param createTenantDatabaseRequest
     * @return A Java Future containing the result of the CreateTenantDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>TenantDatabaseAlreadyExistsException You attempted to either create a tenant database that already
     *         exists or modify a tenant database to use the name of an existing tenant database.</li>
     *         <li>TenantDatabaseQuotaExceededException You attempted to create more tenant databases than are permitted
     *         in your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTenantDatabaseResponse> createTenantDatabase(
            CreateTenantDatabaseRequest createTenantDatabaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only RDS for Oracle
     * container database (CDB) instances are supported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTenantDatabaseRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTenantDatabaseRequest#builder()}
     * </p>
     *
     * @param createTenantDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.CreateTenantDatabaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTenantDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>TenantDatabaseAlreadyExistsException You attempted to either create a tenant database that already
     *         exists or modify a tenant database to use the name of an existing tenant database.</li>
     *         <li>TenantDatabaseQuotaExceededException You attempted to create more tenant databases than are permitted
     *         in your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.CreateTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTenantDatabaseResponse> createTenantDatabase(
            Consumer<CreateTenantDatabaseRequest.Builder> createTenantDatabaseRequest) {
        return createTenantDatabase(CreateTenantDatabaseRequest.builder().applyMutation(createTenantDatabaseRequest).build());
    }

    /**
     * <p>
     * Deletes a blue/green deployment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param deleteBlueGreenDeploymentRequest
     * @return A Java Future containing the result of the DeleteBlueGreenDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>InvalidBlueGreenDeploymentStateException The blue/green deployment can't be switched over or deleted
     *         because there is an invalid configuration in the green environment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBlueGreenDeploymentResponse> deleteBlueGreenDeployment(
            DeleteBlueGreenDeploymentRequest deleteBlueGreenDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a blue/green deployment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBlueGreenDeploymentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteBlueGreenDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteBlueGreenDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBlueGreenDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>InvalidBlueGreenDeploymentStateException The blue/green deployment can't be switched over or deleted
     *         because there is an invalid configuration in the green environment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBlueGreenDeploymentResponse> deleteBlueGreenDeployment(
            Consumer<DeleteBlueGreenDeploymentRequest.Builder> deleteBlueGreenDeploymentRequest) {
        return deleteBlueGreenDeployment(DeleteBlueGreenDeploymentRequest.builder()
                .applyMutation(deleteBlueGreenDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup
     * of your RDS Custom instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Typically, deletion takes a few minutes.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>DeleteCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a
     * CEV</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteCustomDbEngineVersionRequest
     * @return A Java Future containing the result of the DeleteCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CustomDbEngineVersionNotFoundException The specified CEV was not found.</li>
     *         <li>InvalidCustomDbEngineVersionStateException You can't delete the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDbEngineVersionResponse> deleteCustomDBEngineVersion(
            DeleteCustomDbEngineVersionRequest deleteCustomDbEngineVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup
     * of your RDS Custom instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Typically, deletion takes a few minutes.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>DeleteCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a
     * CEV</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomDbEngineVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomDbEngineVersionRequest#builder()}
     * </p>
     *
     * @param deleteCustomDbEngineVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCustomDBEngineVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CustomDbEngineVersionNotFoundException The specified CEV was not found.</li>
     *         <li>InvalidCustomDbEngineVersionStateException You can't delete the CEV.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCustomDbEngineVersionResponse> deleteCustomDBEngineVersion(
            Consumer<DeleteCustomDbEngineVersionRequest.Builder> deleteCustomDbEngineVersionRequest) {
        return deleteCustomDBEngineVersion(DeleteCustomDbEngineVersionRequest.builder()
                .applyMutation(deleteCustomDbEngineVersionRequest).build());
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas
     * are promoted to standalone instances.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterAutomatedBackupQuotaExceededException The quota for retained automated backups was exceeded.
     *         This prevents you from retaining any additional automated backups. The retained automated backups quota
     *         is the same as your DB cluster quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas
     * are promoted to standalone instances.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbClusterRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbClusterSnapshotAlreadyExistsException The user already has a DB cluster snapshot with the given
     *         identifier.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterAutomatedBackupQuotaExceededException The quota for retained automated backups was exceeded.
     *         This prevents you from retaining any additional automated backups. The retained automated backups quota
     *         is the same as your DB cluster quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterResponse> deleteDBCluster(
            Consumer<DeleteDbClusterRequest.Builder> deleteDbClusterRequest) {
        return deleteDBCluster(DeleteDbClusterRequest.builder().applyMutation(deleteDbClusterRequest).build());
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbClusterResourceId</code> value of the source DB cluster or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbClusterAutomatedBackupRequest
     * @return A Java Future containing the result of the DeleteDBClusterAutomatedBackup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbClusterAutomatedBackupStateException The automated backup is in an invalid state. For
     *         example, this automated backup is associated with an active cluster.</li>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterAutomatedBackupResponse> deleteDBClusterAutomatedBackup(
            DeleteDbClusterAutomatedBackupRequest deleteDbClusterAutomatedBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbClusterResourceId</code> value of the source DB cluster or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterAutomatedBackupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbClusterAutomatedBackupRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterAutomatedBackupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbClusterAutomatedBackupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteDBClusterAutomatedBackup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbClusterAutomatedBackupStateException The automated backup is in an invalid state. For
     *         example, this automated backup is associated with an active cluster.</li>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterAutomatedBackupResponse> deleteDBClusterAutomatedBackup(
            Consumer<DeleteDbClusterAutomatedBackupRequest.Builder> deleteDbClusterAutomatedBackupRequest) {
        return deleteDBClusterAutomatedBackup(DeleteDbClusterAutomatedBackupRequest.builder()
                .applyMutation(deleteDbClusterAutomatedBackupRequest).build());
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteDbClusterEndpointRequest
     * @return A Java Future containing the result of the DeleteDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbClusterEndpointStateException The requested operation can't be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterEndpointResponse> deleteDBClusterEndpoint(
            DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBClusterEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbClusterEndpointStateException The requested operation can't be performed on the endpoint
     *         while the endpoint is in this state.</li>
     *         <li>DbClusterEndpointNotFoundException The specified custom endpoint doesn't exist.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterEndpointResponse> deleteDBClusterEndpoint(
            Consumer<DeleteDbClusterEndpointRequest.Builder> deleteDbClusterEndpointRequest) {
        return deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest.builder().applyMutation(deleteDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBClusterParameterGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterParameterGroupResponse> deleteDBClusterParameterGroup(
            Consumer<DeleteDbClusterParameterGroupRequest.Builder> deleteDbClusterParameterGroupRequest) {
        return deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest.builder()
                .applyMutation(deleteDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBClusterSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbClusterSnapshotStateException The supplied value isn't a valid DB cluster snapshot state.</li>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbClusterSnapshotResponse> deleteDBClusterSnapshot(
            Consumer<DeleteDbClusterSnapshotRequest.Builder> deleteDbClusterSnapshotRequest) {
        return deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest.builder().applyMutation(deleteDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that
     * instance are deleted and can't be recovered. However, manual DB snapshots of the DB instance aren't deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot, the status of the Amazon RDS DB instance is <code>deleting</code> until the
     * DB snapshot is created. This operation can't be canceled or reverted after it begins. To monitor the status of
     * this operation, use <code>DescribeDBInstance</code>.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip
     * creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.
     * </p>
     * <p>
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of
     * the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first use the <code>PromoteReadReplicaDBCluster</code> operation to promote
     * the DB cluster so that it's no longer a read replica. After the promotion completes, use the
     * <code>DeleteDBInstance</code> operation to delete the final instance in the DB cluster.
     * </p>
     * <important>
     * <p>
     * For RDS Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the associated EBS
     * volumes. Make sure that you don't terminate or delete these resources before you delete the DB instance.
     * Otherwise, deleting the DB instance and creation of the final snapshot might fail.
     * </p>
     * </important>
     *
     * @param deleteDbInstanceRequest
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbInstanceAutomatedBackupQuotaExceededException The quota for retained automated backups was
     *         exceeded. This prevents you from retaining any additional automated backups. The retained automated
     *         backups quota is the same as your DB instance quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a previously provisioned DB instance. When you delete a DB instance, all automated backups for that
     * instance are deleted and can't be recovered. However, manual DB snapshots of the DB instance aren't deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot, the status of the Amazon RDS DB instance is <code>deleting</code> until the
     * DB snapshot is created. This operation can't be canceled or reverted after it begins. To monitor the status of
     * this operation, use <code>DescribeDBInstance</code>.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip
     * creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.
     * </p>
     * <p>
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of
     * the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first use the <code>PromoteReadReplicaDBCluster</code> operation to promote
     * the DB cluster so that it's no longer a read replica. After the promotion completes, use the
     * <code>DeleteDBInstance</code> operation to delete the final instance in the DB cluster.
     * </p>
     * <important>
     * <p>
     * For RDS Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the associated EBS
     * volumes. Make sure that you don't terminate or delete these resources before you delete the DB instance.
     * Otherwise, deleting the DB instance and creation of the final snapshot might fail.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbInstanceRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>DbSnapshotAlreadyExistsException <code>DBSnapshotIdentifier</code> is already used by an existing
     *         snapshot.</li>
     *         <li>SnapshotQuotaExceededException The request would result in the user exceeding the allowed number of
     *         DB snapshots.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>DbInstanceAutomatedBackupQuotaExceededException The quota for retained automated backups was
     *         exceeded. This prevents you from retaining any additional automated backups. The retained automated
     *         backups quota is the same as your DB instance quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceResponse> deleteDBInstance(
            Consumer<DeleteDbInstanceRequest.Builder> deleteDbInstanceRequest) {
        return deleteDBInstance(DeleteDbInstanceRequest.builder().applyMutation(deleteDbInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbInstanceAutomatedBackupRequest
     *        Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
     * @return A Java Future containing the result of the DeleteDBInstanceAutomatedBackup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbInstanceAutomatedBackupStateException The automated backup is in an invalid state. For
     *         example, this automated backup is associated with an active instance.</li>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBInstanceAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceAutomatedBackupResponse> deleteDBInstanceAutomatedBackup(
            DeleteDbInstanceAutomatedBackupRequest deleteDbInstanceAutomatedBackupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceAutomatedBackupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbInstanceAutomatedBackupRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceAutomatedBackupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest.Builder} to create
     *        a request. Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
     * @return A Java Future containing the result of the DeleteDBInstanceAutomatedBackup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbInstanceAutomatedBackupStateException The automated backup is in an invalid state. For
     *         example, this automated backup is associated with an active instance.</li>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBInstanceAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDbInstanceAutomatedBackupResponse> deleteDBInstanceAutomatedBackup(
            Consumer<DeleteDbInstanceAutomatedBackupRequest.Builder> deleteDbInstanceAutomatedBackupRequest) {
        return deleteDBInstanceAutomatedBackup(DeleteDbInstanceAutomatedBackupRequest.builder()
                .applyMutation(deleteDbInstanceAutomatedBackupRequest).build());
    }

    /**
     * <p>
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbParameterGroupResponse> deleteDBParameterGroup(
            DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
     * instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBParameterGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbParameterGroupStateException The DB parameter group is in use or is in an invalid state. If
     *         you are attempting to delete the parameter group, you can't delete it when the parameter group is in this
     *         state.</li>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDbParameterGroupResponse> deleteDBParameterGroup(
            Consumer<DeleteDbParameterGroupRequest.Builder> deleteDbParameterGroupRequest) {
        return deleteDBParameterGroup(DeleteDbParameterGroupRequest.builder().applyMutation(deleteDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing DB proxy.
     * </p>
     *
     * @param deleteDbProxyRequest
     * @return A Java Future containing the result of the DeleteDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbProxyResponse> deleteDBProxy(DeleteDbProxyRequest deleteDbProxyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing DB proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbProxyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDbProxyRequest#builder()}
     * </p>
     *
     * @param deleteDbProxyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBProxy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbProxyResponse> deleteDBProxy(Consumer<DeleteDbProxyRequest.Builder> deleteDbProxyRequest) {
        return deleteDBProxy(DeleteDbProxyRequest.builder().applyMutation(deleteDbProxyRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint
     * that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only
     * operations, or using a different VPC than the DB proxy's default VPC.
     * </p>
     *
     * @param deleteDbProxyEndpointRequest
     * @return A Java Future containing the result of the DeleteDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>InvalidDbProxyEndpointStateException You can't perform this operation while the DB proxy endpoint is
     *         in a particular state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbProxyEndpointResponse> deleteDBProxyEndpoint(
            DeleteDbProxyEndpointRequest deleteDbProxyEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint
     * that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only
     * operations, or using a different VPC than the DB proxy's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbProxyEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbProxyEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDbProxyEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBProxyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>InvalidDbProxyEndpointStateException You can't perform this operation while the DB proxy endpoint is
     *         in a particular state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbProxyEndpointResponse> deleteDBProxyEndpoint(
            Consumer<DeleteDbProxyEndpointRequest.Builder> deleteDbProxyEndpointRequest) {
        return deleteDBProxyEndpoint(DeleteDbProxyEndpointRequest.builder().applyMutation(deleteDbProxyEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a DB security group.
     * </p>
     * <p>
     * The specified DB security group must not be associated with any DB instances.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteDbSecurityGroupRequest
     * @return A Java Future containing the result of the DeleteDBSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbSecurityGroupResponse> deleteDBSecurityGroup(
            DeleteDbSecurityGroupRequest deleteDbSecurityGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB security group.
     * </p>
     * <p>
     * The specified DB security group must not be associated with any DB instances.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSecurityGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDBSecurityGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbSecurityGroupStateException The state of the DB security group doesn't allow deletion.</li>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbSecurityGroupResponse> deleteDBSecurityGroup(
            Consumer<DeleteDbSecurityGroupRequest.Builder> deleteDbSecurityGroupRequest) {
        return deleteDBSecurityGroup(DeleteDbSecurityGroupRequest.builder().applyMutation(deleteDbSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an Aurora Limitless Database DB shard group.
     * </p>
     *
     * @param deleteDbShardGroupRequest
     * @return A Java Future containing the result of the DeleteDBShardGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbShardGroupNotFoundException The specified DB shard group name wasn't found.</li>
     *         <li>InvalidDbShardGroupStateException The DB shard group must be in the available state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbShardGroupResponse> deleteDBShardGroup(DeleteDbShardGroupRequest deleteDbShardGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Aurora Limitless Database DB shard group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbShardGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbShardGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbShardGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbShardGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBShardGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbShardGroupNotFoundException The specified DB shard group name wasn't found.</li>
     *         <li>InvalidDbShardGroupStateException The DB shard group must be in the available state.</li>
     *         <li>InvalidDbClusterStateException The requested operation can't be performed while the cluster is in
     *         this state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBShardGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBShardGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbShardGroupResponse> deleteDBShardGroup(
            Consumer<DeleteDbShardGroupRequest.Builder> deleteDbShardGroupRequest) {
        return deleteDBShardGroup(DeleteDbShardGroupRequest.builder().applyMutation(deleteDbShardGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbSnapshotRequest
     * @return A Java Future containing the result of the DeleteDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbSnapshotResponse> deleteDBSnapshot(DeleteDbSnapshotRequest deleteDbSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbSnapshotStateException The state of the DB snapshot doesn't allow deletion.</li>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbSnapshotResponse> deleteDBSnapshot(
            Consumer<DeleteDbSnapshotRequest.Builder> deleteDbSnapshotRequest) {
        return deleteDBSnapshot(DeleteDbSnapshotRequest.builder().applyMutation(deleteDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet isn't in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(
            DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDBSubnetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidDbSubnetGroupStateException The DB subnet group cannot be deleted because it's in use.</li>
     *         <li>InvalidDbSubnetStateException The DB subnet isn't in the <i>available</i> state.</li>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDbSubnetGroupResponse> deleteDBSubnetGroup(
            Consumer<DeleteDbSubnetGroupRequest.Builder> deleteDbSubnetGroupRequest) {
        return deleteDBSubnetGroup(DeleteDbSubnetGroupRequest.builder().applyMutation(deleteDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an RDS event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>InvalidEventSubscriptionStateException This error can occur if someone else is modifying a
     *         subscription. You should retry the action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an RDS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>InvalidEventSubscriptionStateException This error can occur if someone else is modifying a
     *         subscription. You should retry the action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed
     * first.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteGlobalClusterRequest
     * @return A Java Future containing the result of the DeleteGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGlobalClusterResponse> deleteGlobalCluster(
            DeleteGlobalClusterRequest deleteGlobalClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed
     * first.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalClusterRequest#builder()}
     * </p>
     *
     * @param deleteGlobalClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGlobalCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>InvalidGlobalClusterStateException The global cluster is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGlobalClusterResponse> deleteGlobalCluster(
            Consumer<DeleteGlobalClusterRequest.Builder> deleteGlobalClusterRequest) {
        return deleteGlobalCluster(DeleteGlobalClusterRequest.builder().applyMutation(deleteGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a zero-ETL integration with Amazon Redshift.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. Typically occurs when there are multiple requests being made to the same resource
     *         at the same time, and these requests conflict with each other.</li>
     *         <li>InvalidIntegrationStateException The integration is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a zero-ETL integration with Amazon Redshift.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteIntegrationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>IntegrationConflictOperationException A conflicting conditional operation is currently in progress
     *         against this resource. Typically occurs when there are multiple requests being made to the same resource
     *         at the same time, and these requests conflict with each other.</li>
     *         <li>InvalidIntegrationStateException The integration is in an invalid state and can't perform the
     *         requested operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteIntegrationResponse> deleteIntegration(
            Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest) {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes an existing option group.
     * </p>
     *
     * @param deleteOptionGroupRequest
     * @return A Java Future containing the result of the DeleteOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>InvalidOptionGroupStateException The option group isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOptionGroupResponse> deleteOptionGroup(DeleteOptionGroupRequest deleteOptionGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing option group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptionGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOptionGroupRequest#builder()}
     * </p>
     *
     * @param deleteOptionGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOptionGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>InvalidOptionGroupStateException The option group isn't in the <i>available</i> state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOptionGroupResponse> deleteOptionGroup(
            Consumer<DeleteOptionGroupRequest.Builder> deleteOptionGroupRequest) {
        return deleteOptionGroup(DeleteOptionGroupRequest.builder().applyMutation(deleteOptionGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a tenant database from your DB instance. This command only applies to RDS for Oracle container database
     * (CDB) instances.
     * </p>
     * <p>
     * You can't delete a tenant database when it is the only tenant in the DB instance.
     * </p>
     *
     * @param deleteTenantDatabaseRequest
     * @return A Java Future containing the result of the DeleteTenantDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>TenantDatabaseNotFoundException The specified tenant database wasn't found in the DB instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTenantDatabaseResponse> deleteTenantDatabase(
            DeleteTenantDatabaseRequest deleteTenantDatabaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a tenant database from your DB instance. This command only applies to RDS for Oracle container database
     * (CDB) instances.
     * </p>
     * <p>
     * You can't delete a tenant database when it is the only tenant in the DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTenantDatabaseRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTenantDatabaseRequest#builder()}
     * </p>
     *
     * @param deleteTenantDatabaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeleteTenantDatabaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTenantDatabase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>TenantDatabaseNotFoundException The specified tenant database wasn't found in the DB instance.</li>
     *         <li>InvalidDbInstanceStateException The DB instance isn't in a valid state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeleteTenantDatabase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteTenantDatabase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTenantDatabaseResponse> deleteTenantDatabase(
            Consumer<DeleteTenantDatabaseRequest.Builder> deleteTenantDatabaseRequest) {
        return deleteTenantDatabase(DeleteTenantDatabaseRequest.builder().applyMutation(deleteTenantDatabaseRequest).build());
    }

    /**
     * <p>
     * Remove the association between one or more <code>DBProxyTarget</code> data structures and a
     * <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param deregisterDbProxyTargetsRequest
     * @return A Java Future containing the result of the DeregisterDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeregisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterDbProxyTargetsResponse> deregisterDBProxyTargets(
            DeregisterDbProxyTargetsRequest deregisterDbProxyTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove the association between one or more <code>DBProxyTarget</code> data structures and a
     * <code>DBProxyTargetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterDbProxyTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterDbProxyTargetsRequest#builder()}
     * </p>
     *
     * @param deregisterDbProxyTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DeregisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterDbProxyTargetsResponse> deregisterDBProxyTargets(
            Consumer<DeregisterDbProxyTargetsRequest.Builder> deregisterDbProxyTargetsRequest) {
        return deregisterDBProxyTargets(DeregisterDbProxyTargetsRequest.builder().applyMutation(deregisterDbProxyTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes() {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     * @return A Java Future containing the result of the DescribeBlueGreenDeployments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBlueGreenDeploymentsResponse> describeBlueGreenDeployments(
            DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBlueGreenDeploymentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBlueGreenDeploymentsRequest#builder()}
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeBlueGreenDeployments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeBlueGreenDeploymentsResponse> describeBlueGreenDeployments(
            Consumer<DescribeBlueGreenDeploymentsRequest.Builder> describeBlueGreenDeploymentsRequest) {
        return describeBlueGreenDeployments(DescribeBlueGreenDeploymentsRequest.builder()
                .applyMutation(describeBlueGreenDeploymentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsPublisher publisher = client.describeBlueGreenDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsPublisher publisher = client.describeBlueGreenDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBlueGreenDeploymentsPublisher describeBlueGreenDeploymentsPaginator(
            DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) {
        return new DescribeBlueGreenDeploymentsPublisher(this, describeBlueGreenDeploymentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsPublisher publisher = client.describeBlueGreenDeploymentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsPublisher publisher = client.describeBlueGreenDeploymentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBlueGreenDeploymentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBlueGreenDeploymentsRequest#builder()}
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BlueGreenDeploymentNotFoundException <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an
     *         existing blue/green deployment.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBlueGreenDeploymentsPublisher describeBlueGreenDeploymentsPaginator(
            Consumer<DescribeBlueGreenDeploymentsRequest.Builder> describeBlueGreenDeploymentsRequest) {
        return describeBlueGreenDeploymentsPaginator(DescribeBlueGreenDeploymentsRequest.builder()
                .applyMutation(describeBlueGreenDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            DescribeCertificatesRequest describeCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) {
        return describeCertificates(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this Amazon Web Services
     * account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificatesResponse> describeCertificates() {
        return describeCertificates(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesPublisher describeCertificatesPaginator() {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesPublisher describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest) {
        return new DescribeCertificatesPublisher(this, describeCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>CertificateNotFoundException <code>CertificateIdentifier</code> doesn't refer to an existing
     *         certificate.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesPublisher describeCertificatesPaginator(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted DB clusters. For example, use this operation to find details about
     * automated backups for previously deleted clusters. Current clusters are returned for both the
     * <code>DescribeDBClusterAutomatedBackups</code> and <code>DescribeDBClusters</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbClusterAutomatedBackupsRequest
     * @return A Java Future containing the result of the DescribeDBClusterAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterAutomatedBackupsResponse> describeDBClusterAutomatedBackups(
            DescribeDbClusterAutomatedBackupsRequest describeDbClusterAutomatedBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays backups for both current and deleted DB clusters. For example, use this operation to find details about
     * automated backups for previously deleted clusters. Current clusters are returned for both the
     * <code>DescribeDBClusterAutomatedBackups</code> and <code>DescribeDBClusters</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterAutomatedBackupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterAutomatedBackupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterAutomatedBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBClusterAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterAutomatedBackupsResponse> describeDBClusterAutomatedBackups(
            Consumer<DescribeDbClusterAutomatedBackupsRequest.Builder> describeDbClusterAutomatedBackupsRequest) {
        return describeDBClusterAutomatedBackups(DescribeDbClusterAutomatedBackupsRequest.builder()
                .applyMutation(describeDbClusterAutomatedBackupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterAutomatedBackupsPublisher publisher = client.describeDBClusterAutomatedBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterAutomatedBackupsPublisher publisher = client.describeDBClusterAutomatedBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterAutomatedBackupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterAutomatedBackupsPublisher describeDBClusterAutomatedBackupsPaginator(
            DescribeDbClusterAutomatedBackupsRequest describeDbClusterAutomatedBackupsRequest) {
        return new DescribeDBClusterAutomatedBackupsPublisher(this, describeDbClusterAutomatedBackupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterAutomatedBackupsPublisher publisher = client.describeDBClusterAutomatedBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterAutomatedBackupsPublisher publisher = client.describeDBClusterAutomatedBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterAutomatedBackupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterAutomatedBackupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterAutomatedBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterAutomatedBackupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterAutomatedBackupNotFoundException No automated backup for this DB cluster was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterAutomatedBackupsPublisher describeDBClusterAutomatedBackupsPaginator(
            Consumer<DescribeDbClusterAutomatedBackupsRequest.Builder> describeDbClusterAutomatedBackupsRequest) {
        return describeDBClusterAutomatedBackupsPaginator(DescribeDbClusterAutomatedBackupsRequest.builder()
                .applyMutation(describeDbClusterAutomatedBackupsRequest).build());
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterBacktracksRequest
     * @return A Java Future containing the result of the DescribeDBClusterBacktracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterBacktrackNotFoundException <code>BacktrackIdentifier</code> doesn't refer to an existing
     *         backtrack.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterBacktracksResponse> describeDBClusterBacktracks(
            DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterBacktracksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterBacktracksRequest#builder()}
     * </p>
     *
     * @param describeDbClusterBacktracksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusterBacktracks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterBacktrackNotFoundException <code>BacktrackIdentifier</code> doesn't refer to an existing
     *         backtrack.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterBacktracksResponse> describeDBClusterBacktracks(
            Consumer<DescribeDbClusterBacktracksRequest.Builder> describeDbClusterBacktracksRequest) {
        return describeDBClusterBacktracks(DescribeDbClusterBacktracksRequest.builder()
                .applyMutation(describeDbClusterBacktracksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksPublisher publisher = client.describeDBClusterBacktracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksPublisher publisher = client.describeDBClusterBacktracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterBacktracksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterBacktrackNotFoundException <code>BacktrackIdentifier</code> doesn't refer to an existing
     *         backtrack.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterBacktracksPublisher describeDBClusterBacktracksPaginator(
            DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) {
        return new DescribeDBClusterBacktracksPublisher(this, describeDbClusterBacktracksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksPublisher publisher = client.describeDBClusterBacktracksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksPublisher publisher = client.describeDBClusterBacktracksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterBacktracksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterBacktracksRequest#builder()}
     * </p>
     *
     * @param describeDbClusterBacktracksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>DbClusterBacktrackNotFoundException <code>BacktrackIdentifier</code> doesn't refer to an existing
     *         backtrack.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterBacktracksPublisher describeDBClusterBacktracksPaginator(
            Consumer<DescribeDbClusterBacktracksRequest.Builder> describeDbClusterBacktracksRequest) {
        return describeDBClusterBacktracksPaginator(DescribeDbClusterBacktracksRequest.builder()
                .applyMutation(describeDbClusterBacktracksRequest).build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterEndpointsRequest
     * @return A Java Future containing the result of the DescribeDBClusterEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterEndpointsResponse> describeDBClusterEndpoints(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusterEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterEndpointsResponse> describeDBClusterEndpoints(
            Consumer<DescribeDbClusterEndpointsRequest.Builder> describeDbClusterEndpointsRequest) {
        return describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest.builder()
                .applyMutation(describeDbClusterEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDBClusterEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterEndpointsResponse> describeDBClusterEndpoints() {
        return describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsPublisher describeDBClusterEndpointsPaginator() {
        return describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsPublisher describeDBClusterEndpointsPaginator(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) {
        return new DescribeDBClusterEndpointsPublisher(this, describeDbClusterEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher publisher = client.describeDBClusterEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsPublisher describeDBClusterEndpointsPaginator(
            Consumer<DescribeDbClusterEndpointsRequest.Builder> describeDbClusterEndpointsRequest) {
        return describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest.builder()
                .applyMutation(describeDbClusterEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest) {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusterParameterGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParameterGroupsResponse> describeDBClusterParameterGroups() {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsPublisher describeDBClusterParameterGroupsPaginator() {
        return describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsPublisher describeDBClusterParameterGroupsPaginator(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) {
        return new DescribeDBClusterParameterGroupsPublisher(this, describeDbClusterParameterGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher publisher = client.describeDBClusterParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsPublisher describeDBClusterParameterGroupsPaginator(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest) {
        return describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusterParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterParametersResponse> describeDBClusterParameters(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest) {
        return describeDBClusterParameters(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParametersPublisher describeDBClusterParametersPaginator(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) {
        return new DescribeDBClusterParametersPublisher(this, describeDbClusterParametersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersPublisher publisher = client.describeDBClusterParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParametersPublisher describeDBClusterParametersPaginator(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest) {
        return describeDBClusterParametersPaginator(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
     * returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
     * values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or
     * restored by all Amazon Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to
     * make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API
     * action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
     * returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
     * values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or
     * restored by all Amazon Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to
     * make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API
     * action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotAttributesResponse> describeDBClusterSnapshotAttributes(
            Consumer<DescribeDbClusterSnapshotAttributesRequest.Builder> describeDbClusterSnapshotAttributesRequest) {
        return describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.builder()
                .applyMutation(describeDbClusterSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest) {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusterSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbClusterSnapshotsResponse> describeDBClusterSnapshots() {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsPublisher describeDBClusterSnapshotsPaginator() {
        return describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsPublisher describeDBClusterSnapshotsPaginator(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        return new DescribeDBClusterSnapshotsPublisher(this, describeDbClusterSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher publisher = client.describeDBClusterSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterSnapshotNotFoundException <code>DBClusterSnapshotIdentifier</code> doesn't refer to an
     *         existing DB cluster snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsPublisher describeDBClusterSnapshotsPaginator(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest) {
        return describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     *
     * @param describeDbClustersRequest
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) {
        return describeDBClusters(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbClustersResponse> describeDBClusters() {
        return describeDBClusters(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersPublisher describeDBClustersPaginator() {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeDbClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersPublisher describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest) {
        return new DescribeDBClustersPublisher(this, describeDbClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher publisher = client.describeDBClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersPublisher describeDBClustersPaginator(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Describes the properties of specific versions of DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the properties of specific versions of DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().applyMutation(describeDbEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the properties of specific versions of DB engines.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbEngineVersionsResponse> describeDBEngineVersions() {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator() {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) {
        return new DescribeDBEngineVersionsPublisher(this, describeDbEngineVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher publisher = client.describeDBEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsPublisher describeDBEngineVersionsPaginator(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder()
                .applyMutation(describeDbEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A Java Future containing the result of the DescribeDBInstanceAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> describeDBInstanceAutomatedBackups(
            DescribeDbInstanceAutomatedBackupsRequest describeDbInstanceAutomatedBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstanceAutomatedBackupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbInstanceAutomatedBackupsRequest#builder()}
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest.Builder} to
     *        create a request. Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A Java Future containing the result of the DescribeDBInstanceAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> describeDBInstanceAutomatedBackups(
            Consumer<DescribeDbInstanceAutomatedBackupsRequest.Builder> describeDbInstanceAutomatedBackupsRequest) {
        return describeDBInstanceAutomatedBackups(DescribeDbInstanceAutomatedBackupsRequest.builder()
                .applyMutation(describeDbInstanceAutomatedBackupsRequest).build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBInstanceAutomatedBackups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbInstanceAutomatedBackupsResponse> describeDBInstanceAutomatedBackups() {
        return describeDBInstanceAutomatedBackups(DescribeDbInstanceAutomatedBackupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher publisher = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher publisher = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBInstanceAutomatedBackupsPublisher describeDBInstanceAutomatedBackupsPaginator() {
        return describeDBInstanceAutomatedBackupsPaginator(DescribeDbInstanceAutomatedBackupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher publisher = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher publisher = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBInstanceAutomatedBackupsPublisher describeDBInstanceAutomatedBackupsPaginator(
            DescribeDbInstanceAutomatedBackupsRequest describeDbInstanceAutomatedBackupsRequest) {
        return new DescribeDBInstanceAutomatedBackupsPublisher(this, describeDbInstanceAutomatedBackupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher publisher = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher publisher = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstanceAutomatedBackupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbInstanceAutomatedBackupsRequest#builder()}
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest.Builder} to
     *        create a request. Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceAutomatedBackupNotFoundException No automated backup for this DB instance was found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBInstanceAutomatedBackupsPublisher describeDBInstanceAutomatedBackupsPaginator(
            Consumer<DescribeDbInstanceAutomatedBackupsRequest.Builder> describeDbInstanceAutomatedBackupsRequest) {
        return describeDBInstanceAutomatedBackupsPaginator(DescribeDbInstanceAutomatedBackupsRequest.builder()
                .applyMutation(describeDbInstanceAutomatedBackupsRequest).build());
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note>
     *
     * @param describeDbInstancesRequest
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            DescribeDbInstancesRequest describeDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return describeDBInstances(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest).build());
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbInstancesResponse> describeDBInstances() {
        return describeDBInstances(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator() {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation.</b>
     * </p>
     *
     * @param describeDbInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return new DescribeDBInstancesPublisher(this, describeDbInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher publisher = client.describeDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesPublisher describeDBInstancesPaginator(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeDbLogFilesRequest
     * @return A Java Future containing the result of the DescribeDBLogFiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceNotReadyException An attempt to download or examine log files didn't succeed because an
     *         Aurora Serverless v2 instance was paused.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbLogFilesResponse> describeDBLogFiles(DescribeDbLogFilesRequest describeDbLogFilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbLogFilesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbLogFilesRequest#builder()}
     * </p>
     *
     * @param describeDbLogFilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDBLogFiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceNotReadyException An attempt to download or examine log files didn't succeed because an
     *         Aurora Serverless v2 instance was paused.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbLogFilesResponse> describeDBLogFiles(
            Consumer<DescribeDbLogFilesRequest.Builder> describeDbLogFilesRequest) {
        return describeDBLogFiles(DescribeDbLogFilesRequest.builder().applyMutation(describeDbLogFilesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesPublisher publisher = client.describeDBLogFilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesPublisher publisher = client.describeDBLogFilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation.</b>
     * </p>
     *
     * @param describeDbLogFilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceNotReadyException An attempt to download or examine log files didn't succeed because an
     *         Aurora Serverless v2 instance was paused.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBLogFilesPublisher describeDBLogFilesPaginator(DescribeDbLogFilesRequest describeDbLogFilesRequest) {
        return new DescribeDBLogFilesPublisher(this, describeDbLogFilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesPublisher publisher = client.describeDBLogFilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesPublisher publisher = client.describeDBLogFilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbLogFilesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbLogFilesRequest#builder()}
     * </p>
     *
     * @param describeDbLogFilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbInstanceNotFoundException <code>DBInstanceIdentifier</code> doesn't refer to an existing DB
     *         instance.</li>
     *         <li>DbInstanceNotReadyException An attempt to download or examine log files didn't succeed because an
     *         Aurora Serverless v2 instance was paused.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBLogFilesPublisher describeDBLogFilesPaginator(
            Consumer<DescribeDbLogFilesRequest.Builder> describeDbLogFilesRequest) {
        return describeDBLogFilesPaginator(DescribeDbLogFilesRequest.builder().applyMutation(describeDbLogFilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest) {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBParameterGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbParameterGroupsResponse> describeDBParameterGroups() {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator() {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) {
        return new DescribeDBParameterGroupsPublisher(this, describeDbParameterGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher publisher = client.describeDBParameterGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParameterGroupsPublisher describeDBParameterGroupsPaginator(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest) {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            DescribeDbParametersRequest describeDbParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDBParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbParametersResponse> describeDBParameters(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) {
        return describeDBParameters(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBParametersPublisher describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest) {
        return new DescribeDBParametersPublisher(this, describeDbParametersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersPublisher publisher = client.describeDBParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbParameterGroupNotFoundException <code>DBParameterGroupName</code> doesn't refer to an existing DB
     *         parameter group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBParametersPublisher describeDBParametersPaginator(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) {
        return describeDBParametersPaginator(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     *
     * @param describeDbProxiesRequest
     * @return A Java Future containing the result of the DescribeDBProxies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbProxiesResponse> describeDBProxies(DescribeDbProxiesRequest describeDbProxiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxiesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDbProxiesRequest#builder()}
     * </p>
     *
     * @param describeDbProxiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDBProxies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbProxiesResponse> describeDBProxies(
            Consumer<DescribeDbProxiesRequest.Builder> describeDbProxiesRequest) {
        return describeDBProxies(DescribeDbProxiesRequest.builder().applyMutation(describeDbProxiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesPublisher publisher = client.describeDBProxiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesPublisher publisher = client.describeDBProxiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation.</b>
     * </p>
     *
     * @param describeDbProxiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBProxiesPublisher describeDBProxiesPaginator(DescribeDbProxiesRequest describeDbProxiesRequest) {
        return new DescribeDBProxiesPublisher(this, describeDbProxiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesPublisher publisher = client.describeDBProxiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesPublisher publisher = client.describeDBProxiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxiesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDbProxiesRequest#builder()}
     * </p>
     *
     * @param describeDbProxiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBProxiesPublisher describeDBProxiesPaginator(
            Consumer<DescribeDbProxiesRequest.Builder> describeDbProxiesRequest) {
        return describeDBProxiesPaginator(DescribeDbProxiesRequest.builder().applyMutation(describeDbProxiesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     * @return A Java Future containing the result of the DescribeDBProxyEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbProxyEndpointsResponse> describeDBProxyEndpoints(
            DescribeDbProxyEndpointsRequest describeDbProxyEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbProxyEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBProxyEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbProxyEndpointsResponse> describeDBProxyEndpoints(
            Consumer<DescribeDbProxyEndpointsRequest.Builder> describeDbProxyEndpointsRequest) {
        return describeDBProxyEndpoints(DescribeDbProxyEndpointsRequest.builder().applyMutation(describeDbProxyEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsPublisher publisher = client.describeDBProxyEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsPublisher publisher = client.describeDBProxyEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyEndpointsPublisher describeDBProxyEndpointsPaginator(
            DescribeDbProxyEndpointsRequest describeDbProxyEndpointsRequest) {
        return new DescribeDBProxyEndpointsPublisher(this, describeDbProxyEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsPublisher publisher = client.describeDBProxyEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsPublisher publisher = client.describeDBProxyEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbProxyEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyEndpointNotFoundException The DB proxy endpoint doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyEndpointsPublisher describeDBProxyEndpointsPaginator(
            Consumer<DescribeDbProxyEndpointsRequest.Builder> describeDbProxyEndpointsRequest) {
        return describeDBProxyEndpointsPaginator(DescribeDbProxyEndpointsRequest.builder()
                .applyMutation(describeDbProxyEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     * @return A Java Future containing the result of the DescribeDBProxyTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbProxyTargetGroupsResponse> describeDBProxyTargetGroups(
            DescribeDbProxyTargetGroupsRequest describeDbProxyTargetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbProxyTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBProxyTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbProxyTargetGroupsResponse> describeDBProxyTargetGroups(
            Consumer<DescribeDbProxyTargetGroupsRequest.Builder> describeDbProxyTargetGroupsRequest) {
        return describeDBProxyTargetGroups(DescribeDbProxyTargetGroupsRequest.builder()
                .applyMutation(describeDbProxyTargetGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsPublisher publisher = client.describeDBProxyTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsPublisher publisher = client.describeDBProxyTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBProxyTargetGroupsPublisher describeDBProxyTargetGroupsPaginator(
            DescribeDbProxyTargetGroupsRequest describeDbProxyTargetGroupsRequest) {
        return new DescribeDBProxyTargetGroupsPublisher(this, describeDbProxyTargetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsPublisher publisher = client.describeDBProxyTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsPublisher publisher = client.describeDBProxyTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbProxyTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBProxyTargetGroupsPublisher describeDBProxyTargetGroupsPaginator(
            Consumer<DescribeDbProxyTargetGroupsRequest.Builder> describeDbProxyTargetGroupsRequest) {
        return describeDBProxyTargetGroupsPaginator(DescribeDbProxyTargetGroupsRequest.builder()
                .applyMutation(describeDbProxyTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     * @return A Java Future containing the result of the DescribeDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbProxyTargetsResponse> describeDBProxyTargets(
            DescribeDbProxyTargetsRequest describeDbProxyTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbProxyTargetsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBProxyTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbProxyTargetsResponse> describeDBProxyTargets(
            Consumer<DescribeDbProxyTargetsRequest.Builder> describeDbProxyTargetsRequest) {
        return describeDBProxyTargets(DescribeDbProxyTargetsRequest.builder().applyMutation(describeDbProxyTargetsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsPublisher publisher = client.describeDBProxyTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsPublisher publisher = client.describeDBProxyTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyTargetsPublisher describeDBProxyTargetsPaginator(
            DescribeDbProxyTargetsRequest describeDbProxyTargetsRequest) {
        return new DescribeDBProxyTargetsPublisher(this, describeDbProxyTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsPublisher publisher = client.describeDBProxyTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsPublisher publisher = client.describeDBProxyTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbProxyTargetsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbProxyNotFoundException The specified proxy name doesn't correspond to a proxy owned by your Amazon
     *         Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetNotFoundException The specified RDS DB instance or Aurora DB cluster isn't available for
     *         a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>DbProxyTargetGroupNotFoundException The specified target group isn't available for a proxy owned by
     *         your Amazon Web Services account in the specified Amazon Web Services Region.</li>
     *         <li>InvalidDbProxyStateException The requested operation can't be performed while the proxy is in this
     *         state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyTargetsPublisher describeDBProxyTargetsPaginator(
            Consumer<DescribeDbProxyTargetsRequest.Builder> describeDbProxyTargetsRequest) {
        return describeDBProxyTargetsPaginator(DescribeDbProxyTargetsRequest.builder()
                .applyMutation(describeDbProxyTargetsRequest).build());
    }

    /**
     * <p>
     * Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.
     * </p>
     *
     * @param describeDbRecommendationsRequest
     * @return A Java Future containing the result of the DescribeDBRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbRecommendationsResponse> describeDBRecommendations(
            DescribeDbRecommendationsRequest describeDbRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the recommendations to resolve the issues for your DB instances, DB clusters, and DB parameter groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbRecommendationsRequest#builder()}
     * </p>
     *
     * @param describeDbRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbRecommendationsResponse> describeDBRecommendations(
            Consumer<DescribeDbRecommendationsRequest.Builder> describeDbRecommendationsRequest) {
        return describeDBRecommendations(DescribeDbRecommendationsRequest.builder()
                .applyMutation(describeDbRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBRecommendations(software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBRecommendationsPublisher publisher = client.describeDBRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBRecommendationsPublisher publisher = client.describeDBRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBRecommendations(software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBRecommendationsPublisher describeDBRecommendationsPaginator(
            DescribeDbRecommendationsRequest describeDbRecommendationsRequest) {
        return new DescribeDBRecommendationsPublisher(this, describeDbRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBRecommendations(software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBRecommendationsPublisher publisher = client.describeDBRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBRecommendationsPublisher publisher = client.describeDBRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBRecommendations(software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbRecommendationsRequest#builder()}
     * </p>
     *
     * @param describeDbRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbRecommendationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBRecommendationsPublisher describeDBRecommendationsPaginator(
            Consumer<DescribeDbRecommendationsRequest.Builder> describeDbRecommendationsRequest) {
        return describeDBRecommendationsPaginator(DescribeDbRecommendationsRequest.builder()
                .applyMutation(describeDbRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param describeDbSecurityGroupsRequest
     * @return A Java Future containing the result of the DescribeDBSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSecurityGroupsResponse> describeDBSecurityGroups(
            DescribeDbSecurityGroupsRequest describeDbSecurityGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSecurityGroupsResponse> describeDBSecurityGroups(
            Consumer<DescribeDbSecurityGroupsRequest.Builder> describeDbSecurityGroupsRequest) {
        return describeDBSecurityGroups(DescribeDbSecurityGroupsRequest.builder().applyMutation(describeDbSecurityGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeDBSecurityGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSecurityGroupsResponse> describeDBSecurityGroups() {
        return describeDBSecurityGroups(DescribeDbSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher publisher = client.describeDBSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher publisher = client.describeDBSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSecurityGroupsPublisher describeDBSecurityGroupsPaginator() {
        return describeDBSecurityGroupsPaginator(DescribeDbSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher publisher = client.describeDBSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher publisher = client.describeDBSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSecurityGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSecurityGroupsPublisher describeDBSecurityGroupsPaginator(
            DescribeDbSecurityGroupsRequest describeDbSecurityGroupsRequest) {
        return new DescribeDBSecurityGroupsPublisher(this, describeDbSecurityGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher publisher = client.describeDBSecurityGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher publisher = client.describeDBSecurityGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSecurityGroupNotFoundException <code>DBSecurityGroupName</code> doesn't refer to an existing DB
     *         security group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSecurityGroupsPublisher describeDBSecurityGroupsPaginator(
            Consumer<DescribeDbSecurityGroupsRequest.Builder> describeDbSecurityGroupsRequest) {
        return describeDBSecurityGroupsPaginator(DescribeDbSecurityGroupsRequest.builder()
                .applyMutation(describeDbSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Describes existing Aurora Limitless Database DB shard groups.
     * </p>
     *
     * @param describeDbShardGroupsRequest
     * @return A Java Future containing the result of the DescribeDBShardGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbShardGroupNotFoundException The specified DB shard group name wasn't found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBShardGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBShardGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbShardGroupsResponse> describeDBShardGroups(
            DescribeDbShardGroupsRequest describeDbShardGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing Aurora Limitless Database DB shard groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbShardGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbShardGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbShardGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbShardGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBShardGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbShardGroupNotFoundException The specified DB shard group name wasn't found.</li>
     *         <li>DbClusterNotFoundException <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBShardGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBShardGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbShardGroupsResponse> describeDBShardGroups(
            Consumer<DescribeDbShardGroupsRequest.Builder> describeDbShardGroupsRequest) {
        return describeDBShardGroups(DescribeDbShardGroupsRequest.builder().applyMutation(describeDbShardGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns
     * the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to
     * copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon
     * Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make
     * the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     *
     * @param describeDbSnapshotAttributesRequest
     * @return A Java Future containing the result of the DescribeDBSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotAttributesResponse> describeDBSnapshotAttributes(
            DescribeDbSnapshotAttributesRequest describeDbSnapshotAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns
     * the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to
     * copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon
     * Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make
     * the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBSnapshotAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotAttributesResponse> describeDBSnapshotAttributes(
            Consumer<DescribeDbSnapshotAttributesRequest.Builder> describeDbSnapshotAttributesRequest) {
        return describeDBSnapshotAttributes(DescribeDbSnapshotAttributesRequest.builder()
                .applyMutation(describeDbSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Describes the tenant databases that exist in a DB snapshot. This command only applies to RDS for Oracle DB
     * instances in the multi-tenant configuration.
     * </p>
     * <p>
     * You can use this command to inspect the tenant databases within a snapshot before restoring it. You can't
     * directly interact with the tenant databases in a DB snapshot. If you restore a snapshot that was taken from DB
     * instance using the multi-tenant configuration, you restore all its tenant databases.
     * </p>
     *
     * @param describeDbSnapshotTenantDatabasesRequest
     * @return A Java Future containing the result of the DescribeDBSnapshotTenantDatabases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotTenantDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotTenantDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotTenantDatabasesResponse> describeDBSnapshotTenantDatabases(
            DescribeDbSnapshotTenantDatabasesRequest describeDbSnapshotTenantDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the tenant databases that exist in a DB snapshot. This command only applies to RDS for Oracle DB
     * instances in the multi-tenant configuration.
     * </p>
     * <p>
     * You can use this command to inspect the tenant databases within a snapshot before restoring it. You can't
     * directly interact with the tenant databases in a DB snapshot. If you restore a snapshot that was taken from DB
     * instance using the multi-tenant configuration, you restore all its tenant databases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotTenantDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbSnapshotTenantDatabasesRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotTenantDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDBSnapshotTenantDatabases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotTenantDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotTenantDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotTenantDatabasesResponse> describeDBSnapshotTenantDatabases(
            Consumer<DescribeDbSnapshotTenantDatabasesRequest.Builder> describeDbSnapshotTenantDatabasesRequest) {
        return describeDBSnapshotTenantDatabases(DescribeDbSnapshotTenantDatabasesRequest.builder()
                .applyMutation(describeDbSnapshotTenantDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshotTenantDatabases(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotTenantDatabasesPublisher publisher = client.describeDBSnapshotTenantDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotTenantDatabasesPublisher publisher = client.describeDBSnapshotTenantDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshotTenantDatabases(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSnapshotTenantDatabasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotTenantDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotTenantDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBSnapshotTenantDatabasesPublisher describeDBSnapshotTenantDatabasesPaginator(
            DescribeDbSnapshotTenantDatabasesRequest describeDbSnapshotTenantDatabasesRequest) {
        return new DescribeDBSnapshotTenantDatabasesPublisher(this, describeDbSnapshotTenantDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshotTenantDatabases(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotTenantDatabasesPublisher publisher = client.describeDBSnapshotTenantDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotTenantDatabasesPublisher publisher = client.describeDBSnapshotTenantDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshotTenantDatabases(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotTenantDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbSnapshotTenantDatabasesRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotTenantDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshotTenantDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotTenantDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBSnapshotTenantDatabasesPublisher describeDBSnapshotTenantDatabasesPaginator(
            Consumer<DescribeDbSnapshotTenantDatabasesRequest.Builder> describeDbSnapshotTenantDatabasesRequest) {
        return describeDBSnapshotTenantDatabasesPaginator(DescribeDbSnapshotTenantDatabasesRequest.builder()
                .applyMutation(describeDbSnapshotTenantDatabasesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbSnapshotsRequest
     * @return A Java Future containing the result of the DescribeDBSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotsResponse> describeDBSnapshots(
            DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDBSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotsResponse> describeDBSnapshots(
            Consumer<DescribeDbSnapshotsRequest.Builder> describeDbSnapshotsRequest) {
        return describeDBSnapshots(DescribeDbSnapshotsRequest.builder().applyMutation(describeDbSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDbSnapshotsResponse> describeDBSnapshots() {
        return describeDBSnapshots(DescribeDbSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher publisher = client.describeDBSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher publisher = client.describeDBSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBSnapshotsPublisher describeDBSnapshotsPaginator() {
        return describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher publisher = client.describeDBSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher publisher = client.describeDBSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param describeDbSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBSnapshotsPublisher describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        return new DescribeDBSnapshotsPublisher(this, describeDbSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher publisher = client.describeDBSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher publisher = client.describeDBSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSnapshotNotFoundException <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB
     *         snapshot.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBSnapshotsPublisher describeDBSnapshotsPaginator(
            Consumer<DescribeDbSnapshotsRequest.Builder> describeDbSnapshotsRequest) {
        return describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest.builder().applyMutation(describeDbSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().applyMutation(describeDbSubnetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDBSubnetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDbSubnetGroupsResponse> describeDBSubnetGroups() {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator() {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        return new DescribeDBSubnetGroupsPublisher(this, describeDbSubnetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher publisher = client.describeDBSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DbSubnetGroupNotFoundException <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet
     *         group.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsPublisher describeDBSubnetGroupsPaginator(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder()
                .applyMutation(describeDbSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEngineDefaultClusterParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEngineDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEngineDefaultClusterParameters operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultClusterParametersResponse> describeEngineDefaultClusterParameters(
            Consumer<DescribeEngineDefaultClusterParametersRequest.Builder> describeEngineDefaultClusterParametersRequest) {
        return describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.builder()
                .applyMutation(describeEngineDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEngineDefaultParameters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEngineDefaultParametersResponse> describeEngineDefaultParameters(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) {
        return new DescribeEngineDefaultParametersPublisher(this, describeEngineDefaultParametersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersPublisher publisher = client.describeEngineDefaultParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersPublisher describeEngineDefaultParametersPaginator(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest) {
        return describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories() {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions() {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator() {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        return new DescribeEventSubscriptionsPublisher(this, describeEventSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionNotFoundException The subscription name does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeEventsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            DescribeExportTasksRequest describeExportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeExportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeExportTasksResponse> describeExportTasks(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) {
        return describeExportTasks(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksPublisher publisher = client.describeExportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksPublisher publisher = client.describeExportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation.</b>
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExportTasksPublisher describeExportTasksPaginator(DescribeExportTasksRequest describeExportTasksRequest) {
        return new DescribeExportTasksPublisher(this, describeExportTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksPublisher publisher = client.describeExportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksPublisher publisher = client.describeExportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ExportTaskNotFoundException The export task doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExportTasksPublisher describeExportTasksPaginator(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) {
        return describeExportTasksPaginator(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeGlobalClustersRequest
     * @return A Java Future containing the result of the DescribeGlobalClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalClustersResponse> describeGlobalClusters(
            DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalClustersRequest#builder()}
     * </p>
     *
     * @param describeGlobalClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGlobalClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalClustersResponse> describeGlobalClusters(
            Consumer<DescribeGlobalClustersRequest.Builder> describeGlobalClustersRequest) {
        return describeGlobalClusters(DescribeGlobalClustersRequest.builder().applyMutation(describeGlobalClustersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeGlobalClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGlobalClustersResponse> describeGlobalClusters() {
        return describeGlobalClusters(DescribeGlobalClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersPublisher describeGlobalClustersPaginator() {
        return describeGlobalClustersPaginator(DescribeGlobalClustersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalClustersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersPublisher describeGlobalClustersPaginator(
            DescribeGlobalClustersRequest describeGlobalClustersRequest) {
        return new DescribeGlobalClustersPublisher(this, describeGlobalClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher publisher = client.describeGlobalClustersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalClustersRequest#builder()}
     * </p>
     *
     * @param describeGlobalClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>GlobalClusterNotFoundException The <code>GlobalClusterIdentifier</code> doesn't refer to an existing
     *         global database cluster.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersPublisher describeGlobalClustersPaginator(
            Consumer<DescribeGlobalClustersRequest.Builder> describeGlobalClustersRequest) {
        return describeGlobalClustersPaginator(DescribeGlobalClustersRequest.builder()
                .applyMutation(describeGlobalClustersRequest).build());
    }

    /**
     * <p>
     * Describe one or more zero-ETL integrations with Amazon Redshift.
     * </p>
     *
     * @param describeIntegrationsRequest
     * @return A Java Future containing the result of the DescribeIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeIntegrationsResponse> describeIntegrations(
            DescribeIntegrationsRequest describeIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe one or more zero-ETL integrations with Amazon Redshift.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIntegrationsRequest#builder()}
     * </p>
     *
     * @param describeIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeIntegrationsResponse> describeIntegrations(
            Consumer<DescribeIntegrationsRequest.Builder> describeIntegrationsRequest) {
        return describeIntegrations(DescribeIntegrationsRequest.builder().applyMutation(describeIntegrationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeIntegrations(software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeIntegrationsPublisher publisher = client.describeIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeIntegrationsPublisher publisher = client.describeIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeIntegrations(software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeIntegrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeIntegrationsPublisher describeIntegrationsPaginator(DescribeIntegrationsRequest describeIntegrationsRequest) {
        return new DescribeIntegrationsPublisher(this, describeIntegrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeIntegrations(software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeIntegrationsPublisher publisher = client.describeIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeIntegrationsPublisher publisher = client.describeIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeIntegrations(software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIntegrationsRequest#builder()}
     * </p>
     *
     * @param describeIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeIntegrationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>IntegrationNotFoundException The specified integration could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeIntegrationsPublisher describeIntegrationsPaginator(
            Consumer<DescribeIntegrationsRequest.Builder> describeIntegrationsRequest) {
        return describeIntegrationsPaginator(DescribeIntegrationsRequest.builder().applyMutation(describeIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes all available options for the specified engine.
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     * @return A Java Future containing the result of the DescribeOptionGroupOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptionGroupOptionsResponse> describeOptionGroupOptions(
            DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all available options for the specified engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptionGroupOptionsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeOptionGroupOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptionGroupOptionsResponse> describeOptionGroupOptions(
            Consumer<DescribeOptionGroupOptionsRequest.Builder> describeOptionGroupOptionsRequest) {
        return describeOptionGroupOptions(DescribeOptionGroupOptionsRequest.builder()
                .applyMutation(describeOptionGroupOptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsPublisher publisher = client.describeOptionGroupOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsPublisher publisher = client.describeOptionGroupOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptionGroupOptionsPublisher describeOptionGroupOptionsPaginator(
            DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) {
        return new DescribeOptionGroupOptionsPublisher(this, describeOptionGroupOptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsPublisher publisher = client.describeOptionGroupOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsPublisher publisher = client.describeOptionGroupOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptionGroupOptionsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptionGroupOptionsPublisher describeOptionGroupOptionsPaginator(
            Consumer<DescribeOptionGroupOptionsRequest.Builder> describeOptionGroupOptionsRequest) {
        return describeOptionGroupOptionsPaginator(DescribeOptionGroupOptionsRequest.builder()
                .applyMutation(describeOptionGroupOptionsRequest).build());
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     *
     * @param describeOptionGroupsRequest
     * @return A Java Future containing the result of the DescribeOptionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOptionGroupsResponse> describeOptionGroups(
            DescribeOptionGroupsRequest describeOptionGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptionGroupsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeOptionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOptionGroupsResponse> describeOptionGroups(
            Consumer<DescribeOptionGroupsRequest.Builder> describeOptionGroupsRequest) {
        return describeOptionGroups(DescribeOptionGroupsRequest.builder().applyMutation(describeOptionGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeOptionGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOptionGroupsResponse> describeOptionGroups() {
        return describeOptionGroups(DescribeOptionGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher publisher = client.describeOptionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher publisher = client.describeOptionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsPublisher describeOptionGroupsPaginator() {
        return describeOptionGroupsPaginator(DescribeOptionGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher publisher = client.describeOptionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher publisher = client.describeOptionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptionGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsPublisher describeOptionGroupsPaginator(DescribeOptionGroupsRequest describeOptionGroupsRequest) {
        return new DescribeOptionGroupsPublisher(this, describeOptionGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher publisher = client.describeOptionGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher publisher = client.describeOptionGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptionGroupsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OptionGroupNotFoundException The specified option group could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsPublisher describeOptionGroupsPaginator(
            Consumer<DescribeOptionGroupsRequest.Builder> describeOptionGroupsRequest) {
        return describeOptionGroupsPaginator(DescribeOptionGroupsRequest.builder().applyMutation(describeOptionGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the orderable DB instance options for a specified DB engine.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the orderable DB instance options for a specified DB engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeOrderableDBInstanceOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableDbInstanceOptionsResponse> describeOrderableDBInstanceOptions(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest) {
        return describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        return new DescribeOrderableDBInstanceOptionsPublisher(this, describeOrderableDbInstanceOptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsPublisher publisher = client.describeOrderableDBInstanceOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsPublisher describeOrderableDBInstanceOptionsPaginator(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest) {
        return describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <p>
     * This API follows an eventual consistency model. This means that the result of the
     * <code>DescribePendingMaintenanceActions</code> command might not be immediately visible to all subsequent RDS
     * commands. Keep this in mind when you use <code>DescribePendingMaintenanceActions</code> immediately after using a
     * previous API command such as <code>ApplyPendingMaintenanceActions</code>.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <p>
     * This API follows an eventual consistency model. This means that the result of the
     * <code>DescribePendingMaintenanceActions</code> command might not be immediately visible to all subsequent RDS
     * commands. Keep this in mind when you use <code>DescribePendingMaintenanceActions</code> immediately after using a
     * previous API command such as <code>ApplyPendingMaintenanceActions</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <p>
     * This API follows an eventual consistency model. This means that the result of the
     * <code>DescribePendingMaintenanceActions</code> command might not be immediately visible to all subsequent RDS
     * commands. Keep this in mind when you use <code>DescribePendingMaintenanceActions</code> immediately after using a
     * previous API command such as <code>ApplyPendingMaintenanceActions</code>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions() {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator() {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        return new DescribePendingMaintenanceActionsPublisher(this, describePendingMaintenanceActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource ID was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     * @return A Java Future containing the result of the DescribeReservedDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstanceNotFoundException The specified reserved DB Instance not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedDbInstancesResponse> describeReservedDBInstances(
            DescribeReservedDbInstancesRequest describeReservedDbInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedDbInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeReservedDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstanceNotFoundException The specified reserved DB Instance not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedDbInstancesResponse> describeReservedDBInstances(
            Consumer<DescribeReservedDbInstancesRequest.Builder> describeReservedDbInstancesRequest) {
        return describeReservedDBInstances(DescribeReservedDbInstancesRequest.builder()
                .applyMutation(describeReservedDbInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedDBInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstanceNotFoundException The specified reserved DB Instance not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedDbInstancesResponse> describeReservedDBInstances() {
        return describeReservedDBInstances(DescribeReservedDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     * @return A Java Future containing the result of the DescribeReservedDBInstancesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> describeReservedDBInstancesOfferings(
            DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedDbInstancesOfferingsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedDbInstancesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeReservedDBInstancesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> describeReservedDBInstancesOfferings(
            Consumer<DescribeReservedDbInstancesOfferingsRequest.Builder> describeReservedDbInstancesOfferingsRequest) {
        return describeReservedDBInstancesOfferings(DescribeReservedDbInstancesOfferingsRequest.builder()
                .applyMutation(describeReservedDbInstancesOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReservedDBInstancesOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedDbInstancesOfferingsResponse> describeReservedDBInstancesOfferings() {
        return describeReservedDBInstancesOfferings(DescribeReservedDbInstancesOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher publisher = client.describeReservedDBInstancesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher publisher = client.describeReservedDBInstancesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesOfferingsPublisher describeReservedDBInstancesOfferingsPaginator() {
        return describeReservedDBInstancesOfferingsPaginator(DescribeReservedDbInstancesOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher publisher = client.describeReservedDBInstancesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher publisher = client.describeReservedDBInstancesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesOfferingsPublisher describeReservedDBInstancesOfferingsPaginator(
            DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest) {
        return new DescribeReservedDBInstancesOfferingsPublisher(this, describeReservedDbInstancesOfferingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher publisher = client.describeReservedDBInstancesOfferingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher publisher = client.describeReservedDBInstancesOfferingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedDbInstancesOfferingsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedDbInstancesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstancesOfferingNotFoundException Specified offering does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesOfferingsPublisher describeReservedDBInstancesOfferingsPaginator(
            Consumer<DescribeReservedDbInstancesOfferingsRequest.Builder> describeReservedDbInstancesOfferingsRequest) {
        return describeReservedDBInstancesOfferingsPaginator(DescribeReservedDbInstancesOfferingsRequest.builder()
                .applyMutation(describeReservedDbInstancesOfferingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesPublisher publisher = client.describeReservedDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesPublisher publisher = client.describeReservedDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstanceNotFoundException The specified reserved DB Instance not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesPublisher describeReservedDBInstancesPaginator() {
        return describeReservedDBInstancesPaginator(DescribeReservedDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesPublisher publisher = client.describeReservedDBInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesPublisher publisher = client.describeReservedDBInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ReservedDbInstanceNotFoundException The specified reserved DB Instance not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RdsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample RdsAsyncClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstan