/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIntegrationRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationIdentifier").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::integrationIdentifier)).setter(ModifyIntegrationRequest.setter(Builder::integrationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationIdentifier").build()}).build();
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationName").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::integrationName)).setter(ModifyIntegrationRequest.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()}).build();
    private static final SdkField<String> DATA_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFilter").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::dataFilter)).setter(ModifyIntegrationRequest.setter(Builder::dataFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFilter").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyIntegrationRequest.getter(ModifyIntegrationRequest::description)).setter(ModifyIntegrationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_IDENTIFIER_FIELD, INTEGRATION_NAME_FIELD, DATA_FILTER_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIntegrationRequest.memberNameToFieldInitializer();
    private final String integrationIdentifier;
    private final String integrationName;
    private final String dataFilter;
    private final String description;

    private ModifyIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationIdentifier = builder.integrationIdentifier;
        this.integrationName = builder.integrationName;
        this.dataFilter = builder.dataFilter;
        this.description = builder.description;
    }

    public final String integrationIdentifier() {
        return this.integrationIdentifier;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final String dataFilter() {
        return this.dataFilter;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIntegrationRequest)) {
            return false;
        }
        ModifyIntegrationRequest other = (ModifyIntegrationRequest)((Object)obj);
        return Objects.equals(this.integrationIdentifier(), other.integrationIdentifier()) && Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.dataFilter(), other.dataFilter()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIntegrationRequest").add("IntegrationIdentifier", (Object)this.integrationIdentifier()).add("IntegrationName", (Object)this.integrationName()).add("DataFilter", (Object)this.dataFilter()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.integrationIdentifier()));
            }
            case "IntegrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "DataFilter": {
                return Optional.ofNullable(clazz.cast(this.dataFilter()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("IntegrationIdentifier", INTEGRATION_IDENTIFIER_FIELD);
        map.put("IntegrationName", INTEGRATION_NAME_FIELD);
        map.put("DataFilter", DATA_FILTER_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIntegrationRequest, T> g) {
        return obj -> g.apply((ModifyIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String integrationIdentifier;
        private String integrationName;
        private String dataFilter;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIntegrationRequest model) {
            super(model);
            this.integrationIdentifier(model.integrationIdentifier);
            this.integrationName(model.integrationName);
            this.dataFilter(model.dataFilter);
            this.description(model.description);
        }

        public final String getIntegrationIdentifier() {
            return this.integrationIdentifier;
        }

        public final void setIntegrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
        }

        @Override
        public final Builder integrationIdentifier(String integrationIdentifier) {
            this.integrationIdentifier = integrationIdentifier;
            return this;
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getDataFilter() {
            return this.dataFilter;
        }

        public final void setDataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
        }

        @Override
        public final Builder dataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIntegrationRequest build() {
            return new ModifyIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIntegrationRequest> {
        public Builder integrationIdentifier(String var1);

        public Builder integrationName(String var1);

        public Builder dataFilter(String var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

